/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text;

import edu.cmu.minorthird.text.AnnotatorLoader;
import edu.cmu.minorthird.text.BasicTextLabels;
import edu.cmu.minorthird.text.Details;
import edu.cmu.minorthird.text.MonotonicTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextBase;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.Token;
import edu.cmu.minorthird.text.Trie;
import edu.cmu.minorthird.text.gui.ZoomingTextLabelsViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.Visible;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedTextLabels
implements MonotonicTextLabels,
Visible {
    private static final Logger log = Logger.getLogger(NestedTextLabels.class);
    private MonotonicTextLabels outer;
    private TextLabels inner;
    private Set<String> shadowedProperties = new HashSet<String>();

    public NestedTextLabels(MonotonicTextLabels outer, TextLabels inner) {
        if (outer.getTextBase() != inner.getTextBase()) {
            throw new IllegalArgumentException("mismatched text bases?");
        }
        this.outer = outer;
        this.inner = inner;
    }

    public NestedTextLabels(TextLabels inner) {
        this.outer = new BasicTextLabels(inner.getTextBase());
        this.inner = inner;
    }

    @Override
    public TextBase getTextBase() {
        return this.inner.getTextBase();
    }

    @Override
    public boolean hasDictionary(String dictionary) {
        return this.inner.hasDictionary(dictionary) || this.outer.hasDictionary(dictionary);
    }

    @Override
    public boolean isAnnotatedBy(String s) {
        return this.outer.isAnnotatedBy(s) || this.inner.isAnnotatedBy(s);
    }

    @Override
    public void setAnnotatedBy(String s) {
        this.outer.setAnnotatedBy(s);
    }

    @Override
    public void setAnnotatorLoader(AnnotatorLoader newLoader) {
        this.outer.setAnnotatorLoader(newLoader);
    }

    @Override
    public AnnotatorLoader getAnnotatorLoader() {
        return this.outer.getAnnotatorLoader();
    }

    @Override
    public void defineDictionary(String dictName, Set<String> dict) {
        this.outer.defineDictionary(dictName, dict);
    }

    @Override
    public void defineDictionary(String dictName, List<String> fileNames, boolean ignoreCase) {
        this.outer.defineDictionary(dictName, fileNames, ignoreCase);
    }

    @Override
    public Trie getTrie() {
        return this.outer.getTrie();
    }

    @Override
    public void defineTrie(List<String> phraseList) {
        this.outer.defineTrie(phraseList);
    }

    @Override
    public boolean inDict(Token token, String dictionary) {
        boolean outDict = this.outer.hasDictionary(dictionary);
        boolean innerDict = this.inner.hasDictionary(dictionary);
        if (outDict) {
            return this.outer.inDict(token, dictionary);
        }
        if (innerDict) {
            return this.inner.inDict(token, dictionary);
        }
        throw new IllegalArgumentException("undefined dictionary " + dictionary);
    }

    public void shadowProperty(String prop) {
        this.shadowedProperties.add(prop);
    }

    @Override
    public void setProperty(Token token, String prop, String value) {
        if (this.shadowedProperties.contains(prop)) {
            log.warn("Property " + prop + " has been shadowed");
        } else {
            this.outer.setProperty(token, prop, value);
        }
    }

    @Override
    public void setProperty(Token token, String prop, String value, Details details) {
        if (this.shadowedProperties.contains(prop)) {
            log.warn("Property " + prop + " has been shadowed");
        } else {
            this.outer.setProperty(token, prop, value);
        }
    }

    @Override
    public String getProperty(Token token, String prop) {
        if (this.shadowedProperties.contains(prop)) {
            return null;
        }
        String r = this.outer.getProperty(token, prop);
        return r != null ? r : this.inner.getProperty(token, prop);
    }

    @Override
    public Iterator<Span> getSpansWithProperty(String prop) {
        if (this.shadowedProperties.contains(prop)) {
            return Collections.EMPTY_SET.iterator();
        }
        if (!this.outer.getSpanProperties().contains(prop)) {
            return this.inner.getSpansWithProperty(prop);
        }
        if (!this.inner.getSpanProperties().contains(prop)) {
            return this.outer.getSpansWithProperty(prop);
        }
        return new MyUnionIterator(this.outer.getSpansWithProperty(prop), this.inner.getSpansWithProperty(prop));
    }

    @Override
    public Iterator<Span> getSpansWithProperty(String prop, String id) {
        if (this.shadowedProperties.contains(prop)) {
            return Collections.EMPTY_SET.iterator();
        }
        if (!this.outer.getSpanProperties().contains(prop)) {
            return this.inner.getSpansWithProperty(prop, id);
        }
        if (!this.inner.getSpanProperties().contains(prop)) {
            return this.outer.getSpansWithProperty(prop, id);
        }
        return new MyUnionIterator(this.outer.getSpansWithProperty(prop, id), this.inner.getSpansWithProperty(prop, id));
    }

    @Override
    public Set<String> getTokenProperties() {
        Set<String> set = this.setUnion(this.outer.getTokenProperties(), this.inner.getTokenProperties());
        set.removeAll(this.shadowedProperties);
        return set;
    }

    @Override
    public void setProperty(Span span, String prop, String value) {
        this.outer.setProperty(span, prop, value);
    }

    @Override
    public void setProperty(Span span, String prop, String value, Details details) {
        this.outer.setProperty(span, prop, value, details);
    }

    @Override
    public String getProperty(Span span, String prop) {
        String r = this.outer.getProperty(span, prop);
        return r != null ? r : this.inner.getProperty(span, prop);
    }

    @Override
    public Set<String> getSpanProperties() {
        return this.setUnion(this.outer.getSpanProperties(), this.inner.getSpanProperties());
    }

    @Override
    public void addToType(Span span, String type) {
        if (!this.inner.hasType(span, type)) {
            this.outer.addToType(span, type);
        }
    }

    @Override
    public void addToType(Span span, String type, Details details) {
        if (!this.inner.hasType(span, type)) {
            this.outer.addToType(span, type, details);
        }
    }

    @Override
    public boolean hasType(Span span, String type) {
        return this.outer.hasType(span, type) || this.inner.hasType(span, type);
    }

    @Override
    public Iterator<Span> instanceIterator(String type) {
        if (!this.outer.isType(type)) {
            return this.inner.instanceIterator(type);
        }
        if (!this.inner.isType(type)) {
            return this.outer.instanceIterator(type);
        }
        return new MyUnionIterator(this.outer.instanceIterator(type), this.inner.instanceIterator(type));
    }

    @Override
    public Iterator<Span> instanceIterator(String type, String documentId) {
        if (!this.outer.isType(type)) {
            return this.inner.instanceIterator(type, documentId);
        }
        if (!this.inner.isType(type)) {
            return this.outer.instanceIterator(type, documentId);
        }
        return new MyUnionIterator(this.outer.instanceIterator(type, documentId), this.inner.instanceIterator(type, documentId));
    }

    @Override
    public Iterator<Span> closureIterator(String type) {
        if (!this.outer.isType(type)) {
            return this.inner.closureIterator(type);
        }
        if (!this.inner.isType(type)) {
            return this.outer.closureIterator(type);
        }
        return new MyUnionIterator(this.outer.closureIterator(type), this.inner.closureIterator(type));
    }

    @Override
    public Iterator<Span> closureIterator(String type, String documentId) {
        if (!this.outer.isType(type)) {
            return this.inner.closureIterator(type, documentId);
        }
        if (!this.inner.isType(type)) {
            return this.outer.closureIterator(type, documentId);
        }
        return new MyUnionIterator(this.outer.closureIterator(type, documentId), this.inner.closureIterator(type, documentId));
    }

    @Override
    public Set<String> getTypes() {
        return this.setUnion(this.outer.getTypes(), this.inner.getTypes());
    }

    @Override
    public Set<Span> getTypeSet(String type, String documentId) {
        return this.setUnion(this.outer.getTypeSet(type, documentId), this.inner.getTypeSet(type, documentId));
    }

    @Override
    public boolean isType(String type) {
        return this.outer.isType(type) || this.inner.isType(type);
    }

    @Override
    public void declareType(String type) {
        if (!this.isType(type)) {
            this.outer.declareType(type);
        }
    }

    @Override
    public Details getDetails(Span span, String type) {
        Details result = this.outer.getDetails(span, type);
        if (result != null) {
            return result;
        }
        return this.inner.getDetails(span, type);
    }

    @Override
    public void require(String annotationType, String fileToLoad) {
        BasicTextLabels.doRequire(this, annotationType, fileToLoad, this.outer.getAnnotatorLoader());
    }

    @Override
    public void require(String annotationType, String fileToLoad, AnnotatorLoader loader) {
        BasicTextLabels.doRequire(this, annotationType, fileToLoad, loader);
    }

    @Override
    public void annotateWith(String annotationType, String fileToLoad) {
        BasicTextLabels.annotateWith(this, annotationType, fileToLoad);
    }

    @Override
    public String showTokenProp(TextBase base, String prop) {
        return "outer: " + this.outer.showTokenProp(base, prop) + " inner: " + this.inner.showTokenProp(base, prop);
    }

    private <T> Set<T> setUnion(Set<T> a, Set<T> b) {
        if (a.isEmpty()) {
            return b;
        }
        HashSet<T> u = new HashSet<T>();
        u.addAll(a);
        u.addAll(b);
        return u;
    }

    @Override
    public Viewer toGUI() {
        return new ZoomingTextLabelsViewer(this);
    }

    public String toString() {
        return "[NestedLabels: outer=" + this.outer + "; inner=" + this.inner + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyUnionIterator
    implements Iterator<Span> {
        Iterator<Span> i;
        Iterator<Span> j;
        Iterator<Span> currentLooper;
        int estSize = -1;

        public MyUnionIterator(Iterator<Span> i, Iterator<Span> j) {
            this.i = i;
            this.j = j;
            this.currentLooper = i;
        }

        @Override
        public void remove() {
            this.currentLooper.remove();
        }

        @Override
        public boolean hasNext() {
            return this.currentLooper.hasNext() || this.currentLooper == this.i && this.j.hasNext();
        }

        @Override
        public Span next() {
            if (this.currentLooper == this.i && !this.currentLooper.hasNext()) {
                this.currentLooper = this.j;
            }
            return this.currentLooper.next();
        }

        public int estimatedSize() {
            return this.estSize;
        }
    }
}

