/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text;

import edu.cmu.minorthird.text.BasicTextLabels;
import edu.cmu.minorthird.text.Details;
import edu.cmu.minorthird.text.MutableTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextBase;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.util.ProgressCounter;
import edu.cmu.minorthird.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextLabelsLoader {
    private static Logger log = Logger.getLogger(TextLabelsLoader.class);
    public static final int CLOSE_ALL_TYPES = 1;
    public static final int CLOSE_TYPES_IN_LABELED_DOCS = 2;
    public static final int DONT_CLOSE_TYPES = 3;
    public static final int CLOSE_BY_OPERATION = 4;
    public static final String[] CLOSURE_NAMES = new String[]{"CLOSE_ALL_TYPES", "CLOSE_TYPES_IN_LABELED_DOCS", "DONT_CLOSE_TYPES", "CLOSE_BY_OPERATION"};
    private int closurePolicy = 4;
    private int warnings = 0;
    private static final int MAX_WARNINGS = 10;

    public void setClosurePolicy(int policy) {
        this.closurePolicy = policy;
    }

    public MutableTextLabels loadOps(TextBase base, File file) throws IOException, FileNotFoundException {
        BasicTextLabels labels = new BasicTextLabels(base);
        this.importOps(labels, base, file);
        return labels;
    }

    public void importOps(MutableTextLabels labels, TextBase base, File file) throws IOException, FileNotFoundException {
        base = labels.getTextBase();
        if (base == null) {
            throw new IllegalStateException("TextBase attached to labels must not be null");
        }
        LineNumberReader in = new LineNumberReader(new FileReader(file));
        String line = null;
        ArrayList<String> docList = new ArrayList<String>();
        try {
            while ((line = in.readLine()) != null) {
                String docId;
                String op;
                if (line.trim().length() == 0 || line.startsWith("#")) continue;
                log.debug("read line #" + in.getLineNumber() + ": " + line);
                StringTokenizer tok = new StringTokenizer(line);
                try {
                    op = this.advance(tok, in, file);
                }
                catch (IllegalArgumentException e) {
                    throw TextLabelsLoader.getNewException(e, ", failed to find operation.");
                }
                if ("addToType".equals(op)) {
                    this.addToType(tok, in, file, base, labels);
                    continue;
                }
                if ("setSpanProp".equals(op)) {
                    this.setSpanProp(tok, in, file, base, labels);
                    continue;
                }
                if ("closeType".equals(op)) {
                    docId = this.advance(tok, in, file);
                    String type = this.advance(tok, in, file);
                    Span span = base.documentSpan(docId);
                    if (span != null) {
                        labels.closeTypeInside(type, span);
                        log.debug("closed " + type + " on " + docId);
                        continue;
                    }
                    ++this.warnings;
                    if (this.warnings < 10) {
                        log.warn("unknown id '" + docId + "' in closeType");
                        continue;
                    }
                    if (this.warnings != 10) continue;
                    log.warn("there will be no more warnings of this sort given");
                    continue;
                }
                if ("closeAllTypes".equalsIgnoreCase(op)) {
                    docId = this.advance(tok, in, file);
                    docList.add(docId);
                    continue;
                }
                throw new IllegalArgumentException("error on line " + in.getLineNumber() + " of " + file.getName());
            }
            for (int i = 0; i < docList.size(); ++i) {
                String docId = (String)docList.get(i);
                Span span = base.documentSpan(docId);
                this.closeLabels(labels.getTypes(), labels, span);
            }
        }
        catch (IllegalArgumentException e) {
            throw TextLabelsLoader.getNewException(e, " on line: " + line);
        }
        in.close();
        this.closeLabels(labels, this.closurePolicy);
    }

    private void addToType(StringTokenizer tok, LineNumberReader in, File file, TextBase base, MutableTextLabels labels) {
        String id = this.advance(tok, in, file);
        String loStr = this.advance(tok, in, file);
        String lenStr = this.advance(tok, in, file);
        String type = this.advance(tok, in, file);
        String confidence = tok.hasMoreTokens() ? this.advance(tok, in, file) : null;
        try {
            int lo = Integer.parseInt(loStr);
            int len = Integer.parseInt(lenStr);
            Span span = base.documentSpan(id);
            if (span == null) {
                ++this.warnings;
                if (this.warnings < 10) {
                    log.warn("unknown id '" + id + "' in addToType " + lo + " " + len);
                } else if (this.warnings == 10) {
                    log.warn("there will be no more warnings of this sort given");
                }
            } else {
                Details details = null;
                if (confidence != null) {
                    details = new Details(StringUtil.atof(confidence));
                }
                if (lo == 0 && len < 0) {
                    labels.addToType(span, type, details);
                } else {
                    if (len < 0) {
                        len = span.asString().length() - lo;
                    }
                    labels.addToType(span.charIndexSubSpan(lo, lo + len), type, details);
                }
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("bad number on line " + in.getLineNumber() + " of " + file.getName());
        }
    }

    private void setSpanProp(StringTokenizer tok, LineNumberReader in, File file, TextBase base, MutableTextLabels labels) {
        String id = this.advance(tok, in, file);
        String loStr = this.advance(tok, in, file);
        String lenStr = this.advance(tok, in, file);
        String prop = this.advance(tok, in, file);
        String value = this.advance(tok, in, file);
        try {
            int lo = Integer.parseInt(loStr);
            int len = Integer.parseInt(lenStr);
            Span span = base.documentSpan(id);
            if (span == null) {
                ++this.warnings;
                if (this.warnings < 10) {
                    log.warn("unknown id '" + id + "'");
                } else if (this.warnings == 10) {
                    log.warn("there will be no more warnings of this sort given");
                }
            } else if (lo == 0 && len < 0) {
                labels.setProperty(span, prop, value);
            } else {
                if (len < 0) {
                    len = span.asString().length() - lo;
                }
                labels.setProperty(span.charIndexSubSpan(lo, lo + len), prop, value);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("bad number on line " + in.getLineNumber() + " of " + file.getName());
        }
    }

    private static IllegalArgumentException getNewException(IllegalArgumentException e, String addToMsg) {
        String msg = e.getMessage() + addToMsg;
        StackTraceElement[] trace = e.getStackTrace();
        IllegalArgumentException exception = new IllegalArgumentException(msg);
        exception.setStackTrace(trace);
        return exception;
    }

    private String advance(StringTokenizer tok, LineNumberReader in, File file) {
        if (!tok.hasMoreTokens()) {
            throw new IllegalArgumentException("error on line " + in.getLineNumber() + " of " + file.getName() + " failed to find token");
        }
        return tok.nextToken();
    }

    public void closeLabels(MutableTextLabels labels, int policy) {
        Set<String> types2 = labels.getTypes();
        TextBase base = labels.getTextBase();
        switch (policy) {
            case 1: {
                Iterator<Span> i = base.documentSpanIterator();
                while (i.hasNext()) {
                    Span document = i.next();
                    this.closeLabels(types2, labels, document);
                }
                break;
            }
            case 2: {
                TreeSet<Span> labeledDocs = new TreeSet<Span>();
                for (String type : types2) {
                    Iterator<Span> i = labels.instanceIterator(type);
                    while (i.hasNext()) {
                        Span span = i.next();
                        labeledDocs.add(span.documentSpan());
                    }
                }
                for (Span document : labeledDocs) {
                    this.closeLabels(types2, labels, document);
                }
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                log.warn("closure policy(" + policy + ") not recognized");
            }
        }
    }

    private void closeLabels(Set<String> types2, MutableTextLabels labels, Span document) {
        for (String type : types2) {
            labels.closeTypeInside(type, document);
        }
    }

    public MutableTextLabels loadSerialized(File file, TextBase base) throws IOException, FileNotFoundException {
        try {
            ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            MutableTextLabels labels = (MutableTextLabels)in.readObject();
            labels.setTextBase(base);
            in.close();
            return labels;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("can't read TextLabels from " + file + ": " + e);
        }
    }

    public void saveSerialized(MutableTextLabels labels, File file) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        out.writeObject(labels);
        out.flush();
        out.close();
    }

    public String printTypesAsOps(TextLabels labels) {
        Span s;
        Iterator<Span> j;
        StringBuffer out = new StringBuffer();
        ProgressCounter pc = new ProgressCounter("saving labels", "type", labels.getTypes().size());
        for (String type : labels.getTypes()) {
            ProgressCounter pc2 = new ProgressCounter("saving type " + type, "span");
            j = labels.instanceIterator(type);
            while (j.hasNext()) {
                s = j.next();
                if (s.size() > 0) {
                    int lo = s.getTextToken(0).getLo();
                    int hi = s.getTextToken(s.size() - 1).getHi();
                    Details details = labels.getDetails(s, type);
                    if (details == null || details == Details.DEFAULT) {
                        out.append("addToType " + s.getDocumentId() + " " + lo + " " + (hi - lo) + " " + type + "\n");
                    } else {
                        out.append("addToType " + s.getDocumentId() + " " + lo + " " + (hi - lo) + " " + type + " " + details.getConfidence() + "\n");
                    }
                } else {
                    ++this.warnings;
                    if (this.warnings < 10) {
                        log.warn("forgetting label on empty span type " + type + ": " + s);
                    } else if (this.warnings == 10) {
                        log.warn("there will be no more warnings of this sort given");
                    }
                }
                pc2.progress();
            }
            pc2.finished();
            Iterator<Span> it = labels.closureIterator(type);
            while (it.hasNext()) {
                s = it.next();
                Span doc = s.documentSpan();
                if (s.size() != doc.size()) {
                    throw new UnsupportedOperationException("can't save environment with closureSpans!=docSpans");
                }
                out.append("closeType " + s.getDocumentId() + " " + type + "\n");
            }
            pc.progress();
        }
        pc.finished();
        ProgressCounter pc3 = new ProgressCounter("saving labels", "property", labels.getSpanProperties().size());
        for (String prop : labels.getSpanProperties()) {
            j = labels.getSpansWithProperty(prop);
            while (j.hasNext()) {
                s = j.next();
                String val = labels.getProperty(s, prop);
                int lo = s.getTextToken(0).getLo();
                int hi = s.getTextToken(s.size() - 1).getHi();
                out.append("setSpanProp " + s.getDocumentId() + "  " + lo + " " + (hi - lo) + " " + prop + " " + val + "\n");
            }
            pc3.progress();
        }
        pc3.finished();
        return out.toString();
    }

    public void saveTypesAsOps(TextLabels labels, File file) throws IOException {
        PrintStream out = new PrintStream(new FileOutputStream(file));
        out.println(this.printTypesAsOps(labels));
        out.close();
    }

    public void saveTypesAsStrings(TextLabels labels, File file, boolean includeOffset) throws IOException {
        PrintStream out = new PrintStream(new FileOutputStream(file));
        for (String type : labels.getTypes()) {
            Iterator<Span> i = labels.instanceIterator(type);
            while (i.hasNext()) {
                Span span = i.next();
                out.print(type);
                if (includeOffset) {
                    out.print(":" + span.getDocumentId() + ":" + span.getTextToken(0).getLo() + ":" + span.getTextToken(span.size() - 1).getHi());
                }
                out.println("\t" + span.asString().replace('\n', ' '));
            }
        }
        out.close();
    }

    public void saveDocsWithEmbeddedTypes(TextLabels labels, File dir) throws IOException {
        Iterator<Span> looper = labels.getTextBase().documentSpanIterator();
        if (!dir.mkdir()) {
            throw new IOException("Could not create directory named: " + dir);
        }
        while (looper.hasNext()) {
            Span currDoc = looper.next();
            PrintStream out = new PrintStream(new FileOutputStream(new File(dir + "/" + currDoc.getDocumentId())));
            out.println(this.createXMLmarkup(currDoc.getDocumentId(), labels));
            out.close();
        }
    }

    public String markupDocumentSpan(String documentId, TextLabels labels) {
        TreeMap<Span, Set<String[]>> boundaries = new TreeMap<Span, Set<String[]>>();
        for (String type : labels.getTypes()) {
            Iterator<Span> j = labels.instanceIterator(type, documentId);
            while (j.hasNext()) {
                Span s = j.next();
                this.setBoundary(boundaries, "begin", type, s.getLeftBoundary());
                this.setBoundary(boundaries, "end", type, s.getRightBoundary());
            }
        }
        String source = labels.getTextBase().documentSpan(documentId).asString();
        StringBuffer buf = new StringBuffer("");
        buf.append("<root>");
        int currentPos = 0;
        TreeSet<String> currentTypes = new TreeSet<String>();
        String lastMarkup = null;
        for (Span b : boundaries.keySet()) {
            Set ops = (Set)boundaries.get(b);
            for (String[] op : ops) {
                if ("begin".equals(op[0])) {
                    currentTypes.add(op[1]);
                    continue;
                }
                currentTypes.remove(op[1]);
            }
            int pos = b.documentSpanStartIndex() < b.documentSpan().size() ? b.documentSpan().subSpan(b.documentSpanStartIndex(), 1).getTextToken(0).getLo() : b.documentSpan().getTextToken(b.documentSpan().size() - 1).getHi();
            buf.append(source.substring(currentPos, pos));
            if (lastMarkup != null) {
                buf.append("</" + lastMarkup + ">");
            }
            String markup = null;
            String value = null;
            if (currentTypes.size() == 1) {
                markup = (String)currentTypes.iterator().next();
            } else if (currentTypes.size() > 1) {
                markup = "overlap";
                StringBuffer vBuf = new StringBuffer("");
                Iterator j = currentTypes.iterator();
                while (j.hasNext()) {
                    if (vBuf.length() > 0) {
                        vBuf.append(",");
                    }
                    vBuf.append((String)j.next());
                }
                value = vBuf.toString();
            }
            if (markup != null && value != null) {
                buf.append("<" + markup + " value=\"" + value + "\">");
            } else if (markup != null) {
                buf.append("<" + markup + ">");
            }
            currentPos = pos;
            lastMarkup = markup;
        }
        buf.append(source.substring(currentPos, source.length()));
        buf.append("</root>");
        return buf.toString();
    }

    public String createXMLmarkup(String documentId, TextLabels labels) {
        Span docSpan = labels.getTextBase().documentSpan(documentId);
        String docString = labels.getTextBase().documentSpan(documentId).getDocumentContents();
        ArrayList<LabelInfo> unsortedLabels = new ArrayList<LabelInfo>();
        for (String type : labels.getTypes()) {
            Iterator<Span> j = labels.instanceIterator(type, documentId);
            while (j.hasNext()) {
                Span s = j.next();
                int start = s.documentSpanStartIndex();
                int end = start + s.size() - 1;
                unsortedLabels.add(new LabelInfo(s, type, start, end));
            }
        }
        ArrayList<LabelInfo> sortedLabels = new ArrayList<LabelInfo>(unsortedLabels.size());
        while (unsortedLabels.size() > 0) {
            LabelInfo curLabel = (LabelInfo)unsortedLabels.remove(0);
            int position = -1;
            boolean overlap = false;
            for (int j = 0; j < sortedLabels.size(); ++j) {
                LabelInfo compLabel = (LabelInfo)sortedLabels.get(j);
                if (curLabel.start < compLabel.start && curLabel.end > compLabel.start && curLabel.end < compLabel.end) {
                    overlap = true;
                } else if (curLabel.start > compLabel.start && curLabel.start < compLabel.end && curLabel.end > compLabel.end) {
                    overlap = true;
                }
                if (curLabel.start >= compLabel.start && (curLabel.start != compLabel.start || curLabel.end < compLabel.end)) continue;
                position = j;
                break;
            }
            if (overlap) {
                throw new IllegalArgumentException("Labels contain overalpping spans, cannot save as XML format.");
            }
            if (position > -1) {
                sortedLabels.add(position, curLabel);
                continue;
            }
            sortedLabels.add(curLabel);
        }
        ArrayList<TagInfo> sortedTags = new ArrayList<TagInfo>(sortedLabels.size() * 2);
        for (int i = 0; i < sortedLabels.size(); ++i) {
            LabelInfo label = (LabelInfo)sortedLabels.get(i);
            sortedTags.add(new TagInfo(label.start, "<" + label.type + ">", true));
        }
        boolean added = false;
        while (sortedLabels.size() > 0) {
            LabelInfo label = (LabelInfo)sortedLabels.remove(0);
            added = false;
            for (int y = 0; y < sortedTags.size(); ++y) {
                TagInfo tag = (TagInfo)sortedTags.get(y);
                if (label.end >= tag.pos) continue;
                sortedTags.add(y, new TagInfo(label.end, "</" + label.type + ">", false));
                added = true;
                break;
            }
            if (added) continue;
            sortedTags.add(new TagInfo(label.end, "</" + label.type + ">", false));
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<root>");
        int docPos = 0;
        int pos = 0;
        while (sortedTags.size() > 0) {
            TagInfo curTag = (TagInfo)sortedTags.remove(0);
            pos = curTag.pos < docSpan.size() ? (curTag.isOpenTag ? docSpan.subSpan(curTag.pos, 1).getTextToken(0).getLo() : docSpan.subSpan(curTag.pos, 1).getTextToken(0).getHi()) : docString.length();
            buffer.append(docString.substring(docPos, pos));
            buffer.append(curTag.tag);
            docPos = pos;
        }
        buffer.append(docString.substring(docPos, docString.length()));
        buffer.append("</root>");
        return buffer.toString();
    }

    private void setBoundary(SortedMap<Span, Set<String[]>> boundaries, String beginOrEnd, String type, Span s) {
        HashSet<String[]> ops = (HashSet<String[]>)boundaries.get(s);
        if (ops == null) {
            ops = new HashSet<String[]>();
            boundaries.put(s, ops);
        }
        ops.add(new String[]{beginOrEnd, type});
    }

    public String saveTypesAsXML(TextLabels labels) {
        StringBuffer buf = new StringBuffer("<extractions>\n");
        for (String type : labels.getTypes()) {
            Iterator<Span> j = labels.instanceIterator(type);
            while (j.hasNext()) {
                Span s = j.next();
                int lo = s.getTextToken(0).getLo();
                int hi = s.getTextToken(s.size() - 1).getHi();
                buf.append("  <" + type + " lo=" + lo + " hi=" + hi + ">" + s.asString() + "</" + type + ">\n");
            }
        }
        buf.append("</extractions>\n");
        return buf.toString();
    }

    private class LabelInfo {
        public Span span;
        public String type;
        public int start;
        public int end;

        public LabelInfo(Span span, String type, int start, int end) {
            this.span = span;
            this.type = type;
            this.start = start;
            this.end = end;
        }
    }

    private class TagInfo {
        public int pos;
        public String tag;
        public boolean isOpenTag;

        public TagInfo(int pos, String tag, boolean isOpenTag) {
            this.pos = pos;
            this.tag = tag;
            this.isOpenTag = isOpenTag;
        }
    }
}

