/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.gui;

import edu.cmu.minorthird.text.BasicTextBase;
import edu.cmu.minorthird.text.MutableTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.SpanDifference;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.TextLabelsLoader;
import edu.cmu.minorthird.text.gui.SpanDocument;
import edu.cmu.minorthird.text.gui.SpanPainter;
import edu.cmu.minorthird.text.gui.StatusMessage;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;

public abstract class ViewerTracker
extends JComponent
implements ListSelectionListener {
    protected static boolean viewEntireDocument = true;
    protected static final String DUMMY_ID = "***dummy id***";
    protected StatusMessage statusMsg;
    protected JList documentList;
    protected SpanPainter spanPainter;
    protected JTextPane editorPane;
    protected JScrollPane editorHolder;
    protected SpanDocument editedDoc;
    protected Span documentSpan;
    protected TextLabels viewLabels;
    protected MutableTextLabels editLabels;
    protected int contextWidth = 0;
    protected File saveAsFile = null;
    protected JButton upButton;
    protected JButton downButton;
    protected JButton saveButton;
    protected JSlider contextWidthSlider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewerTracker(TextLabels viewLabels, MutableTextLabels editLabels, JList documentList, SpanPainter spanPainter, StatusMessage statusMsg) {
        JList jList = documentList;
        synchronized (jList) {
            if (documentList.getModel().getSize() == 0) {
                throw new IllegalArgumentException("can't edit from empty list");
            }
            this.viewLabels = viewLabels;
            this.editLabels = editLabels;
            this.documentList = documentList;
            this.spanPainter = spanPainter;
            this.statusMsg = statusMsg;
            this.editorHolder = new JScrollPane();
            this.saveButton = new JButton(new SaveLabelsAction("Save"));
            this.upButton = new JButton(new MoveDocumentCursor("Up", -1));
            this.downButton = new JButton(new MoveDocumentCursor("Down", 1));
            this.contextWidthSlider = new ContextWidthSlider();
        }
    }

    protected Span nullSpan() {
        BasicTextBase b = new BasicTextBase();
        b.loadDocument(DUMMY_ID, "[" + this.documentList.getModel().getSize() + " spans being viewed.\n" + " Select one to make it appear here.]");
        return b.documentSpanIterator().next();
    }

    public void setViewEntireDocument(boolean flag) {
        viewEntireDocument = flag;
    }

    public void setSaveAs(File file) {
        this.saveAsFile = file;
        System.out.println("saveAsFile -> " + this.saveAsFile);
        this.saveButton.setEnabled(this.saveAsFile != null);
    }

    public void updateViewLabels(TextLabels newLabels) {
        this.viewLabels = newLabels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueChanged(ListSelectionEvent e) {
        JList jList = this.documentList;
        synchronized (jList) {
            Span s = (Span)this.documentList.getSelectedValue();
            if (s != null) {
                this.loadSpan(s);
            } else {
                this.loadSpan(this.nullSpan());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setContextWidth(int contextWidth) {
        JList jList = this.documentList;
        synchronized (jList) {
            this.contextWidth = contextWidth;
            Span s = (Span)this.documentList.getSelectedValue();
            if (s != null) {
                this.loadSpan(s);
            } else {
                this.loadSpan(this.nullSpan());
            }
        }
    }

    protected void loadSpan(Span span) {
        this.documentSpan = viewEntireDocument ? span.documentSpan() : span;
        this.editedDoc = new SpanDocument(this.documentSpan, this.contextWidth);
        this.editorPane = new JTextPane(this.editedDoc);
        Keymap keymap = JTextComponent.getKeymap("default");
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke("UP"), this.upButton.getAction());
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke("control P"), this.upButton.getAction());
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke("DOWN"), this.downButton.getAction());
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke("control N"), this.downButton.getAction());
        this.editorPane.setKeymap(keymap);
        this.editorHolder.getViewport().setView(this.editorPane);
        this.editorHolder.repaint();
        this.statusMsg.display("editing " + this.documentSpan.getDocumentId() + " " + this.documentSpan);
        this.editorPane.requestFocus();
        this.loadSpanHook();
    }

    protected void loadSpanHook() {
    }

    protected void importDocumentListMarkup(String documentId) {
        if (!DUMMY_ID.equals(this.documentSpan.getDocumentId())) {
            AttributeSet[] colors = new AttributeSet[5];
            colors[1] = this.spanPainter.fpColor();
            colors[2] = this.spanPainter.fnColor();
            colors[3] = this.spanPainter.tpColor();
            colors[4] = this.spanPainter.mpColor();
            SpanDifference.Looper i = this.spanPainter.differenceIterator(documentId);
            while (i.hasNext()) {
                Span dspan = i.next();
                int status = i.getStatus();
                this.editedDoc.highlight(dspan, colors[status]);
            }
        }
    }

    protected class MoveDocumentCursor
    extends AbstractAction {
        static final long serialVersionUID = 20080314L;
        private int delta;

        public MoveDocumentCursor(String msg, int delta) {
            super(msg);
            this.delta = delta;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent event) {
            JList jList = ViewerTracker.this.documentList;
            synchronized (jList) {
                int nextCursor;
                int currentCursor = ViewerTracker.this.documentList.getSelectedIndex();
                if (currentCursor < 0) {
                    currentCursor = 0;
                }
                if ((nextCursor = currentCursor + this.delta) < ViewerTracker.this.documentList.getModel().getSize() && nextCursor >= 0) {
                    ViewerTracker.this.documentList.setSelectedIndex(nextCursor);
                }
            }
        }
    }

    protected class ContextWidthSlider
    extends JSlider {
        static final long serialVersionUID = 20080314L;

        public ContextWidthSlider() {
            super(0, 10, 0);
            this.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    ContextWidthSlider slider = (ContextWidthSlider)e.getSource();
                    if (!slider.getValueIsAdjusting()) {
                        int value = slider.getValue();
                        ViewerTracker.this.setContextWidth(value);
                    }
                }
            });
        }
    }

    protected class SaveLabelsAction
    extends AbstractAction {
        static final long serialVersionUID = 20080314L;

        public SaveLabelsAction(String s) {
            super(s);
        }

        public void actionPerformed(ActionEvent event) {
            try {
                System.out.println("saving to file=" + ViewerTracker.this.saveAsFile);
                new TextLabelsLoader().saveTypesAsOps(ViewerTracker.this.editLabels, ViewerTracker.this.saveAsFile);
                ViewerTracker.this.statusMsg.display("Saved in " + ViewerTracker.this.saveAsFile.getName());
            }
            catch (Exception e) {
                ViewerTracker.this.statusMsg.display("Error: " + e);
            }
        }
    }
}

