/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.learn;

import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.text.AbstractAnnotator;
import edu.cmu.minorthird.text.MonotonicTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.learn.SpanFeatureExtractor;
import java.io.Serializable;
import java.util.Iterator;

public class ClassifierAnnotator
extends AbstractAnnotator
implements Serializable {
    private static final long serialVersionUID = 20080306L;
    private SpanFeatureExtractor fe;
    private Classifier c;
    private String spanProp = null;
    private String spanType = null;
    private String candidateType = null;

    public ClassifierAnnotator(SpanFeatureExtractor fe, Classifier c, String spanType, String spanProp, String candidateType) {
        this.fe = fe;
        this.c = c;
        this.spanType = spanType;
        this.spanProp = spanProp;
        this.candidateType = candidateType;
    }

    public ClassifierAnnotator(SpanFeatureExtractor fe, Classifier c, String spanType, String spanProp) {
        this(fe, c, spanType, spanProp, null);
    }

    public SpanFeatureExtractor getFE() {
        return this.fe;
    }

    public Classifier getClassifier() {
        return this.c;
    }

    public String getSpanProperty() {
        return this.spanProp;
    }

    public String getSpanType() {
        return this.spanType;
    }

    public String getCandidateType() {
        return this.candidateType;
    }

    public void doAnnotate(MonotonicTextLabels labels) {
        Iterator<Span> candidateLooper;
        Iterator<Span> i = candidateLooper = this.candidateType != null ? labels.instanceIterator(this.candidateType) : labels.getTextBase().documentSpanIterator();
        while (i.hasNext()) {
            Span s = i.next();
            ClassLabel classOfS = this.c.classification(this.fe.extractInstance(labels, s));
            if (this.spanProp != null) {
                labels.setProperty(s, this.spanProp, classOfS.bestClassName());
                continue;
            }
            if (this.spanType == null || !classOfS.isPositive()) continue;
            labels.addToType(s, this.spanType);
        }
    }

    public String explainAnnotation(TextLabels labels, Span documentSpan) {
        return this.c.explain(this.fe.extractInstance(labels, documentSpan));
    }
}

