/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.learn.experiments;

import bsh.EvalError;
import bsh.Interpreter;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.Splitter;
import edu.cmu.minorthird.classify.experiments.Evaluation;
import edu.cmu.minorthird.classify.experiments.Expt;
import edu.cmu.minorthird.classify.experiments.RandomSplitter;
import edu.cmu.minorthird.classify.experiments.Tester;
import edu.cmu.minorthird.classify.sequential.BatchSequenceClassifierLearner;
import edu.cmu.minorthird.classify.sequential.CrossValidatedSequenceDataset;
import edu.cmu.minorthird.classify.sequential.SequenceClassifier;
import edu.cmu.minorthird.classify.sequential.SequenceClassifierLearner;
import edu.cmu.minorthird.classify.sequential.SequenceDataset;
import edu.cmu.minorthird.text.Annotator;
import edu.cmu.minorthird.text.FancyLoader;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.learn.SequenceAnnotatorLearner;
import edu.cmu.minorthird.text.learn.TextLabelsAnnotatorTeacher;
import edu.cmu.minorthird.ui.Recommended;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import edu.cmu.minorthird.util.gui.Visible;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceAnnotatorExpt {
    private TextLabels labels;
    private Splitter<Example[]> splitter;
    private SequenceClassifierLearner learner;
    private String inputLabel;
    private String tokPropFeats;
    private SequenceDataset sequenceDataset;

    public SequenceAnnotatorExpt(TextLabels labels, Splitter<Example[]> splitter, SequenceClassifierLearner learner, String inputLabel) {
        this(labels, splitter, learner, inputLabel, null);
    }

    public SequenceAnnotatorExpt(TextLabels labels, Splitter<Example[]> splitter, SequenceClassifierLearner learner, String inputLabel, String tokPropFeats) {
        this.labels = labels;
        this.splitter = splitter;
        this.learner = learner;
        this.inputLabel = inputLabel;
        this.tokPropFeats = tokPropFeats;
        TextLabelsAnnotatorTeacher teacher = new TextLabelsAnnotatorTeacher(labels, inputLabel);
        Recommended.TokenFE fe = new Recommended.TokenFE();
        if (tokPropFeats != null) {
            fe.setTokenPropertyFeatures(tokPropFeats);
        }
        final int size = learner.getHistorySize();
        BatchSequenceClassifierLearner dummyLearner = new BatchSequenceClassifierLearner(){

            public void setSchema(ExampleSchema schema) {
            }

            public SequenceClassifier batchTrain(SequenceDataset dataset) {
                return null;
            }

            public int getHistorySize() {
                return size;
            }
        };
        SequenceAnnotatorLearner dummy = new SequenceAnnotatorLearner(dummyLearner, fe){

            public Annotator getAnnotator() {
                return null;
            }
        };
        teacher.train(dummy);
        this.sequenceDataset = dummy.getSequenceDataset();
    }

    public TextLabels getLabels() {
        return this.labels;
    }

    public String getInputLabel() {
        return this.inputLabel;
    }

    public String getTokPropFeats() {
        return this.tokPropFeats;
    }

    public CrossValidatedSequenceDataset crossValidatedDataset() {
        return new CrossValidatedSequenceDataset(this.learner, this.sequenceDataset, this.splitter);
    }

    public Evaluation evaluation() {
        Evaluation e = Tester.evaluate(this.learner, this.sequenceDataset, this.splitter);
        return e;
    }

    public static SequenceClassifierLearner toSeqLearner(String learnerName) {
        try {
            Interpreter interp = new Interpreter();
            interp.eval("import edu.cmu.minorthird.classify.*;");
            interp.eval("import edu.cmu.minorthird.classify.experiments.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.linear.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.trees.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.knn.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.svm.*;");
            interp.eval("import edu.cmu.minorthird.classify.sequential.*;");
            interp.eval("import edu.cmu.minorthird.classify.transform.*;");
            return (SequenceClassifierLearner)interp.eval(learnerName);
        }
        catch (EvalError e) {
            throw new IllegalArgumentException("error parsing learnerName '" + learnerName + "':\n" + e);
        }
    }

    public static void main(String[] args) {
        TextLabels labels = null;
        Splitter<Example[]> splitter = new RandomSplitter<Example[]>();
        SequenceClassifierLearner learner = null;
        String inputLabel = null;
        String tokPropFeats = null;
        String toShow = "eval";
        try {
            int pos = 0;
            while (pos < args.length) {
                String opt;
                if ((opt = args[pos++]).startsWith("-lab")) {
                    labels = FancyLoader.loadTextLabels(args[pos++]);
                    continue;
                }
                if (opt.startsWith("-sp")) {
                    splitter = Expt.toSplitter(args[pos++], Example[].class);
                    continue;
                }
                if (opt.startsWith("-lea")) {
                    learner = SequenceAnnotatorExpt.toSeqLearner(args[pos++]);
                    continue;
                }
                if (opt.startsWith("-i")) {
                    inputLabel = args[pos++];
                    continue;
                }
                if (opt.startsWith("-p")) {
                    tokPropFeats = args[pos++];
                    continue;
                }
                if (opt.startsWith("-sh")) {
                    toShow = args[pos++];
                    continue;
                }
                SequenceAnnotatorExpt.usage();
            }
            if (labels == null || learner == null || splitter == null || inputLabel == null) {
                SequenceAnnotatorExpt.usage();
            }
            SequenceAnnotatorExpt expt = new SequenceAnnotatorExpt(labels, splitter, learner, inputLabel, tokPropFeats);
            Visible v = null;
            if (toShow.startsWith("ev")) {
                v = expt.evaluation();
            } else if (toShow.startsWith("all")) {
                v = expt.crossValidatedDataset();
            } else {
                SequenceAnnotatorExpt.usage();
            }
            new ViewerFrame("Evaluation", v.toGUI());
        }
        catch (Exception e) {
            e.printStackTrace();
            SequenceAnnotatorExpt.usage();
        }
    }

    private static void usage() {
        System.out.println("usage: -labels labelsKey -learn learner -input inputLabel -split splitter -show all|eval");
    }
}

