/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.learn.experiments;

import bsh.EvalError;
import bsh.Interpreter;
import edu.cmu.minorthird.classify.OnlineBinaryClassifierLearner;
import edu.cmu.minorthird.classify.Splitter;
import edu.cmu.minorthird.classify.experiments.Expt;
import edu.cmu.minorthird.classify.experiments.FixedTestSetSplitter;
import edu.cmu.minorthird.classify.experiments.RandomSplitter;
import edu.cmu.minorthird.classify.sequential.BatchSequenceClassifierLearner;
import edu.cmu.minorthird.classify.sequential.GenericCollinsLearner;
import edu.cmu.minorthird.text.Annotator;
import edu.cmu.minorthird.text.FancyLoader;
import edu.cmu.minorthird.text.MonotonicTextLabels;
import edu.cmu.minorthird.text.NestedTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.SpanDifference;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.TextLabelsLoader;
import edu.cmu.minorthird.text.gui.TextBaseViewer;
import edu.cmu.minorthird.text.learn.AnnotatorLearner;
import edu.cmu.minorthird.text.learn.Extraction2TaggingReduction;
import edu.cmu.minorthird.text.learn.InsideOutsideReduction;
import edu.cmu.minorthird.text.learn.SampleFE;
import edu.cmu.minorthird.text.learn.SequenceAnnotatorLearner;
import edu.cmu.minorthird.text.learn.TextLabelsAnnotatorTeacher;
import edu.cmu.minorthird.text.learn.experiments.ExtractionEvaluation;
import edu.cmu.minorthird.text.learn.experiments.MonotonicSubTextLabels;
import edu.cmu.minorthird.text.learn.experiments.SequenceAnnotatorExpt;
import edu.cmu.minorthird.text.learn.experiments.SubTextBase;
import edu.cmu.minorthird.text.learn.experiments.SubTextLabels;
import edu.cmu.minorthird.util.ProgressCounter;
import edu.cmu.minorthird.util.StringUtil;
import edu.cmu.minorthird.util.gui.ParallelViewer;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.TransformedViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import edu.cmu.minorthird.util.gui.Visible;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextLabelsExperiment
implements Visible {
    private SampleFE.ExtractionFE fe = new SampleFE.ExtractionFE();
    private Extraction2TaggingReduction reduction = new InsideOutsideReduction();
    private int classWindowSize = 3;
    private TextLabels labels;
    private Splitter<Span> splitter;
    private AnnotatorLearner learner;
    private String inputType;
    private String inputProp;
    private TextLabels testLabelsUsedInSplitter;
    private MonotonicTextLabels fullTestLabels;
    private MonotonicTextLabels[] testLabels;
    private String outputLabel;
    private Annotator[] annotators;
    private static Logger log = Logger.getLogger(TextLabelsExperiment.class);
    private ExtractionEvaluation extractionEval = new ExtractionEvaluation();

    public TextLabelsExperiment(TextLabels labels, Splitter<Span> splitter, String learnerName, String spanType, String spanProp, String outputLabel) {
        this(labels, splitter, learnerName, spanType, spanProp, outputLabel, null);
    }

    public TextLabelsExperiment(TextLabels labels, Splitter<Span> splitter, String learnerName, String spanType, String spanProp, String outputLabel, Extraction2TaggingReduction reduce) {
        if (reduce != null) {
            this.reduction = reduce;
        }
        this.labels = labels;
        this.splitter = splitter;
        this.inputType = spanType;
        this.inputProp = spanProp;
        this.outputLabel = outputLabel;
        this.learner = this.toAnnotatorLearner(learnerName);
        this.learner.setAnnotationType(outputLabel);
    }

    public TextLabelsExperiment(TextLabels labels, Splitter<Span> splitter, AnnotatorLearner learner, String inputType, String outputLabel) {
        this(labels, splitter, null, learner, inputType, null, outputLabel);
    }

    public TextLabelsExperiment(TextLabels labels, Splitter<Span> splitter, TextLabels testLabels, AnnotatorLearner learner, String inputType, String inputProp, String outputLabel) {
        this.labels = labels;
        this.splitter = splitter;
        this.testLabelsUsedInSplitter = testLabels;
        this.inputType = inputType;
        this.inputProp = inputProp;
        this.outputLabel = outputLabel;
        this.learner = learner;
        learner.setAnnotationType(outputLabel);
    }

    public SampleFE.ExtractionFE getFE() {
        return this.fe;
    }

    public void doExperiment() {
        this.splitter.split(this.labels.getTextBase().documentSpanIterator());
        this.annotators = new Annotator[this.splitter.getNumPartitions()];
        TreeSet<Span> allTestDocuments = new TreeSet<Span>();
        for (int i = 0; i < this.splitter.getNumPartitions(); ++i) {
            Iterator<Span> j = this.splitter.getTest(i);
            while (j.hasNext()) {
                allTestDocuments.add(j.next());
            }
        }
        ProgressCounter progressCounter = new ProgressCounter("train/test experiment", "fold", this.splitter.getNumPartitions());
        try {
            SubTextBase fullTestBase = new SubTextBase(this.labels.getTextBase(), allTestDocuments.iterator());
            this.fullTestLabels = new NestedTextLabels(new SubTextLabels(fullTestBase, this.labels));
            this.testLabels = new MonotonicTextLabels[this.splitter.getNumPartitions()];
        }
        catch (SubTextBase.UnknownDocumentException ex) {
            if (this.testLabelsUsedInSplitter == null) {
                throw new IllegalArgumentException("exception: " + ex);
            }
            if (!(this.splitter instanceof FixedTestSetSplitter)) {
                throw new IllegalArgumentException("illegal splitter " + this.splitter);
            }
            this.fullTestLabels = new NestedTextLabels(this.testLabelsUsedInSplitter);
            this.testLabels = new MonotonicTextLabels[1];
            this.testLabels[0] = this.fullTestLabels;
        }
        for (int i = 0; i < this.splitter.getNumPartitions(); ++i) {
            log.info("For partition " + (i + 1) + " of " + this.splitter.getNumPartitions());
            log.info("Creating teacher and train partition...");
            SubTextLabels trainLabels = null;
            try {
                SubTextBase trainBase = new SubTextBase(this.labels.getTextBase(), this.splitter.getTrain(i));
                trainLabels = new SubTextLabels(trainBase, this.labels);
            }
            catch (SubTextBase.UnknownDocumentException ex) {
                throw new IllegalStateException("error building trainBase " + i + ": " + ex);
            }
            TextLabelsAnnotatorTeacher teacher = new TextLabelsAnnotatorTeacher(trainLabels, this.inputType, this.inputProp);
            log.info("Training annotator: inputType=" + this.inputType + " inputProp=" + this.inputProp);
            this.annotators[i] = teacher.train(this.learner);
            log.info("Creating test partition...");
            try {
                SubTextBase testBase = new SubTextBase(this.labels.getTextBase(), this.splitter.getTest(i));
                this.testLabels[i] = new MonotonicSubTextLabels(testBase, this.fullTestLabels);
            }
            catch (SubTextBase.UnknownDocumentException ex) {
                // empty catch block
            }
            log.info("Labeling test partition, size=" + this.testLabels[i].getTextBase().size());
            this.annotators[i].annotate(this.testLabels[i]);
            log.info("Evaluating test partition...");
            this.measurePrecisionRecall("Test partition " + (i + 1), this.testLabels[i], false);
            progressCounter.progress();
        }
        this.measurePrecisionRecall("Overall performance", this.fullTestLabels, true);
        progressCounter.finished();
    }

    public ExtractionEvaluation getEvaluation() {
        return this.extractionEval;
    }

    @Override
    public Viewer toGUI() {
        ParallelViewer v = new ParallelViewer();
        for (int i = 0; i < this.annotators.length; ++i) {
            final int index = i;
            v.addSubView("Annotator " + (i + 1), new TransformedViewer(new SmartVanillaViewer()){
                static final long serialVersionUID = 20080306L;

                public Object transform(Object o) {
                    return TextLabelsExperiment.this.annotators[index];
                }
            });
            v.addSubView("Test set " + (i + 1), new TransformedViewer(new SmartVanillaViewer()){
                static final long serialVersionUID = 20080306L;

                public Object transform(Object o) {
                    return TextLabelsExperiment.this.testLabels[index];
                }
            });
        }
        v.addSubView("Full test set", new TransformedViewer(new SmartVanillaViewer()){
            static final long serialVersionUID = 20080306L;

            public Object transform(Object o) {
                return TextLabelsExperiment.this.fullTestLabels;
            }
        });
        v.addSubView("Evaluation", new TransformedViewer(new SmartVanillaViewer()){
            static final long serialVersionUID = 20080306L;

            public Object transform(Object o) {
                return TextLabelsExperiment.this.extractionEval;
            }
        });
        v.setContent(this);
        return v;
    }

    private void measurePrecisionRecall(String tag, TextLabels labels, boolean isOverallMeasure) {
        if (this.inputType != null) {
            SpanDifference sd = new SpanDifference(labels.instanceIterator(this.outputLabel), labels.instanceIterator(this.inputType), labels.closureIterator(this.inputType));
            System.out.println(tag + ":");
            System.out.println(sd.toSummary());
            this.extractionEval.extend(tag, sd, isOverallMeasure);
        } else {
            HashSet<String> propValues = new HashSet<String>();
            Iterator<Span> i = labels.getSpansWithProperty(this.inputProp);
            while (i.hasNext()) {
                Span s = i.next();
                propValues.add(labels.getProperty(s, this.inputProp));
            }
            SpanDifference[] sd = new SpanDifference[propValues.size()];
            int k = 0;
            for (String val : propValues) {
                sd[k] = new SpanDifference(this.propertyIterator(labels, this.outputLabel, val), this.propertyIterator(labels, this.inputProp, val), labels.getTextBase().documentSpanIterator());
                String tag1 = tag + " for " + this.inputProp + ":" + val;
                System.out.println(tag1 + ":");
                System.out.println(sd[k].toSummary());
                this.extractionEval.extend(tag1, sd[k], false);
                ++k;
            }
            SpanDifference sdAll = new SpanDifference(sd);
            String tag1 = tag + " (micro-averaged) for " + this.inputProp;
            System.out.println(tag1 + ":");
            System.out.println(sdAll.toSummary());
            this.extractionEval.extend(tag1, sdAll, isOverallMeasure);
        }
        if (isOverallMeasure) {
            this.extractionEval.measureTotalSize(labels.getTextBase());
        }
    }

    private Iterator<Span> propertyIterator(TextLabels labels, String prop, String value) {
        ArrayList<Span> accum = new ArrayList<Span>();
        Iterator<Span> i = labels.getSpansWithProperty(prop);
        while (i.hasNext()) {
            Span s = i.next();
            if (value != null && !value.equals(labels.getProperty(s, prop))) continue;
            accum.add(s);
        }
        return accum.iterator();
    }

    public AnnotatorLearner toAnnotatorLearner(String s) {
        try {
            OnlineBinaryClassifierLearner learner = (OnlineBinaryClassifierLearner)Expt.toLearner(s);
            GenericCollinsLearner seqLearner = new GenericCollinsLearner(learner, this.classWindowSize);
            return new SequenceAnnotatorLearner(seqLearner, this.fe, this.reduction);
        }
        catch (IllegalArgumentException ex) {
            try {
                BatchSequenceClassifierLearner seqLearner = (BatchSequenceClassifierLearner)SequenceAnnotatorExpt.toSeqLearner(s);
                return new SequenceAnnotatorLearner(seqLearner, this.fe, this.reduction);
            }
            catch (IllegalArgumentException ex2) {
                try {
                    Interpreter interp = new Interpreter();
                    interp.eval("import edu.cmu.minorthird.text.*;");
                    interp.eval("import edu.cmu.minorthird.text.learn.*;");
                    interp.eval("import edu.cmu.minorthird.classify.*;");
                    interp.eval("import edu.cmu.minorthird.classify.experiments.*;");
                    interp.eval("import edu.cmu.minorthird.classify.algorithms.linear.*;");
                    interp.eval("import edu.cmu.minorthird.classify.algorithms.trees.*;");
                    interp.eval("import edu.cmu.minorthird.classify.algorithms.knn.*;");
                    interp.eval("import edu.cmu.minorthird.classify.algorithms.svm.*;");
                    interp.eval("import edu.cmu.minorthird.classify.sequential.*;");
                    return (AnnotatorLearner)interp.eval(s);
                }
                catch (EvalError e) {
                    throw new IllegalArgumentException("error parsing learnerName '" + s + "':\n" + e);
                }
            }
        }
    }

    public static BatchSequenceClassifierLearner toSeqLearner(String learnerName) {
        try {
            Interpreter interp = new Interpreter();
            interp.eval("import edu.cmu.minorthird.classify.*;");
            interp.eval("import edu.cmu.minorthird.classify.experiments.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.linear.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.trees.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.knn.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.svm.*;");
            interp.eval("import edu.cmu.minorthird.classify.sequential.*;");
            interp.eval("import edu.cmu.minorthird.classify.transform.*;");
            return (BatchSequenceClassifierLearner)interp.eval(learnerName);
        }
        catch (EvalError e) {
            throw new IllegalArgumentException("error parsing learnerName '" + learnerName + "':\n" + e);
        }
    }

    public TextLabels getTestLabels() {
        return this.fullTestLabels;
    }

    public static void main(String[] args) {
        Splitter<Span> splitter = new RandomSplitter<Span>(0.7);
        String outputLabel = "_prediction";
        String learnerName = "new CollinsPerceptronLearner()";
        TextLabels labels = null;
        String spanType = null;
        String spanProp = null;
        String saveFileName = null;
        String show = null;
        String annotationNeeded = null;
        ArrayList<String> featureMods = new ArrayList<String>();
        Extraction2TaggingReduction reduction = null;
        try {
            int pos = 0;
            while (pos < args.length) {
                String opt;
                if ((opt = args[pos++]).startsWith("-lab")) {
                    labels = FancyLoader.loadTextLabels(args[pos++]);
                    continue;
                }
                if (opt.startsWith("-lea")) {
                    learnerName = args[pos++];
                    continue;
                }
                if (opt.startsWith("-split")) {
                    splitter = Expt.toSplitter(args[pos++], Span.class);
                    continue;
                }
                if (opt.startsWith("-in")) {
                    spanType = args[pos++];
                    continue;
                }
                if (opt.startsWith("-spanT")) {
                    spanType = args[pos++];
                    continue;
                }
                if (opt.startsWith("-spanP")) {
                    spanProp = args[pos++];
                    continue;
                }
                if (opt.startsWith("-out")) {
                    outputLabel = args[pos++];
                    continue;
                }
                if (opt.startsWith("-save")) {
                    saveFileName = args[pos++];
                    continue;
                }
                if (opt.startsWith("-show")) {
                    show = args[pos++];
                    continue;
                }
                if (opt.startsWith("-mix")) {
                    annotationNeeded = args[pos++];
                    continue;
                }
                if (opt.startsWith("-fe")) {
                    featureMods.add(args[pos++]);
                    continue;
                }
                if (opt.startsWith("-reduction")) {
                    try {
                        Interpreter interp = new Interpreter();
                        interp.eval("import edu.cmu.minorthird.text.learn.*;");
                        reduction = (Extraction2TaggingReduction)interp.eval(args[pos++]);
                        continue;
                    }
                    catch (EvalError e) {
                        throw new IllegalArgumentException("error parsing reductionName '" + args[pos - 1] + "':\n" + e);
                    }
                }
                TextLabelsExperiment.usage();
                return;
            }
            if (labels == null || learnerName == null || splitter == null || spanProp == null && spanType == null || outputLabel == null) {
                TextLabelsExperiment.usage();
                return;
            }
            if (spanProp != null && spanType != null) {
                TextLabelsExperiment.usage();
                return;
            }
            TextLabelsExperiment expt = new TextLabelsExperiment(labels, splitter, learnerName, spanType, spanProp, outputLabel, reduction);
            if (annotationNeeded != null) {
                expt.getFE().setRequiredAnnotation(annotationNeeded);
                expt.getFE().setAnnotationProvider(annotationNeeded + ".mixup");
                expt.getFE().setTokenPropertyFeatures("*");
                labels.require(annotationNeeded, annotationNeeded + ".mixup");
            }
            for (String mod : featureMods) {
                if (mod.startsWith("window=")) {
                    expt.getFE().setFeatureWindowSize(StringUtil.atoi(mod.substring("window=".length())));
                    System.out.println("fe windowSize => " + expt.getFE().getFeatureWindowSize());
                    continue;
                }
                if (mod.startsWith("charType")) {
                    expt.getFE().setUseCharType(mod.substring("charType".length(), 1).equals("+"));
                    System.out.println("fe windowSize => " + expt.getFE().getUseCharType());
                    continue;
                }
                if (mod.startsWith("charPattern")) {
                    expt.getFE().setUseCompressedCharType(mod.substring("charPattern".length(), 1).equals("+"));
                    System.out.println("fe windowSize => " + expt.getFE().getUseCompressedCharType());
                    continue;
                }
                TextLabelsExperiment.usage();
                return;
            }
            expt.doExperiment();
            if (saveFileName != null) {
                new TextLabelsLoader().saveTypesAsOps(expt.getTestLabels(), new File(saveFileName));
            }
            if (show != null) {
                TextBaseViewer.view(expt.getTestLabels());
                if (show.startsWith("all")) {
                    new ViewerFrame("Experiment", expt.toGUI());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            TextLabelsExperiment.usage();
            return;
        }
    }

    private static void usage() {
        String[] usageLines = new String[]{"usage: options are:", "       -label labelsKey   dataset to load", "       -spanType type     defines the extraction target", "       -spanProp prop     defines the extraction target (specify exactly one of -spanType or -spanProp)", "       -learn learner     Java code to construct the learner, which could be an ", "                          an AnnotatorLearner, a BatchSequenceClassifierLearner, or an OnlineClassifierLearner", "                          - a BatchSequenceClassifierLearner is used to defined a SequenceAnnotatorLearner", "                          and an OnlineClassifierLearner is used to define a GenericCollinsLearner", "                          optional, default \"new CollinsPerceptronLearner()\"", "       -out outputLabel   label assigned to predictions", "                          optional, default _prediction", "       -split splitter    splitter to use, in format used by minorthird.classify.experiments.Expt.toSplitter()", "                          optional, default r70", "       -save fileName     file to save extended TextLabels in (train data + predictions)", "                          optional", "       -show xxxx         how much detail on experiment to show - xxx=all shows the most", "                          optional", "       -mix yyyy          augment feature extracture to first execute 'require yyyy,yyyy.mixup'", "                          optional", "       -fe zzzz           change default feature extractor with one of these options zzzz:", "                          window=K charType+ charType- charPattern+ charPattern-"};
        for (int i = 0; i < usageLines.length; ++i) {
            System.out.println(usageLines[i]);
        }
    }
}

