/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.ui;

import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.experiments.Evaluation;
import edu.cmu.minorthird.classify.experiments.FixedTestSetSplitter;
import edu.cmu.minorthird.classify.experiments.Tester;
import edu.cmu.minorthird.classify.sequential.CrossValidatedSequenceDataset;
import edu.cmu.minorthird.classify.sequential.SequenceDataset;
import edu.cmu.minorthird.ui.CommandLineUtil;
import edu.cmu.minorthird.ui.UIMain;
import edu.cmu.minorthird.util.CommandLineProcessor;
import edu.cmu.minorthird.util.IOUtil;
import edu.cmu.minorthird.util.JointCommandLineProcessor;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.io.IOException;

public class TrainTestTagger
extends UIMain {
    private CommandLineUtil.SaveParams save = new CommandLineUtil.SaveParams();
    private CommandLineUtil.TaggerSignalParams signal = new CommandLineUtil.TaggerSignalParams(this.base);
    private CommandLineUtil.TrainTaggerParams train = new CommandLineUtil.TrainTaggerParams();
    private CommandLineUtil.SplitterParams trainTest = new CommandLineUtil.SplitterParams();
    Object result = null;

    public CommandLineProcessor getCLP() {
        return new JointCommandLineProcessor(new CommandLineProcessor[]{this.gui, this.base, this.signal, this.train, this.trainTest});
    }

    public CommandLineUtil.SaveParams getSaveParameters() {
        return this.save;
    }

    public void setSaveParameters(CommandLineUtil.SaveParams base) {
        this.save = base;
    }

    public CommandLineUtil.TaggerSignalParams getSignalParameters() {
        return this.signal;
    }

    public void setSignalParameters(CommandLineUtil.TaggerSignalParams signal) {
        this.signal = signal;
    }

    public CommandLineUtil.TrainTaggerParams getTrainingParameters() {
        return this.train;
    }

    public void setTrainingParameters(CommandLineUtil.TrainTaggerParams train) {
        this.train = train;
    }

    public CommandLineUtil.SplitterParams getSplitterParameters() {
        return this.trainTest;
    }

    public void setSplitterParameters(CommandLineUtil.SplitterParams trainTest) {
        this.trainTest = trainTest;
    }

    public void doMain() {
        if (this.train.learner == null) {
            throw new IllegalArgumentException("-learner must be specified");
        }
        if (this.signal.tokenProp == null) {
            throw new IllegalArgumentException("-tokenProp must be specified");
        }
        SequenceDataset dataset = CommandLineUtil.toSequenceDataset(this.base.labels, this.train.fe, this.train.learner.getHistorySize(), this.signal.tokenProp);
        if (this.train.showData) {
            new ViewerFrame("Dataset", dataset.toGUI());
        }
        if (this.trainTest.labels != null) {
            SequenceDataset testDataset = CommandLineUtil.toSequenceDataset(this.trainTest.labels, this.train.fe, this.train.learner.getHistorySize(), this.signal.tokenProp);
            this.trainTest.splitter = new FixedTestSetSplitter<Example>(testDataset.iterator());
        }
        CrossValidatedSequenceDataset cvd = null;
        Evaluation evaluation = null;
        if (this.trainTest.showTestDetails) {
            cvd = new CrossValidatedSequenceDataset(this.train.learner, dataset, this.trainTest.splitter);
            evaluation = cvd.getEvaluation();
            this.result = cvd;
        } else {
            cvd = null;
            evaluation = Tester.evaluate(this.train.learner, dataset, this.trainTest.splitter);
            this.result = evaluation;
        }
        if (this.base.showResult) {
            new ViewerFrame("Result", new SmartVanillaViewer(this.result));
        }
        if (this.save.saveAs != null) {
            try {
                IOUtil.saveSerialized(evaluation, this.save.saveAs);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("can't save to " + this.save.saveAs + ": " + e);
            }
        }
        evaluation.summarize();
    }

    public Object getMainResult() {
        return this.result;
    }

    public static void main(String[] args) {
        new TrainTestTagger().callMain(args);
    }
}

