/*
 * Decompiled with CFR 0.152.
 */
package iitb.CRF;

import iitb.CRF.DataSequence;
import iitb.CRF.Feature;
import iitb.CRF.FeatureGenerator;
import iitb.CRF.FeatureGeneratorNested;

public class FeatureGenCache
implements FeatureGeneratorNested {
    private static final long serialVersionUID = 1L;
    FeatureGeneratorNested fgen;
    FeatureGenerator sfgen;
    FeatureImpl feature = new FeatureImpl();
    int numFeatures = 0;
    int scanNum = 0;
    int dataIndex = 0;
    int[] y;
    int[] yprev;
    int[] index;
    float[] val;
    int[] offset;
    int[] endOffset;
    int indexPtr;
    int thisKey;
    int maxKey = 0;
    int numData = 0;
    int maxDataLen = 0;
    int maxSegLen = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FeatureGenCache(FeatureGeneratorNested fgen) {
        this.fgen = fgen;
        this.sfgen = fgen;
        this.numFeatures = 0;
    }

    public FeatureGenCache(FeatureGenerator fgen) {
        this.sfgen = fgen;
        this.numFeatures = 0;
        this.fgen = null;
        if (this.sfgen instanceof FeatureGeneratorNested) {
            this.fgen = (FeatureGeneratorNested)this.sfgen;
        }
    }

    public int maxMemory() {
        return this.sfgen instanceof FeatureGeneratorNested ? ((FeatureGeneratorNested)this.sfgen).maxMemory() : 1;
    }

    public void startDataScan() {
        ++this.scanNum;
        if (this.scanNum == 2) {
            this.y = new int[this.numFeatures];
            this.yprev = new int[this.numFeatures];
            this.index = new int[this.numFeatures];
            this.val = new float[this.numFeatures];
            this.maxKey = this.maxSegLen * this.numData * this.maxDataLen;
            this.offset = new int[this.maxKey + 1];
            this.endOffset = new int[this.maxKey + 1];
            this.numFeatures = 0;
        }
        this.dataIndex = -1;
    }

    public void nextDataIndex() {
        ++this.dataIndex;
        if (this.scanNum == 1) {
            ++this.numData;
        }
    }

    public void startScanFeaturesAt(DataSequence data, int prevPos, int pos) {
        this.startScanFeaturesAt(data, prevPos, pos, true);
    }

    public void startScanFeaturesAt(DataSequence data, int prevPos, int pos, boolean nested) {
        if (!$assertionsDisabled && this.scanNum <= 0) {
            throw new AssertionError();
        }
        this.thisKey = this.dataIndex * this.maxDataLen + pos + (pos - prevPos - 1) * this.maxDataLen * this.numData;
        if (this.scanNum == 1) {
            this.maxSegLen = Math.max(this.maxSegLen, pos - prevPos);
            this.maxDataLen = Math.max(this.maxDataLen, data.length());
        } else if (!$assertionsDisabled && this.thisKey >= this.maxKey + 1) {
            throw new AssertionError();
        }
        if (this.scanNum <= 2) {
            if (nested) {
                this.fgen.startScanFeaturesAt(data, prevPos, pos);
            } else {
                this.sfgen.startScanFeaturesAt(data, pos);
            }
        } else {
            this.indexPtr = this.offset[this.thisKey];
        }
        if (this.scanNum == 2) {
            this.offset[this.thisKey] = this.numFeatures;
            this.endOffset[this.thisKey] = this.numFeatures;
        }
    }

    public int numFeatures() {
        return this.fgen.numFeatures();
    }

    public void startScanFeaturesAt(DataSequence data, int pos) {
        this.startScanFeaturesAt(data, pos - 1, pos, false);
    }

    public boolean hasNext() {
        return this.scanNum <= 2 ? this.sfgen.hasNext() : this.endOffset[this.thisKey] > this.indexPtr;
    }

    public Feature next() {
        if (this.scanNum <= 2) {
            Feature f = this.sfgen.next();
            if (this.scanNum == 2) {
                this.y[this.numFeatures] = f.y();
                this.yprev[this.numFeatures] = f.yprev();
                this.val[this.numFeatures] = f.value();
                this.index[this.numFeatures] = f.index();
                int n = this.thisKey;
                this.endOffset[n] = this.endOffset[n] + 1;
            }
            ++this.numFeatures;
            return f;
        }
        this.feature.init(this.index[this.indexPtr], this.y[this.indexPtr], this.yprev[this.indexPtr], this.val[this.indexPtr]);
        ++this.indexPtr;
        return this.feature;
    }

    public String featureName(int featureIndex) {
        return this.sfgen.featureName(featureIndex);
    }

    static {
        $assertionsDisabled = !FeatureGenCache.class.desiredAssertionStatus();
    }

    class FeatureImpl
    implements Feature {
        int _index;
        int _y;
        int _yprev;
        float _value;

        void init(int _index, int _y, int _yprev, float _value) {
            this._index = _index;
            this._y = _y;
            this._yprev = _yprev;
            this._value = _value;
        }

        public int index() {
            return this._index;
        }

        public int y() {
            return this._y;
        }

        public int yprev() {
            return this._yprev;
        }

        public float value() {
            return this._value;
        }

        public int[] yprevArray() {
            return null;
        }
    }
}

