/*
 * Decompiled with CFR 0.152.
 */
package iitb.CRF;

import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.IntDoubleFunction;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix1D;
import gnu.trove.TIntDoubleHashMap;
import gnu.trove.TIntDoubleIterator;
import iitb.CRF.RobustMath;
import java.util.TreeSet;

class LogSparseDoubleMatrix1DOld
extends SparseDoubleMatrix1D {
    private static final long serialVersionUID = 1L;
    TIntDoubleHashMap elementsZ;
    DoubleDoubleFunctionWrapper funcWrapper = new DoubleDoubleFunctionWrapper();

    static double map(double val) {
        if (val == RobustMath.LOG0) {
            return 0.0;
        }
        if (val == 0.0) {
            return Double.MIN_VALUE;
        }
        return val;
    }

    static double reverseMap(double val) {
        if (val == 0.0) {
            return RobustMath.LOG0;
        }
        if (val == Double.MIN_VALUE) {
            return 0.0;
        }
        return val;
    }

    LogSparseDoubleMatrix1DOld(int numY) {
        super(numY);
        this.elementsZ = new TIntDoubleHashMap();
    }

    public DoubleMatrix1D assign(double val) {
        double newVal = LogSparseDoubleMatrix1DOld.map(val);
        if (newVal != 0.0) {
            for (int i = this.size() - 1; i >= 0; --i) {
                this.setQuick(i, newVal);
            }
        }
        return this;
    }

    public void set(int row, double val) {
        this.setQuick(row, LogSparseDoubleMatrix1DOld.map(val));
    }

    public double get(int row) {
        return LogSparseDoubleMatrix1DOld.reverseMap(this.getQuick(row));
    }

    public double zSum() {
        TreeSet logProbVector = new TreeSet();
        for (int row = 0; row < this.size(); ++row) {
            if (this.getQuick(row) == 0.0) continue;
            RobustMath.addNoDups(logProbVector, this.get(row));
        }
        return RobustMath.logSumExp(logProbVector);
    }

    public DoubleMatrix1D forEachNonZero(IntDoubleFunction func) {
        for (int y = 0; y < this.size(); ++y) {
            if (this.getQuick(y) == 0.0) continue;
            this.setQuick(y, func.apply(y, this.get(y)));
        }
        return this;
    }

    public DoubleMatrix1D assign(DoubleMatrix1D v2, DoubleDoubleFunction func) {
        int row;
        TIntDoubleIterator iter = ((LogSparseDoubleMatrix1DOld)v2).elementsZ.iterator();
        while (iter.hasNext()) {
            iter.advance();
            row = iter.key() - 1;
            this.set(row, func.apply(this.get(row), v2.get(row)));
        }
        iter = this.elementsZ.iterator();
        while (iter.hasNext()) {
            iter.advance();
            row = iter.key() - 1;
            if (v2.getQuick(row) != 0.0) continue;
            this.set(row, func.apply(this.get(row), v2.get(row)));
        }
        return this;
    }

    public double getQuick(int arg0) {
        return this.elementsZ.get(arg0 + 1);
    }

    public DoubleMatrix1D like(int arg0) {
        return null;
    }

    public DoubleMatrix2D like2D(int arg0, int arg1) {
        return null;
    }

    public void setQuick(int arg0, double arg1) {
        if (arg1 != 0.0) {
            this.elementsZ.put(arg0 + 1, arg1);
        }
    }

    protected DoubleMatrix1D viewSelectionLike(int[] arg0) {
        return null;
    }

    static class DoubleDoubleFunctionWrapper
    implements DoubleDoubleFunction {
        DoubleDoubleFunction func;

        DoubleDoubleFunctionWrapper() {
        }

        public double apply(double val1, double val2) {
            return LogSparseDoubleMatrix1DOld.map(this.func.apply(LogSparseDoubleMatrix1DOld.reverseMap(val1), LogSparseDoubleMatrix1DOld.reverseMap(val2)));
        }
    }
}

