/*
 * Decompiled with CFR 0.152.
 */
package iitb.CRF;

import iitb.CRF.CRF;
import iitb.CRF.DataSequence;
import iitb.CRF.FeatureGenerator;
import iitb.CRF.FeatureGeneratorNested;
import iitb.CRF.NestedCollinsTrainer;
import iitb.CRF.NestedTrainer;
import iitb.CRF.NestedViterbi;
import iitb.CRF.SegmentDataSequence;
import iitb.CRF.Trainer;
import iitb.CRF.Util;
import iitb.CRF.Viterbi;
import java.util.Properties;

public class NestedCRF
extends CRF {
    FeatureGeneratorNested featureGenNested;
    transient NestedViterbi nestedViterbi;

    public NestedCRF(int numLabels, FeatureGeneratorNested fgen, String arg) {
        super(numLabels, (FeatureGenerator)fgen, arg);
        this.featureGenNested = fgen;
        this.nestedViterbi = new NestedViterbi(this, 1);
    }

    public NestedCRF(int numLabels, FeatureGeneratorNested fgen, Properties configOptions) {
        super(numLabels, (FeatureGenerator)fgen, configOptions);
        this.featureGenNested = fgen;
        this.nestedViterbi = new NestedViterbi(this, 1);
    }

    protected Trainer getTrainer() {
        if (this.params.trainerType.startsWith("SegmentCollins")) {
            return new NestedCollinsTrainer(this.params);
        }
        return new NestedTrainer(this.params);
    }

    protected Viterbi getViterbi(int beamsize) {
        return new NestedViterbi(this, beamsize);
    }

    public void apply(DataSequence dataSeq) {
        this.apply((SegmentDataSequence)dataSeq);
    }

    public void apply(SegmentDataSequence dataSeq) {
        if (this.nestedViterbi == null) {
            this.nestedViterbi = new NestedViterbi(this, 1);
        }
        if (this.params.debugLvl > 2) {
            Util.printDbg("NestedCRF: Applying on " + dataSeq);
        }
        this.nestedViterbi.bestLabelSequence(dataSeq, this.lambda);
    }
}

