/*
 * Decompiled with CFR 0.152.
 */
package jal.INT;

import jal.INT.BinaryOperator;
import jal.INT.BinaryPredicate;
import jal.INT.Generator;
import jal.INT.Inspection;
import jal.INT.Predicate;
import jal.INT.UnaryOperator;
import java.util.Random;

public final class Modification {
    private static Random default_RNG = new Random();

    public static void copy(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        if (n2 > n) {
            System.arraycopy(nArray, n, nArray2, n3, n2 - n);
        }
    }

    public static void swap_ranges(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        while (n < n2) {
            int n4 = nArray2[n3];
            nArray2[n3] = nArray[n];
            nArray[n] = n4;
            ++n;
            ++n3;
        }
    }

    public static void transform(int[] nArray, int[] nArray2, int n, int n2, int n3, UnaryOperator unaryOperator) {
        while (n < n2) {
            nArray2[n3++] = unaryOperator.apply(nArray[n++]);
        }
    }

    public static void transform(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int n3, int n4, BinaryOperator binaryOperator) {
        while (n < n2) {
            nArray3[n4++] = binaryOperator.apply(nArray[n++], nArray2[n3++]);
        }
    }

    public static void replace(int[] nArray, int n, int n2, int n3, int n4) {
        while (n < n2) {
            if (nArray[n] == n3) {
                nArray[n] = n4;
            }
            ++n;
        }
    }

    public static void replace_if(int[] nArray, int n, int n2, Predicate predicate, int n3) {
        while (n < n2) {
            if (predicate.apply(nArray[n])) {
                nArray[n] = n3;
            }
            ++n;
        }
    }

    public static void replace_copy(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5) {
        while (n < n2) {
            int n6 = nArray[n++];
            int n7 = nArray2[n3++] = n6 == n4 ? n5 : n6;
        }
    }

    public static void replace_copy_if(int[] nArray, int[] nArray2, int n, int n2, int n3, Predicate predicate, int n4) {
        while (n < n2) {
            int n5 = nArray[n++];
            int n6 = nArray2[n3++] = predicate.apply(n5) ? n4 : n5;
        }
    }

    public static void fill(int[] nArray, int n, int n2, int n3) {
        while (n < n2) {
            nArray[n++] = n3;
        }
    }

    public static void generate(int[] nArray, int n, int n2, Generator generator) {
        while (n < n2) {
            nArray[n++] = generator.apply();
        }
    }

    public static int remove_if(int[] nArray, int n, int n2, int n3) {
        int n4 = n2;
        --n;
        while (true) {
            if (++n < n2 && nArray[n] != n3) {
                continue;
            }
            while (n < --n2 && nArray[n2] == n3) {
            }
            if (n >= n2) {
                return n;
            }
            nArray[n] = nArray[n2];
        }
    }

    public static int remove_if(int[] nArray, int n, int n2, Predicate predicate) {
        int n3 = n2;
        --n;
        while (true) {
            if (++n < n2 && !predicate.apply(nArray[n])) {
                continue;
            }
            while (n < --n2 && predicate.apply(nArray[n2])) {
            }
            if (n >= n2) {
                return n;
            }
            nArray[n] = nArray[n2];
        }
    }

    public static int stable_remove(int[] nArray, int n, int n2, int n3) {
        n = Inspection.find(nArray, n, n2, n3);
        int n4 = Inspection.find_not(nArray, n, n2, n3);
        while (n4 < n2) {
            nArray[n++] = nArray[n4];
            ++n4;
            n4 = Inspection.find_not(nArray, n4, n2, n3);
        }
        return n;
    }

    public static int stable_remove_if(int[] nArray, int n, int n2, Predicate predicate) {
        n = Inspection.find_if(nArray, n, n2, predicate);
        int n3 = Inspection.find_if_not(nArray, n, n2, predicate);
        while (n3 < n2) {
            nArray[n++] = nArray[n3];
            ++n3;
            n3 = Inspection.find_if_not(nArray, n3, n2, predicate);
        }
        return n;
    }

    public static int remove_copy(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4) {
        while (n < n2) {
            int n5;
            if ((n5 = nArray[n++]) == n4) continue;
            nArray2[n3++] = n5;
        }
        return n3;
    }

    public static int remove_copy_if(int[] nArray, int[] nArray2, int n, int n2, int n3, Predicate predicate) {
        while (n < n2) {
            int n4;
            if (predicate.apply(n4 = nArray[n++])) continue;
            nArray2[n3++] = n4;
        }
        return n3;
    }

    public static int unique(int[] nArray, int n, int n2) {
        n = Inspection.adjacent_find(nArray, n, n2);
        return Modification.unique_copy(nArray, nArray, n, n2, n);
    }

    public static int unique(int[] nArray, int n, int n2, BinaryPredicate binaryPredicate) {
        n = Inspection.adjacent_find(nArray, n, n2, binaryPredicate);
        return Modification.unique_copy(nArray, nArray, n, n2, n, binaryPredicate);
    }

    public static int unique_copy(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        if (n >= n2) {
            return n3;
        }
        nArray2[n3] = nArray[n];
        while (++n < n2) {
            if (nArray2[n3] == nArray[n]) continue;
            nArray2[++n3] = nArray[n];
        }
        return n3 + 1;
    }

    public static int unique_copy(int[] nArray, int[] nArray2, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        if (n >= n2) {
            return n3;
        }
        nArray2[n3] = nArray[n];
        while (++n < n2) {
            if (binaryPredicate.apply(nArray2[n3], nArray[n])) continue;
            nArray2[++n3] = nArray[n];
        }
        return n3 + 1;
    }

    public static void reverse(int[] nArray, int n, int n2) {
        while (n < --n2) {
            int n3 = nArray[n];
            nArray[n++] = nArray[n2];
            nArray[n2] = n3;
        }
    }

    public static void reverse_copy(int[] nArray, int n, int n2, int n3) {
        while (n2 > n) {
            nArray[n3++] = nArray[--n2];
        }
    }

    public static void reverse_copy(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        while (n2 > n) {
            nArray2[n3++] = nArray[--n2];
        }
    }

    public static void rotate(int[] nArray, int n, int n2, int n3) {
        if (n2 != n && n2 != n3) {
            Modification.reverse(nArray, n, n2);
            Modification.reverse(nArray, n2, n3);
            Modification.reverse(nArray, n, n3);
        }
    }

    public static void rotate_copy(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4) {
        Modification.copy(nArray, nArray2, n2, n3, n4);
        Modification.copy(nArray, nArray2, n, n2, n4 + (n3 - n2));
    }

    public static void random_shuffle(int[] nArray, int n, int n2, Random random2) {
        int n3 = n + 1;
        while (n3 < n2) {
            int n4 = Math.abs(random2.nextInt()) % (n3 - n + 1);
            int n5 = nArray[n4];
            nArray[n4] = nArray[n3];
            nArray[n3] = n5;
            ++n3;
        }
    }

    public static void random_shuffle(int[] nArray, int n, int n2) {
        Modification.random_shuffle(nArray, n, n2, default_RNG);
    }

    public static int partition(int[] nArray, int n, int n2, Predicate predicate) {
        --n;
        while (true) {
            if (++n < n2 && predicate.apply(nArray[n])) {
                continue;
            }
            while (n < --n2 && !predicate.apply(nArray[n2])) {
            }
            if (n >= n2) {
                return n;
            }
            int n3 = nArray[n];
            nArray[n] = nArray[n2];
            nArray[n2] = n3;
        }
    }

    public static int stable_partition(int[] nArray, int n, int n2, Predicate predicate) {
        if (n + 1 < n2) {
            int n3 = n + (n2 - n) / 2;
            int n4 = Modification.stable_partition(nArray, n, n3, predicate);
            int n5 = Modification.stable_partition(nArray, n3, n2, predicate);
            Modification.rotate(nArray, n4, n3, n5);
            return n4 + (n5 - n3);
        }
        if (n >= n2 || !predicate.apply(nArray[n])) {
            return n;
        }
        return n2;
    }

    private Modification() {
    }
}

