/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.annotations.TextAnnotation;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RefineryUtilities;

public class XYTextAnnotation
extends TextAnnotation
implements XYAnnotation,
Cloneable,
Serializable {
    private double x;
    private double y;

    public XYTextAnnotation(String string2, double d, double d2) {
        super(string2);
        this.x = d;
        this.y = d2;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double d) {
        this.x = d;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double d) {
        this.y = d;
    }

    public void draw(Graphics2D graphics2D, XYPlot xYPlot, Rectangle2D rectangle2D, ValueAxis valueAxis, ValueAxis valueAxis2) {
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(xYPlot.getDomainAxisLocation(), plotOrientation);
        RectangleEdge rectangleEdge2 = Plot.resolveRangeAxisLocation(xYPlot.getRangeAxisLocation(), plotOrientation);
        float f = (float)valueAxis.translateValueToJava2D(this.x, rectangle2D, rectangleEdge);
        float f2 = (float)valueAxis2.translateValueToJava2D(this.y, rectangle2D, rectangleEdge2);
        graphics2D.setFont(this.getFont());
        graphics2D.setPaint(this.getPaint());
        RefineryUtilities.drawRotatedString(this.getText(), graphics2D, f, f2, this.getTextAnchor(), this.getRotationAnchor(), this.getRotationAngle());
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

