/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.axis.Tick;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RefineryUtilities;

public class CategoryAxis
extends Axis
implements Cloneable,
Serializable {
    public static final boolean DEFAULT_VERTICAL_CATEGORY_LABELS = false;
    public static final double DEFAULT_AXIS_MARGIN = 0.05;
    public static final double DEFAULT_CATEGORY_MARGIN = 0.2;
    private double lowerMargin = 0.05;
    private double upperMargin = 0.05;
    private double categoryMargin = 0.2;
    private boolean verticalCategoryLabels = false;
    private boolean skipCategoryLabelsToFit;
    private int maxTickLineCount;
    private List categories;
    protected double reservedForTickLabels;
    protected double reservedForAxisLabel;

    public CategoryAxis(String string2) {
        super(string2);
        this.setTickMarksVisible(false);
        this.categories = new ArrayList();
        this.reservedForAxisLabel = 0.0;
        this.reservedForTickLabels = 0.0;
    }

    public double getLowerMargin() {
        return this.lowerMargin;
    }

    public void setLowerMargin(double d) {
        this.lowerMargin = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getUpperMargin() {
        return this.upperMargin;
    }

    public void setUpperMargin(double d) {
        this.upperMargin = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getCategoryMargin() {
        return this.categoryMargin;
    }

    public void setCategoryMargin(double d) {
        this.categoryMargin = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public boolean isVerticalCategoryLabels() {
        return this.verticalCategoryLabels;
    }

    public void setVerticalCategoryLabels(boolean bl) {
        if (this.verticalCategoryLabels != bl) {
            this.verticalCategoryLabels = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean getSkipCategoryLabelsToFit() {
        return this.skipCategoryLabelsToFit;
    }

    public void setSkipCategoryLabelsToFit(boolean bl) {
        if (this.skipCategoryLabelsToFit != bl) {
            this.skipCategoryLabelsToFit = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public double getCategoryJava2DCoordinate(CategoryAnchor categoryAnchor, int n, int n2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d = 0.0;
        if (categoryAnchor == CategoryAnchor.START) {
            d = this.getCategoryStart(n, n2, rectangle2D, rectangleEdge);
        } else if (categoryAnchor == CategoryAnchor.MIDDLE) {
            d = this.getCategoryMiddle(n, n2, rectangle2D, rectangleEdge);
        } else if (categoryAnchor == CategoryAnchor.END) {
            d = this.getCategoryEnd(n, n2, rectangle2D, rectangleEdge);
        }
        return d;
    }

    public double getCategoryStart(int n, int n2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d = 0.0;
        if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
            d = rectangle2D.getX() + rectangle2D.getWidth() * this.getLowerMargin();
        } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
            d = rectangle2D.getMinY() + rectangle2D.getHeight() * this.getLowerMargin();
        }
        double d2 = this.calculateCategorySize(n2, rectangle2D, rectangleEdge);
        double d3 = this.calculateCategoryGapSize(n2, rectangle2D, rectangleEdge);
        return d += (double)n * (d2 + d3);
    }

    public double getCategoryMiddle(int n, int n2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        return this.getCategoryStart(n, n2, rectangle2D, rectangleEdge) + this.calculateCategorySize(n2, rectangle2D, rectangleEdge) / 2.0;
    }

    public double getCategoryEnd(int n, int n2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        return this.getCategoryStart(n, n2, rectangle2D, rectangleEdge) + this.calculateCategorySize(n2, rectangle2D, rectangleEdge);
    }

    protected double calculateCategorySize(int n, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d = 0.0;
        double d2 = 0.0;
        if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
            d2 = rectangle2D.getWidth();
        } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
            d2 = rectangle2D.getHeight();
        }
        if (n > 1) {
            d = d2 * (1.0 - this.getLowerMargin() - this.getUpperMargin() - this.getCategoryMargin());
            d /= (double)n;
        } else {
            d = d2 * (1.0 - this.getLowerMargin() - this.getUpperMargin());
        }
        return d;
    }

    protected double calculateCategoryGapSize(int n, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d = 0.0;
        double d2 = 0.0;
        if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
            d2 = rectangle2D.getWidth();
        } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
            d2 = rectangle2D.getHeight();
        }
        if (n > 1) {
            d = d2 * this.getCategoryMargin() / (double)(n - 1);
        }
        return d;
    }

    public AxisSpace reserveSpace(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, RectangleEdge rectangleEdge, AxisSpace axisSpace) {
        Cloneable cloneable;
        if (axisSpace == null) {
            axisSpace = new AxisSpace();
        }
        if (!this.isVisible()) {
            return axisSpace;
        }
        double d = 0.0;
        double d2 = 0.0;
        if (this.isTickLabelsVisible()) {
            graphics2D.setFont(this.getTickLabelFont());
            this.refreshTicks(graphics2D, 0.0, rectangle2D, rectangle2D, rectangleEdge);
            cloneable = this.getTickLabelInsets();
            if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
                d = ((Insets)cloneable).top + ((Insets)cloneable).bottom;
                this.reservedForTickLabels = d += this.getMaxTickLabelHeight(graphics2D, rectangle2D, this.isVerticalCategoryLabels());
            } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
                d2 = ((Insets)cloneable).left + ((Insets)cloneable).right;
                this.reservedForTickLabels = d2 += this.getMaxTickLabelWidth(graphics2D, rectangle2D);
            }
        }
        cloneable = this.getLabelEnclosure(graphics2D, rectangleEdge);
        double d3 = 0.0;
        double d4 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d3 = ((RectangularShape)cloneable).getHeight();
            axisSpace.ensureAtLeast(d3 + d, rectangleEdge);
            this.reservedForAxisLabel = d3;
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d4 = ((RectangularShape)cloneable).getWidth();
            axisSpace.ensureAtLeast(d4 + d2, rectangleEdge);
            this.reservedForAxisLabel = d4;
        }
        return axisSpace;
    }

    public void configure() {
        CategoryPlot categoryPlot = (CategoryPlot)this.getPlot();
        this.categories = categoryPlot.getCategories();
    }

    public double draw(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        if (!this.isVisible()) {
            return 0.0;
        }
        double d2 = 0.0;
        if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
            d2 = this.drawHorizontalCategoryLabels(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge);
        } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
            d2 = this.drawVerticalCategoryLabels(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge);
        }
        if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.LEFT) {
            d -= d2;
        } else if (rectangleEdge == RectangleEdge.BOTTOM || rectangleEdge == RectangleEdge.RIGHT) {
            d += d2;
        }
        double d3 = this.drawLabel(this.getLabel(), graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge);
        return d2 + d3;
    }

    protected double drawHorizontalCategoryLabels(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        if (this.isTickLabelsVisible()) {
            Font font = this.getTickLabelFont();
            graphics2D.setFont(font);
            graphics2D.setPaint(this.getTickLabelPaint());
            this.refreshTicks(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge);
            Insets insets = this.getTickLabelInsets();
            double d2 = insets.top + insets.bottom;
            this.reservedForTickLabels = d2 += this.getMaxTickLabelHeight(graphics2D, rectangle2D, this.isVerticalCategoryLabels());
            Iterator iterator = this.getTicks().iterator();
            while (iterator.hasNext()) {
                Tick[] tickArray;
                Object e = iterator.next();
                if (e instanceof Tick) {
                    tickArray = (Tick[])e;
                    if (this.isVerticalCategoryLabels()) {
                        RefineryUtilities.drawRotatedString(tickArray.getText(), graphics2D, tickArray.getX(), tickArray.getY(), -1.5707963267948966);
                        continue;
                    }
                    graphics2D.drawString(tickArray.getText(), tickArray.getX(), tickArray.getY());
                    continue;
                }
                tickArray = (Tick[])e;
                for (int i = 0; i < tickArray.length; ++i) {
                    graphics2D.drawString(tickArray[i].getText(), tickArray[i].getX(), tickArray[i].getY());
                }
            }
        }
        return this.reservedForTickLabels;
    }

    protected double drawVerticalCategoryLabels(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        if (this.isTickLabelsVisible()) {
            graphics2D.setFont(this.getTickLabelFont());
            graphics2D.setPaint(this.getTickLabelPaint());
            this.refreshTicks(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge);
            Iterator iterator = this.getTicks().iterator();
            while (iterator.hasNext()) {
                Tick tick = (Tick)iterator.next();
                graphics2D.drawString(tick.getText(), tick.getX(), tick.getY());
            }
        }
        return this.reservedForTickLabels;
    }

    protected boolean isCompatiblePlot(Plot plot) {
        return plot instanceof CategoryPlot;
    }

    public Object clone() throws CloneNotSupportedException {
        Object object = super.clone();
        return object;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof CategoryAxis) {
            CategoryAxis categoryAxis = (CategoryAxis)object;
            if (super.equals(object)) {
                boolean bl = this.lowerMargin == categoryAxis.lowerMargin;
                boolean bl2 = this.upperMargin == categoryAxis.upperMargin;
                boolean bl3 = this.categoryMargin == categoryAxis.categoryMargin;
                boolean bl4 = this.verticalCategoryLabels == categoryAxis.verticalCategoryLabels;
                boolean bl5 = this.skipCategoryLabelsToFit == categoryAxis.skipCategoryLabelsToFit;
                return bl && bl2 && bl3 && bl4 && bl5;
            }
        }
        return false;
    }

    public void refreshTicks(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
            this.refreshTicksHorizontal(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge);
        } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
            this.refreshTicksVertical(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge);
        }
    }

    public void refreshTicksVertical(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        this.getTicks().clear();
        CategoryPlot categoryPlot = (CategoryPlot)this.getPlot();
        List list = categoryPlot.getCategories();
        if (list != null) {
            Font font = this.getTickLabelFont();
            graphics2D.setFont(font);
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            int n = 0;
            float f = 0.0f;
            float f2 = 0.0f;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                String string2 = e.toString();
                Rectangle2D rectangle2D3 = font.getStringBounds(string2, fontRenderContext);
                LineMetrics lineMetrics = font.getLineMetrics(string2, fontRenderContext);
                f = rectangleEdge == RectangleEdge.LEFT ? (float)(d - (double)this.getTickLabelInsets().right - rectangle2D3.getWidth()) : (float)(d + (double)this.getTickLabelInsets().left);
                f2 = (float)(this.getCategoryMiddle(n, list.size(), rectangle2D2, rectangleEdge) - (double)lineMetrics.getStrikethroughOffset() + 0.5);
                Tick tick = new Tick(e, string2, f, f2);
                this.getTicks().add(tick);
                ++n;
            }
        }
    }

    public void refreshTicksHorizontal(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        this.maxTickLineCount = 1;
        this.getTicks().clear();
        CategoryPlot categoryPlot = (CategoryPlot)this.getPlot();
        List list = categoryPlot.getCategories();
        if (list != null) {
            Font font = this.getTickLabelFont();
            graphics2D.setFont(font);
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            int n = 0;
            int n2 = 0;
            float f = (float)(rectangle2D2.getWidth() / (double)list.size() * (double)0.9f);
            float f2 = 0.0f;
            float f3 = 0.0f;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (n != 0) {
                    ++n2;
                    --n;
                    continue;
                }
                String string2 = e.toString();
                Rectangle2D rectangle2D3 = font.getStringBounds(string2, fontRenderContext);
                LineMetrics lineMetrics = font.getLineMetrics(string2, fontRenderContext);
                float f4 = (float)this.getCategoryMiddle(n2, list.size(), rectangle2D2, rectangleEdge);
                if (this.isVerticalCategoryLabels()) {
                    f2 = (float)((double)f4 + rectangle2D3.getHeight() / 2.0 - (double)lineMetrics.getDescent());
                    f3 = rectangleEdge == RectangleEdge.TOP ? (float)(d - (double)this.getTickLabelInsets().bottom) : (float)(d + (double)this.getTickLabelInsets().top + rectangle2D3.getWidth());
                    this.getTicks().add(new Tick(e, string2, f2, f3));
                    if (this.skipCategoryLabelsToFit) {
                        n = (int)((rectangle2D3.getHeight() - (double)(f / 2.0f)) / (double)f) + 1;
                    }
                } else if (rectangle2D3.getWidth() > (double)f) {
                    if (this.skipCategoryLabelsToFit) {
                        f2 = f4 - f / 2.0f;
                        f3 = rectangleEdge == RectangleEdge.TOP ? (float)(rectangle2D2.getMinY() - (double)this.getTickLabelInsets().bottom - (double)lineMetrics.getDescent() - (double)lineMetrics.getLeading()) : (float)(rectangle2D2.getMaxY() + (double)this.getTickLabelInsets().top + (double)lineMetrics.getHeight() - (double)lineMetrics.getDescent());
                        this.getTicks().add(new Tick(e, string2, f2, f3));
                        n = (int)((rectangle2D3.getWidth() - (double)(f / 2.0f)) / (double)f) + 1;
                    } else {
                        String[] stringArray = this.breakLine(string2, (int)f, fontRenderContext);
                        Tick[] tickArray = new Tick[stringArray.length];
                        for (int i = 0; i < stringArray.length; ++i) {
                            rectangle2D3 = font.getStringBounds(stringArray[i], fontRenderContext);
                            f2 = (float)((double)f4 - rectangle2D3.getWidth() / 2.0);
                            f3 = rectangleEdge == RectangleEdge.TOP ? (float)(rectangle2D2.getMinY() - (double)this.getTickLabelInsets().bottom - (double)((float)(stringArray.length - i) * lineMetrics.getHeight()) + (double)lineMetrics.getAscent()) : (float)(rectangle2D2.getMaxY() + (double)this.getTickLabelInsets().top + (double)((float)(i + 1) * lineMetrics.getHeight()) - (double)lineMetrics.getDescent());
                            tickArray[i] = new Tick(e, stringArray[i], f2, f3);
                        }
                        if (stringArray.length > this.maxTickLineCount) {
                            this.maxTickLineCount = stringArray.length;
                        }
                        this.getTicks().add(tickArray);
                    }
                } else {
                    f2 = (float)((double)f4 - rectangle2D3.getWidth() / 2.0);
                    f3 = rectangleEdge == RectangleEdge.TOP ? (float)(rectangle2D2.getMinY() - (double)this.getTickLabelInsets().bottom - (double)lineMetrics.getLeading() - (double)lineMetrics.getDescent()) : (float)(rectangle2D2.getMaxY() + (double)this.getTickLabelInsets().top + (double)lineMetrics.getHeight() - (double)lineMetrics.getDescent());
                    this.getTicks().add(new Tick(e, string2, f2, f3));
                }
                ++n2;
            }
        }
    }

    protected double getMaxTickLabelHeight(Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl) {
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        double d = 0.0;
        if (bl) {
            Iterator iterator = this.getTicks().iterator();
            while (iterator.hasNext()) {
                Tick tick = (Tick)iterator.next();
                Rectangle2D rectangle2D2 = font.getStringBounds(tick.getText(), fontRenderContext);
                if (!(rectangle2D2.getWidth() > d)) continue;
                d = rectangle2D2.getWidth();
            }
        } else {
            LineMetrics lineMetrics = font.getLineMetrics("Sample", fontRenderContext);
            d = lineMetrics.getHeight() * (float)this.maxTickLineCount;
        }
        return d;
    }

    protected double getMaxTickLabelWidth(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        double d = 0.0;
        Font font = this.getTickLabelFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Iterator iterator = this.getTicks().iterator();
        while (iterator.hasNext()) {
            Tick[] tickArray;
            Object e = iterator.next();
            if (e instanceof Tick) {
                tickArray = (Tick[])e;
                Rectangle2D rectangle2D2 = font.getStringBounds(tickArray.getText(), fontRenderContext);
                if (!(rectangle2D2.getWidth() > d)) continue;
                d = rectangle2D2.getWidth();
                continue;
            }
            tickArray = (Tick[])e;
            for (int i = 0; i < tickArray.length; ++i) {
                Rectangle2D rectangle2D3 = font.getStringBounds(tickArray[i].getText(), fontRenderContext);
                if (!(rectangle2D3.getWidth() > d)) continue;
                d = rectangle2D3.getWidth();
            }
        }
        return d;
    }

    private String[] breakLine(String string2, int n, FontRenderContext fontRenderContext) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>(5);
        int n2 = n;
        AttributedString attributedString = new AttributedString(string2, this.getTickLabelFont().getAttributes());
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        AffineTransform affineTransform = new AffineTransform();
        while (true) {
            stringArray = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
            int n3 = 0;
            int n4 = 0;
            TextLayout textLayout = stringArray.nextLayout(n2);
            while (textLayout != null) {
                arrayList.add(string2.substring(n4, n4 + textLayout.getCharacterCount()));
                int n5 = textLayout.getOutline((AffineTransform)affineTransform).getBounds().width;
                if (n3 < n5) {
                    n3 = n5;
                }
                n4 += textLayout.getCharacterCount();
                textLayout = stringArray.nextLayout(n2);
            }
            if (n3 <= n || (n2 -= n3 - n2) <= 0) break;
            arrayList.clear();
        }
        stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }
}

