/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.NumberFormat;
import org.jfree.chart.labels.PieItemLabelGenerator;
import org.jfree.data.PieDataset;
import org.jfree.util.ObjectUtils;

public class StandardPieToolTipGenerator
implements PieItemLabelGenerator,
Cloneable,
Serializable {
    private NumberFormat numberFormat;

    public StandardPieToolTipGenerator() {
        this(NumberFormat.getInstance());
    }

    public StandardPieToolTipGenerator(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public String generateToolTip(PieDataset pieDataset, Comparable comparable, int n) {
        String string2 = null;
        Number number = pieDataset.getValue(comparable);
        if (number != null) {
            String string3 = comparable.toString();
            string2 = string3 + " = " + this.numberFormat.format(number);
        }
        return string2;
    }

    public Object clone() throws CloneNotSupportedException {
        StandardPieToolTipGenerator standardPieToolTipGenerator = (StandardPieToolTipGenerator)super.clone();
        if (this.numberFormat != null) {
            standardPieToolTipGenerator.numberFormat = (NumberFormat)this.numberFormat.clone();
        }
        return standardPieToolTipGenerator;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof StandardPieToolTipGenerator) {
            StandardPieToolTipGenerator standardPieToolTipGenerator = (StandardPieToolTipGenerator)object;
            return ObjectUtils.equal(this.numberFormat, standardPieToolTipGenerator.getNumberFormat());
        }
        return false;
    }
}

