/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.text.NumberFormat;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYZToolTipGenerator;
import org.jfree.data.XYZDataset;

public class StandardXYZToolTipGenerator
extends StandardXYToolTipGenerator
implements XYZToolTipGenerator {
    private NumberFormat zFormat;

    public StandardXYZToolTipGenerator() {
        this(NumberFormat.getNumberInstance(), NumberFormat.getNumberInstance(), NumberFormat.getNumberInstance());
    }

    public StandardXYZToolTipGenerator(NumberFormat numberFormat, NumberFormat numberFormat2, NumberFormat numberFormat3) {
        super(numberFormat, numberFormat2);
        this.zFormat = numberFormat3;
    }

    public NumberFormat getZFormat() {
        return this.zFormat;
    }

    public String generateToolTip(XYZDataset xYZDataset, int n, int n2) {
        String string2 = xYZDataset.getSeriesName(n) + ": ";
        Number number = xYZDataset.getXValue(n, n2);
        string2 = string2 + "x: " + this.getXFormat().format(number);
        Number number2 = xYZDataset.getYValue(n, n2);
        string2 = string2 + "y: " + this.getYFormat().format(number2);
        Number number3 = xYZDataset.getZValue(n, n2);
        string2 = number3 != null ? string2 + ", z: " + this.zFormat.format(number3) : string2 + ", z: null";
        return string2;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof StandardXYZToolTipGenerator) {
            StandardXYZToolTipGenerator standardXYZToolTipGenerator = (StandardXYZToolTipGenerator)object;
            return this.getXFormat().equals(standardXYZToolTipGenerator.getXFormat()) && this.getYFormat().equals(standardXYZToolTipGenerator.getYFormat()) && this.getZFormat().equals(standardXYZToolTipGenerator.getZFormat());
        }
        return false;
    }
}

