/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class XYStepRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private transient Line2D line;

    public XYStepRenderer() {
        this.line = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
    }

    public XYStepRenderer(XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        this.setToolTipGenerator(xYToolTipGenerator);
        this.setURLGenerator(xYURLGenerator);
        this.line = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo, int n3) {
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        Number number = xYDataset.getXValue(n, n2);
        Number number2 = xYDataset.getYValue(n, n2);
        if (number2 == null) {
            return;
        }
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge);
        double d2 = valueAxis2.translateValueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge2);
        if (n2 > 0) {
            Number number3 = xYDataset.getXValue(n, n2 - 1);
            Number number4 = xYDataset.getYValue(n, n2 - 1);
            if (number4 != null) {
                double d3 = valueAxis.translateValueToJava2D(number3.doubleValue(), rectangle2D, rectangleEdge);
                double d4 = valueAxis2.translateValueToJava2D(number4.doubleValue(), rectangle2D, rectangleEdge2);
                PlotOrientation plotOrientation = xYPlot.getOrientation();
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    if (d4 == d2) {
                        this.line.setLine(d4, d3, d2, d);
                        graphics2D.draw(this.line);
                    } else {
                        this.line.setLine(d4, d3, d2, d3);
                        graphics2D.draw(this.line);
                        this.line.setLine(d2, d3, d2, d);
                        graphics2D.draw(this.line);
                    }
                } else if (plotOrientation == PlotOrientation.VERTICAL) {
                    if (d4 == d2) {
                        this.line.setLine(d3, d4, d, d2);
                        graphics2D.draw(this.line);
                    } else {
                        this.line.setLine(d3, d4, d, d4);
                        graphics2D.draw(this.line);
                        this.line.setLine(d, d4, d, d2);
                        graphics2D.draw(this.line);
                    }
                }
            }
        }
        if (xYPlot.isDomainCrosshairLockedOnData()) {
            if (xYPlot.isRangeCrosshairLockedOnData()) {
                crosshairInfo.updateCrosshairPoint(number.doubleValue(), number2.doubleValue(), d, d2);
            } else {
                crosshairInfo.updateCrosshairX(number.doubleValue());
            }
        } else if (xYPlot.isRangeCrosshairLockedOnData()) {
            crosshairInfo.updateCrosshairY(number2.doubleValue());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

