/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.ui;

import java.awt.Color;
import java.awt.Paint;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.jfree.chart.axis.Tick;
import org.jfree.util.ObjectUtils;

public abstract class ColorPalette
implements Cloneable,
Serializable {
    protected double minZ = -1.0;
    protected double maxZ = -1.0;
    protected int[] r;
    protected int[] g;
    protected int[] b;
    protected double[] tickValues = null;
    protected boolean logscale = false;
    protected boolean inverse = false;
    protected String paletteName = null;
    protected boolean stepped = false;
    protected static final double log10 = Math.log(10.0);

    public Paint getColor(double d) {
        int n = (int)(253.0 * (d - this.minZ) / (this.maxZ - this.minZ)) + 2;
        return new Color(this.r[n], this.g[n], this.b[n]);
    }

    public Color getColor(int n) {
        return new Color(this.r[n], this.g[n], this.b[n]);
    }

    public Color getColorLinear(double d) {
        int n = 0;
        if (this.stepped) {
            int n2 = Arrays.binarySearch(this.tickValues, d);
            if (n2 < 0) {
                n2 = -1 * n2 - 2;
            }
            d = n2 < 0 ? this.minZ : this.tickValues[n2];
        }
        n = (int)(253.0 * (d - this.minZ) / (this.maxZ - this.minZ)) + 2;
        n = Math.min(n, 255);
        n = Math.max(n, 2);
        return this.getColor(n);
    }

    public Color getColorLog(double d) {
        int n = 0;
        double d2 = this.minZ;
        double d3 = this.maxZ;
        if (this.minZ <= 0.0) {
            this.maxZ = d3 - d2 + 1.0;
            this.minZ = 1.0;
            d = d - d2 + 1.0;
        }
        double d4 = Math.log(this.minZ) / log10;
        double d5 = Math.log(this.maxZ) / log10;
        d = Math.log(d) / log10;
        if (this.stepped) {
            int n2 = this.tickValues.length;
            int n3 = 256 / (n2 - 1);
            n = n3 * (int)((double)n2 * (d - d4) / (d5 - d4)) + 2;
        } else {
            n = (int)(253.0 * (d - d4) / (d5 - d4)) + 2;
        }
        n = Math.min(n, 255);
        n = Math.max(n, 2);
        this.minZ = d2;
        this.maxZ = d3;
        return this.getColor(n);
    }

    public double getMaxZ() {
        return this.maxZ;
    }

    public double getMinZ() {
        return this.minZ;
    }

    public Paint getPaint(double d) {
        if (this.isLogscale()) {
            return this.getColorLog(d);
        }
        return this.getColorLinear(d);
    }

    public String getPaletteName() {
        return this.paletteName;
    }

    public double[] getTickValues() {
        return this.tickValues;
    }

    public abstract void initialize();

    public void invertPalette() {
        int n;
        int[] nArray = new int[256];
        int[] nArray2 = new int[256];
        int[] nArray3 = new int[256];
        for (n = 0; n < 256; ++n) {
            nArray[n] = this.r[n];
            nArray2[n] = this.g[n];
            nArray3[n] = this.b[n];
        }
        for (n = 2; n < 256; ++n) {
            this.r[n] = nArray[257 - n];
            this.g[n] = nArray2[257 - n];
            this.b[n] = nArray3[257 - n];
        }
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public boolean isLogscale() {
        return this.logscale;
    }

    public boolean isStepped() {
        return this.stepped;
    }

    public void setInverse(boolean bl) {
        this.inverse = bl;
        this.initialize();
        if (bl) {
            this.invertPalette();
        }
    }

    public void setLogscale(boolean bl) {
        this.logscale = bl;
    }

    public void setMaxZ(double d) {
        this.maxZ = d;
    }

    public void setMinZ(double d) {
        this.minZ = d;
    }

    public void setPaletteName(String string2) {
        this.paletteName = string2;
    }

    public void setStepped(boolean bl) {
        this.stepped = bl;
    }

    public void setTickValues(double[] dArray) {
        this.tickValues = dArray;
    }

    public void setTickValues(List list) {
        this.tickValues = new double[list.size()];
        for (int i = 0; i < this.tickValues.length; ++i) {
            this.tickValues[i] = ((Tick)list.get(i)).getNumericalValue();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof ColorPalette) {
            ColorPalette colorPalette = (ColorPalette)object;
            boolean bl = this.minZ == colorPalette.minZ;
            boolean bl2 = this.maxZ == colorPalette.maxZ;
            boolean bl3 = Arrays.equals(this.r, colorPalette.r);
            boolean bl4 = Arrays.equals(this.g, colorPalette.g);
            boolean bl5 = Arrays.equals(this.b, colorPalette.b);
            boolean bl6 = Arrays.equals(this.tickValues, colorPalette.tickValues);
            boolean bl7 = this.logscale == colorPalette.logscale;
            boolean bl8 = this.inverse == colorPalette.inverse;
            boolean bl9 = ObjectUtils.equal(this.paletteName, colorPalette.paletteName);
            boolean bl10 = this.stepped == colorPalette.stepped;
            return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8 && bl9 && bl10;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        ColorPalette colorPalette = (ColorPalette)super.clone();
        return colorPalette;
    }
}

