/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml;

import java.util.HashMap;
import java.util.Stack;
import org.jfree.util.Configuration;
import org.jfree.util.DefaultConfiguration;
import org.jfree.xml.ElementDefinitionHandler;
import org.jfree.xml.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class Parser
extends DefaultHandler
implements Configuration {
    public static final String CONTENTBASE_KEY = "content-base";
    private Stack activeFactories = new Stack();
    private ElementDefinitionHandler initialFactory;
    private DefaultConfiguration parserConfiguration = new DefaultConfiguration();
    private HashMap parserHelperObjects = new HashMap();
    private Locator locator;

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void pushFactory(ElementDefinitionHandler elementDefinitionHandler) {
        this.activeFactories.push(elementDefinitionHandler);
    }

    public ElementDefinitionHandler peekFactory() {
        return (ElementDefinitionHandler)this.activeFactories.peek();
    }

    public ElementDefinitionHandler popFactory() {
        this.activeFactories.pop();
        return this.peekFactory();
    }

    public void endDocument() throws SAXException {
        super.endDocument();
    }

    public void startDocument() throws SAXException {
        this.activeFactories.clear();
        this.pushFactory(this.getInitialFactory());
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.peekFactory().characters(cArray, n, n2);
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (Exception exception) {
            throw new ParseException(exception, this.getLocator());
        }
    }

    public void endElement(String string2, String string3, String string4) throws SAXException {
        try {
            this.peekFactory().endElement(string4);
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (Exception exception) {
            throw new ParseException(exception, this.getLocator());
        }
    }

    public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
        try {
            this.peekFactory().startElement(string4, attributes);
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (Exception exception) {
            throw new ParseException(exception, this.getLocator());
        }
    }

    public void setInitialFactory(ElementDefinitionHandler elementDefinitionHandler) {
        this.initialFactory = elementDefinitionHandler;
    }

    public ElementDefinitionHandler getInitialFactory() {
        return this.initialFactory;
    }

    public String getConfigProperty(String string2) {
        return this.getConfigProperty(string2, null);
    }

    public String getConfigProperty(String string2, String string3) {
        return this.parserConfiguration.getConfigProperty(string2, string3);
    }

    public void setConfigProperty(String string2, String string3) {
        if (string3 == null) {
            this.parserConfiguration.remove(string2);
        } else {
            this.parserConfiguration.setProperty(string2, string3);
        }
    }

    public void setHelperObject(String string2, Object object) {
        if (object == null) {
            this.parserHelperObjects.remove(string2);
        } else {
            this.parserHelperObjects.put(string2, object);
        }
    }

    public Object getHelperObject(String string2) {
        return this.parserHelperObjects.get(string2);
    }

    public abstract Parser getInstance();

    public abstract Object getResult();
}

