/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.Capabilities;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.Reflect;
import bsh.UtilEvalError;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Hashtable;

public class BshClassManager {
    private static Object NOVALUE = new Object();
    private ClassLoader externalClassLoader;
    protected transient Hashtable absoluteClassCache = new Hashtable();
    protected transient Hashtable absoluteNonClasses = new Hashtable();
    protected transient Hashtable resolvedObjectMethods = new Hashtable();
    protected transient Hashtable resolvedStaticMethods = new Hashtable();
    static /* synthetic */ Class class$bsh$Interpreter;

    public static BshClassManager createClassManager() {
        BshClassManager bshClassManager;
        if (Capabilities.classExists("java.lang.ref.WeakReference") && Capabilities.classExists("java.util.HashMap") && Capabilities.classExists("bsh.classpath.ClassManagerImpl")) {
            try {
                Class<?> clazz = Class.forName("bsh.classpath.ClassManagerImpl");
                bshClassManager = (BshClassManager)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new InterpreterError("Error loading classmanager: " + exception);
            }
        } else {
            bshClassManager = new BshClassManager();
        }
        return bshClassManager;
    }

    public boolean classExists(String string2) {
        return this.classForName(string2) != null;
    }

    public Class classForName(String string2) {
        try {
            return this.plainClassForName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public Class plainClassForName(String string2) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = this.externalClassLoader != null ? this.externalClassLoader.loadClass(string2) : Class.forName(string2);
            this.cacheClassInfo(string2, clazz);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw BshClassManager.noClassDefFound(string2, noClassDefFoundError);
        }
        return clazz;
    }

    public URL getResource(String string2) {
        if (this.externalClassLoader != null) {
            return this.externalClassLoader.getResource(string2.substring(1));
        }
        return (class$bsh$Interpreter == null ? (class$bsh$Interpreter = BshClassManager.class$("bsh.Interpreter")) : class$bsh$Interpreter).getResource(string2);
    }

    public InputStream getResourceAsStream(String string2) {
        if (this.externalClassLoader != null) {
            return this.externalClassLoader.getResourceAsStream(string2.substring(1));
        }
        return (class$bsh$Interpreter == null ? (class$bsh$Interpreter = BshClassManager.class$("bsh.Interpreter")) : class$bsh$Interpreter).getResourceAsStream(string2);
    }

    public void cacheClassInfo(String string2, Class clazz) {
        if (clazz != null) {
            this.absoluteClassCache.put(string2, clazz);
        } else {
            this.absoluteNonClasses.put(string2, NOVALUE);
        }
    }

    public void cacheResolvedMethod(Class clazz, Object[] objectArray, Method method) {
        if (Interpreter.DEBUG) {
            Interpreter.debug("cacheResolvedMethod putting: " + clazz + " " + method);
        }
        SignatureKey signatureKey = new SignatureKey(clazz, method.getName(), objectArray);
        if (Modifier.isStatic(method.getModifiers())) {
            this.resolvedStaticMethods.put(signatureKey, method);
        } else {
            this.resolvedObjectMethods.put(signatureKey, method);
        }
    }

    public Method getResolvedMethod(Class clazz, String string2, Object[] objectArray, boolean bl) {
        SignatureKey signatureKey = new SignatureKey(clazz, string2, objectArray);
        Method method = (Method)this.resolvedStaticMethods.get(signatureKey);
        if (method == null && !bl) {
            method = (Method)this.resolvedObjectMethods.get(signatureKey);
        }
        if (Interpreter.DEBUG) {
            if (method == null) {
                Interpreter.debug("getResolvedMethod cache MISS: " + clazz + " - " + string2);
            } else {
                Interpreter.debug("getResolvedMethod cache HIT: " + clazz + " - " + method);
            }
        }
        return method;
    }

    protected void clearCaches() {
        this.absoluteNonClasses = new Hashtable();
        this.absoluteClassCache = new Hashtable();
        this.resolvedObjectMethods = new Hashtable();
        this.resolvedStaticMethods = new Hashtable();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.externalClassLoader = classLoader;
        this.classLoaderChanged();
    }

    public void addClassPath(URL uRL) throws IOException {
    }

    public void reset() {
        this.clearCaches();
    }

    public void setClassPath(URL[] uRLArray) throws UtilEvalError {
        throw BshClassManager.cmUnavailable();
    }

    public void reloadAllClasses() throws UtilEvalError {
        throw BshClassManager.cmUnavailable();
    }

    public void reloadClasses(String[] stringArray) throws UtilEvalError {
        throw BshClassManager.cmUnavailable();
    }

    public void reloadPackage(String string2) throws UtilEvalError {
        throw BshClassManager.cmUnavailable();
    }

    protected void doSuperImport() throws UtilEvalError {
        throw BshClassManager.cmUnavailable();
    }

    protected boolean hasSuperImport() {
        return false;
    }

    protected String getClassNameByUnqName(String string2) throws UtilEvalError {
        throw BshClassManager.cmUnavailable();
    }

    public void addListener(Listener listener) {
    }

    public void removeListener(Listener listener) {
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("BshClassManager: no class manager.");
    }

    protected void classLoaderChanged() {
    }

    protected static Error noClassDefFound(String string2, Error error) {
        return new NoClassDefFoundError("A class required by class: " + string2 + " could not be loaded:\n" + error.toString());
    }

    protected static UtilEvalError cmUnavailable() {
        return new Capabilities.Unavailable("ClassLoading features unavailable.");
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class SignatureKey {
        Class clas;
        Class[] types;
        String methodName;
        int hashCode = 0;

        SignatureKey(Class clazz, String string2, Object[] objectArray) {
            this.clas = clazz;
            this.methodName = string2;
            this.types = Reflect.getTypes(objectArray);
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = this.clas.hashCode() * this.methodName.hashCode();
                if (this.types == null) {
                    return this.hashCode;
                }
                int n = 0;
                while (n < this.types.length) {
                    int n2 = this.types[n] == null ? 21 : this.types[n].hashCode();
                    this.hashCode = this.hashCode * (n + 1) + n2;
                    ++n;
                }
            }
            return this.hashCode;
        }

        public boolean equals(Object object) {
            SignatureKey signatureKey = (SignatureKey)object;
            if (this.types == null) {
                return signatureKey.types == null;
            }
            if (this.clas != signatureKey.clas) {
                return false;
            }
            if (!this.methodName.equals(signatureKey.methodName)) {
                return false;
            }
            if (this.types.length != signatureKey.types.length) {
                return false;
            }
            int n = 0;
            while (n < this.types.length) {
                if (this.types[n] == null ? signatureKey.types[n] != null : !this.types[n].equals(signatureKey.types[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }

    public static interface Listener {
        public void classLoaderChanged();
    }
}

