/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.quantile;

class QuantileCalc {
    QuantileCalc() {
    }

    public static double binomial(long l, long l2) {
        if (l2 == 0L || l2 == l) {
            return 1.0;
        }
        if ((double)l2 > (double)l / 2.0) {
            l2 = l - l2;
        }
        double d = 1.0;
        long l3 = l - l2 + 1L;
        long l4 = l2;
        while (l4 > 0L) {
            d *= (double)l3++ / (double)l4--;
        }
        return d;
    }

    public static long ceiling(double d) {
        return Math.round(Math.ceil(d));
    }

    public static long[] known_N_compute_B_and_K(long l, double d, double d2, int n, double[] dArray) {
        if (d2 > 0.0) {
            return QuantileCalc.known_N_compute_B_and_K_slow(l, d, d2, n, dArray);
        }
        dArray[0] = 1.0;
        return QuantileCalc.known_N_compute_B_and_K_quick(l, d);
    }

    protected static long[] known_N_compute_B_and_K_quick(long l, double d) {
        long l2;
        long l3;
        int n;
        if (d <= 0.0) {
            long[] lArray = new long[]{1L, l};
            return lArray;
        }
        double d2 = l;
        double d3 = d2 * d * 2.0;
        int[] nArray = new int[49];
        int n2 = 2;
        while (n2 <= 50) {
            int n3 = 3;
            while (n3 <= 50 && (double)(n3 - 2) * (double)Math.round(QuantileCalc.binomial(n2 + n3 - 2, n3 - 1)) - (double)Math.round(QuantileCalc.binomial(n2 + n3 - 3, n3 - 3)) + (double)Math.round(QuantileCalc.binomial(n2 + n3 - 3, n3 - 2)) - d3 > 0.0) {
                ++n3;
            }
            while (n3 <= 50 && (double)(n3 - 2) * (double)Math.round(QuantileCalc.binomial(n2 + n3 - 2, n3 - 1)) - (double)Math.round(QuantileCalc.binomial(n2 + n3 - 3, n3 - 3)) + (double)Math.round(QuantileCalc.binomial(n2 + n3 - 3, n3 - 2)) - d3 <= 0.0) {
                ++n3;
            }
            n = --n3 >= 50 && (double)(n3 - 2) * (double)Math.round(QuantileCalc.binomial(n2 + n3 - 2, n3 - 1)) - (double)Math.round(QuantileCalc.binomial(n2 + n3 - 3, n3 - 3)) + (double)Math.round(QuantileCalc.binomial(n2 + n3 - 3, n3 - 2)) - d3 > 0.0 ? Integer.MIN_VALUE : n3;
            nArray[n2 - 2] = n;
            ++n2;
        }
        long[] lArray = new long[49];
        n = 2;
        while (n <= 50) {
            double d4;
            long l4;
            int n4 = nArray[n - 2];
            long l5 = Long.MAX_VALUE;
            if (n4 > Integer.MIN_VALUE && (l4 = QuantileCalc.ceiling(d2 / (d4 = (double)Math.round(QuantileCalc.binomial(n + n4 - 2, n4 - 1))))) <= Long.MAX_VALUE) {
                l5 = l4;
            }
            lArray[n - 2] = l5;
            ++n;
        }
        long l6 = Long.MAX_VALUE;
        int n5 = -1;
        int n6 = 2;
        while (n6 <= 50) {
            if (lArray[n6 - 2] < Long.MAX_VALUE && (l3 = (long)n6 * lArray[n6 - 2]) < l6) {
                l6 = l3;
                n5 = n6;
            }
            ++n6;
        }
        if (n5 != -1) {
            l3 = n5;
            l2 = lArray[n5 - 2];
        } else {
            l3 = 1L;
            l2 = l;
        }
        long[] lArray2 = new long[]{l3, l2};
        return lArray2;
    }

    protected static long[] known_N_compute_B_and_K_slow(long l, double d, double d2, int n, double[] dArray) {
        if (d <= 0.0) {
            long[] lArray = new long[]{1L, l};
            dArray[0] = 1.0;
            return lArray;
        }
        double d3 = l;
        long l2 = 1L;
        long l3 = l;
        double d4 = 1.0;
        long l4 = l;
        double d5 = Math.log(2.0 * (double)n / d2);
        double d6 = 2.0 * d * d3;
        long l5 = 2L;
        while (l5 < 50L) {
            long l6 = 3L;
            while (l6 < 50L) {
                double d7 = QuantileCalc.binomial(l5 + l6 - 2L, l6 - 1L);
                long l7 = QuantileCalc.ceiling(d3 / d7);
                if (l5 * l7 < l4 && (double)(l6 - 2L) * d7 - QuantileCalc.binomial(l5 + l6 - 3L, l6 - 3L) + QuantileCalc.binomial(l5 + l6 - 3L, l6 - 2L) <= d6) {
                    l3 = l7;
                    l2 = l5;
                    l4 = l3 * l5;
                    d4 = 1.0;
                }
                if (d2 > 0.0) {
                    double d8 = (double)(l6 - 2L) * QuantileCalc.binomial(l5 + l6 - 2L, l6 - 1L) - QuantileCalc.binomial(l5 + l6 - 3L, l6 - 3L) + QuantileCalc.binomial(l5 + l6 - 3L, l6 - 2L);
                    double d9 = d5 / d;
                    double d10 = QuantileCalc.binomial(l5 + l6 - 2L, l6 - 1L);
                    double d11 = d5 / (2.0 * d * d);
                    double d12 = 0.5 + 0.5 * Math.sqrt(1.0 + 4.0 * d8 / d9);
                    long l8 = QuantileCalc.ceiling(d11 * d12 * d12 / d10);
                    if (l5 * l8 < l4) {
                        l3 = l8;
                        l2 = l5;
                        l4 = l5 * l8;
                        d4 = d3 * 2.0 * d * d / d5;
                    }
                }
                ++l6;
            }
            ++l5;
        }
        long[] lArray = new long[]{l2, l3};
        dArray[0] = d4;
        return lArray;
    }

    public static void main(String[] stringArray) {
        QuantileCalc.test_B_and_K_Calculation(stringArray);
    }

    public static void test_B_and_K_Calculation(String[] stringArray) {
        boolean bl = stringArray == null ? false : new Boolean(stringArray[0]);
        int[] nArray = new int[]{1, 1000};
        long[] lArray = new long[]{100000L, 1000000L, 10000000L, 1000000000L};
        double[] dArray = new double[]{0.0, 0.001, 1.0E-4, 1.0E-5};
        double[] dArray2 = new double[]{0.0, 0.1, 0.05, 0.01, 0.005, 0.001, 1.0E-7};
        if (!bl) {
            lArray = new long[]{0L};
        }
        System.out.println("\n\n");
        if (bl) {
            System.out.println("Computing b's and k's for KNOWN N");
        } else {
            System.out.println("Computing b's and k's for UNKNOWN N");
        }
        System.out.println("mem [elements/1024]");
        System.out.println("***********************************");
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            System.out.println("------------------------------");
            System.out.println("computing for p = " + n2);
            int n3 = 0;
            while (n3 < lArray.length) {
                long l = lArray[n3];
                System.out.println("   ------------------------------");
                System.out.println("   computing for N = " + l);
                int n4 = 0;
                while (n4 < dArray.length) {
                    double d = dArray[n4];
                    System.out.println("      ------------------------------");
                    System.out.println("      computing for delta = " + d);
                    int n5 = 0;
                    while (n5 < dArray2.length) {
                        double d2 = dArray2[n5];
                        double[] dArray3 = new double[1];
                        long[] lArray2 = bl ? QuantileCalc.known_N_compute_B_and_K(l, d2, d, n2, dArray3) : QuantileCalc.unknown_N_compute_B_and_K(d2, d, n2);
                        long l2 = lArray2[0];
                        long l3 = lArray2[1];
                        System.out.print("         (e,d,N,p)=(" + d2 + "," + d + "," + l + "," + n2 + ") --> ");
                        System.out.print("(b,k,mem");
                        if (bl) {
                            System.out.print(",sampling");
                        }
                        System.out.print(")=(" + l2 + "," + l3 + "," + l2 * l3 / 1024L);
                        if (bl) {
                            System.out.print("," + dArray3[0]);
                        }
                        System.out.println(")");
                        ++n5;
                    }
                    ++n4;
                }
                ++n3;
            }
            ++n;
        }
    }

    public static long[] unknown_N_compute_B_and_K(double d, double d2, int n) {
        if (d <= 0.0 || d2 <= 0.0) {
            long[] lArray = new long[]{1L, Long.MAX_VALUE, Long.MAX_VALUE};
            return lArray;
        }
        int n2 = 50;
        int n3 = 50;
        int n4 = 50;
        int n5 = 2;
        long l = Long.MAX_VALUE;
        long l2 = Long.MAX_VALUE;
        long l3 = Long.MAX_VALUE;
        long l4 = Long.MAX_VALUE;
        double d3 = Math.pow(2.0, n4);
        double d4 = Math.log(2.0 / (d2 / (double)n)) / (2.0 * d * d);
        while (l == Long.MAX_VALUE && n5-- > 0) {
            int n6 = 2;
            while (n6 <= n2) {
                int n7 = 2;
                while (n7 <= n3) {
                    double d5;
                    double d6;
                    double d7;
                    double d8;
                    double d9 = QuantileCalc.binomial(n6 + n7 - 2, n7 - 1);
                    double d10 = d4 / Math.min(d9, 8.0 * (d8 = QuantileCalc.binomial(n6 + n7 - 3, n7 - 1)) / 3.0);
                    double d11 = d10 * d10 + 4.0 * d10 * (d7 = ((double)(n7 + 3) + (d6 = ((d5 = d9 / d8) - 2.0) * ((double)n4 - 2.0) / (d5 + d3 - 2.0))) / (2.0 * d));
                    if (!(d11 < 0.0)) {
                        double d12 = Math.sqrt(d11);
                        double d13 = (d10 + 2.0 * d7 + d12) / (2.0 * d7);
                        double d14 = (d10 + 2.0 * d7 - d12) / (2.0 * d7);
                        boolean bl = false;
                        boolean bl2 = false;
                        if (0.0 < d13 && d13 < 1.0) {
                            bl = true;
                        }
                        if (0.0 < d14 && d14 < 1.0) {
                            bl2 = true;
                        }
                        if (bl || bl2) {
                            long l5;
                            double d15 = d13;
                            if (bl && bl2) {
                                d15 = Math.max(d13, d14);
                            } else if (bl2) {
                                d15 = d14;
                            }
                            long l6 = QuantileCalc.ceiling(Math.max(d7 / d15, (double)(n7 + 1) / (2.0 * d)));
                            if (l6 > 0L && (l5 = (long)n6 * l6) < l4) {
                                l2 = l6;
                                l = n6;
                                l3 = n7;
                                l4 = l5;
                            }
                        }
                    }
                    ++n7;
                }
                ++n6;
            }
            if (l != Long.MAX_VALUE) continue;
            System.out.println("Warning: Computing b and k looks like a lot of work!");
            n2 *= 2;
            n3 *= 2;
            n4 *= 2;
        }
        long[] lArray = new long[3];
        if (l == Long.MAX_VALUE) {
            lArray[0] = 1L;
            lArray[1] = Long.MAX_VALUE;
            lArray[2] = Long.MAX_VALUE;
        } else {
            lArray[0] = l;
            lArray[1] = l2;
            lArray[2] = l3;
        }
        return lArray;
    }
}

