/*
 * Decompiled with CFR 0.152.
 */
package com.lgc.wsh.inv;

import com.lgc.wsh.inv.Vect;
import com.lgc.wsh.inv.VectConst;
import com.lgc.wsh.inv.VectUtil;
import com.lgc.wsh.util.Almost;
import java.util.logging.Logger;

public class ArrayVect1
implements Vect {
    protected double[] _data = null;
    protected double _variance = 1.0;
    private static final Logger LOG;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ArrayVect1(double[] data, double variance) {
        this.init(data, variance);
    }

    protected ArrayVect1() {
    }

    protected void init(double[] data, double variance) {
        this._data = data;
        this._variance = variance;
    }

    public int getSize() {
        return this._data.length;
    }

    public double[] getData() {
        return this._data;
    }

    public void setVariance(double variance) {
        this._variance = variance;
    }

    public Object clone() {
        try {
            ArrayVect1 result = (ArrayVect1)super.clone();
            result._data = (double[])result._data.clone();
            return result;
        }
        catch (CloneNotSupportedException ex) {
            IllegalStateException e = new IllegalStateException(ex.getMessage());
            e.initCause(ex);
            throw e;
        }
    }

    public double dot(VectConst other) {
        double result = 0.0;
        ArrayVect1 rhs = (ArrayVect1)other;
        for (int i = 0; i < this._data.length; ++i) {
            result += this._data[i] * rhs._data[i];
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < this._data.length; ++i) {
            sb.append("" + this._data[i]);
            if (i >= this._data.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public void dispose() {
        this._data = null;
    }

    public void multiplyInverseCovariance() {
        double scale = Almost.FLOAT.divide(1.0, (double)this.getSize() * this._variance, 0.0);
        VectUtil.scale(this, scale);
    }

    public void constrain() {
    }

    public void postCondition() {
    }

    public void add(double scaleThis, double scaleOther, VectConst other) {
        ArrayVect1 rhs = (ArrayVect1)other;
        for (int i = 0; i < this._data.length; ++i) {
            this._data[i] = scaleThis * this._data[i] + scaleOther * rhs._data[i];
        }
    }

    public void project(double scaleThis, double scaleOther, VectConst other) {
        this.add(scaleThis, scaleOther, other);
    }

    public double magnitude() {
        return Almost.FLOAT.divide(this.dot(this), (double)this.getSize() * this._variance, 0.0);
    }

    public static void main(String[] args) throws Exception {
        double[] a = new double[31];
        for (int i = 0; i < a.length; ++i) {
            a[i] = i;
        }
        ArrayVect1 v = new ArrayVect1(a, 3.0);
        VectUtil.test(v);
        for (int i = 0; i < a.length; ++i) {
            a[i] = 1.0;
        }
        v = new ArrayVect1(a, 3.0);
        ArrayVect1 w = (ArrayVect1)v.clone();
        w.multiplyInverseCovariance();
        if (!$assertionsDisabled && !Almost.FLOAT.equal(0.3333333333333333, v.dot(w))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !Almost.FLOAT.equal(0.3333333333333333, v.magnitude())) {
            throw new AssertionError();
        }
    }

    static {
        $assertionsDisabled = !ArrayVect1.class.desiredAssertionStatus();
        LOG = Logger.getLogger("com.lgc.wsh.inv");
    }
}

