/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify;

import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.WeightedSet;
import java.io.Serializable;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLabel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private WeightedSet<String> wset = new WeightedSet();
    private String bestLabel = null;
    private double bestWeight = -1.7976931348623157E308;

    public ClassLabel() {
    }

    public ClassLabel(String label) {
        this(label, 1.0);
    }

    public ClassLabel(String label, double weight) {
        this.add(label, weight);
    }

    public static ClassLabel multiPosLabel(String label, double score) {
        ClassLabel result = new ClassLabel(label, score);
        return result;
    }

    public static ClassLabel multiNegLabel(String label, double score) {
        ClassLabel result = new ClassLabel(label, score);
        return result;
    }

    public static ClassLabel multiLabel(String name, double score) {
        return score >= 0.0 ? ClassLabel.multiPosLabel(name, score) : ClassLabel.multiNegLabel(name, score);
    }

    public static ClassLabel positiveLabel(double score) {
        if (score < 0.0) {
            throw new IllegalArgumentException("positiveLabel should have positive score");
        }
        ClassLabel result = new ClassLabel("POS", score);
        result.add("NEG", -score);
        return result;
    }

    public static ClassLabel negativeLabel(double score) {
        if (score > 0.0) {
            throw new IllegalArgumentException("negativeLabel should have negative score");
        }
        ClassLabel result = new ClassLabel("POS", score);
        result.add("NEG", -score);
        return result;
    }

    public static ClassLabel binaryLabel(double score) {
        return score >= 0.0 ? ClassLabel.positiveLabel(score) : ClassLabel.negativeLabel(score);
    }

    public boolean isBinary() {
        return ExampleSchema.BINARY_EXAMPLE_SCHEMA.isValid(this);
    }

    public boolean isPositive() {
        return "POS".equals(this.bestLabel);
    }

    public boolean isNegative() {
        return "NEG".equals(this.bestLabel);
    }

    public double numericLabel() {
        if (this.isPositive()) {
            return 1.0;
        }
        if (this.isNegative()) {
            return -1.0;
        }
        throw new IllegalArgumentException("not binary label");
    }

    public String bestClassName() {
        return this.bestLabel;
    }

    public double bestWeight() {
        return this.bestWeight;
    }

    public double posWeight() {
        return this.getWeight("POS");
    }

    public double posProbability() {
        return this.getProbability("POS");
    }

    public double getWeight(String label) {
        return this.wset.getWeight(label, -1.7976931348623157E308);
    }

    public double getProbability(String label) {
        double expOdds = Math.exp(this.getWeight(label));
        return expOdds / (1.0 + expOdds);
    }

    public Set<String> possibleLabels() {
        return this.wset.asSet();
    }

    public boolean isCorrect(ClassLabel otherLabel) {
        if (otherLabel == null) {
            throw new IllegalArgumentException("null otherLabel?");
        }
        if (this.bestClassName() == null) {
            throw new IllegalArgumentException("null bestClassName?");
        }
        return this.bestClassName().equals(otherLabel.bestClassName());
    }

    public boolean isCorrect(double otherLabel) {
        if (this.isBinary()) {
            return this.isPositive() && otherLabel >= 0.0;
        }
        throw new IllegalArgumentException("not a binary label");
    }

    public void add(String label, double weight) {
        if (weight > this.bestWeight) {
            this.bestWeight = weight;
            this.bestLabel = label;
        }
        this.wset.add(label, weight);
    }

    public String toString() {
        return "[Class: " + this.bestLabel + " " + this.bestWeight + "]";
    }

    public String toDetails() {
        return "[ClassLabel: " + this.wset + "]";
    }
}

