/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.algorithms.random;

import edu.cmu.minorthird.classify.algorithms.random.Estimate;
import edu.cmu.minorthird.classify.algorithms.random.ProbabilityFactory;
import java.util.TreeMap;

public class Estimators {
    public static Estimate estimateBinomialPN(double[] vCnt, double[] vWgt, double prior, double scale) {
        double p = 0.0;
        double N = 0.0;
        double sumX = 0.0;
        double sumWgt = 0.0;
        double maxCnt = 0.0;
        for (int i = 0; i < vCnt.length; ++i) {
            sumX += vCnt[i];
            sumWgt += vWgt[i];
            maxCnt = Math.max(vCnt[i], maxCnt);
        }
        p = (sumX + prior * 1.0 / scale) / (sumWgt + 1.0 / scale);
        double mean = Estimators.estimateMean(vCnt);
        double var = Estimators.estimateVar(vCnt);
        N = Math.round(Math.max(maxCnt, Math.min(25.0, Math.pow(mean, 2.0) / (mean - var)))) + 1L;
        TreeMap<String, Double> pn = new TreeMap<String, Double>();
        pn.put("p", new Double(p));
        pn.put("N", new Double(N));
        return new Estimate("Binomial", "p/N", pn);
    }

    public static Estimate estimateBinomialMuDelta(double[] vCnt, double[] vWgt, double prior, double scale) {
        double r;
        double m = 0.0;
        double d = 0.0;
        int N = vCnt.length;
        double sumX = 0.0;
        double sumWgt = 0.0;
        double sumWgt2 = 0.0;
        for (int i = 0; i < N; ++i) {
            sumX += vCnt[i];
            sumWgt += vWgt[i];
            sumWgt2 += Math.pow(vWgt[i], 2.0);
        }
        m = (sumX + prior * 1.0 / scale) / (sumWgt + 1.0 / scale);
        double v = 0.0;
        if ((double)N <= 1.0) {
            r = 0.0;
            v = 0.0;
        } else {
            r = (sumWgt - sumWgt2 / sumWgt) / ((double)N - 1.0);
            for (int i = 0; i < N; ++i) {
                v += vWgt[i] * Math.pow(vCnt[i] / vWgt[i] - m, 2.0) / ((double)N - 1.0);
            }
        }
        d = Math.max(0.0, (m - v) / (r * m));
        if (new Double(d).isNaN()) {
            d = 0.0;
        }
        TreeMap<String, Double> mudelta = new TreeMap<String, Double>();
        mudelta.put("mu", new Double(m));
        mudelta.put("delta", new Double(d));
        return new Estimate("Binomial", "mu/delta", mudelta);
    }

    public static Estimate estimateNegativeBinomialMuDelta(double[] vCnt, double[] vWgt, double prior, double scale) {
        double r;
        double m = 0.0;
        double d = 0.0;
        int N = vCnt.length;
        double sumX = 0.0;
        double sumWgt = 0.0;
        double sumWgt2 = 0.0;
        for (int i = 0; i < N; ++i) {
            sumX += vCnt[i];
            sumWgt += vWgt[i] / scale;
            sumWgt2 += Math.pow(vWgt[i] / scale, 2.0);
        }
        m = (sumX + prior * 1.0 / scale) / (sumWgt + 1.0 / scale);
        double v = 0.0;
        if ((double)N <= 1.0) {
            r = 0.0;
            v = 0.0;
        } else {
            r = (sumWgt - sumWgt2 / sumWgt) / ((double)N - 1.0);
            for (int i = 0; i < N; ++i) {
                v += vWgt[i] / scale * Math.pow(vCnt[i] / (vWgt[i] / scale) - m, 2.0) / ((double)N - 1.0);
            }
        }
        d = Math.max(0.0, (v - m) / (r * m));
        if (new Double(d).isNaN()) {
            d = 0.0;
        }
        if (d == 0.0) {
            d = 1.0E-7;
        }
        TreeMap<String, Double> mudelta = new TreeMap<String, Double>();
        mudelta.put("mu", new Double(m));
        mudelta.put("delta", new Double(d));
        return new Estimate("Negative-Binomial", "mu/delta", mudelta);
    }

    public static Estimate estimatePoissonLambda(double classPrior, double numberOfClasses, double observedCounts, double totalCounts) {
        double lambda = (classPrior / numberOfClasses + observedCounts) / (classPrior + totalCounts);
        TreeMap<String, Double> tm = new TreeMap<String, Double>();
        tm.put("lambda", new Double(lambda));
        return new Estimate("Poisson", "lambda", tm);
    }

    public static Estimate estimatePoissonWeightedLambda(double[] vCnt, double[] vWgt, double prior, double scale) {
        double lambda = 0.0;
        int N = vCnt.length;
        double sumX = 0.0;
        double sumWgt = 0.0;
        for (int i = 0; i < N; ++i) {
            sumX += vCnt[i];
            sumWgt += vWgt[i] / scale;
        }
        lambda = (sumX + prior * 1.0 / scale) / (sumWgt + 1.0 / scale);
        TreeMap<String, Double> tm = new TreeMap<String, Double>();
        tm.put("lambda", new Double(lambda));
        return new Estimate("Poisson", "weighted-lambda", tm);
    }

    public static Estimate estimateNaiveBayesMean(double classPrior, double numberOfClasses, double observedCounts, double totalCounts) {
        double mean = (classPrior / numberOfClasses + observedCounts) / (1.0 + totalCounts);
        TreeMap<String, Double> tm = new TreeMap<String, Double>();
        tm.put("mean", new Double(mean));
        return new Estimate("Naive-Bayes", "mean", tm);
    }

    public static Estimate estimateNaiveBayesWeightedMean(double[] vCnt, double[] vWgt, double prior, double scale) {
        double mean = 0.0;
        int N = vCnt.length;
        double sumX = 0.0;
        double sumWgt = 0.0;
        for (int i = 0; i < N; ++i) {
            sumX += vCnt[i];
            sumWgt += vWgt[i] / scale;
        }
        mean = (sumX + prior * 1.0 / scale) / (sumWgt + 1.0 / scale);
        TreeMap<String, Double> tm = new TreeMap<String, Double>();
        tm.put("mean", new Double(mean));
        return new Estimate("Naive-Bayes", "weighted-mean", tm);
    }

    public static Estimate[] mcmcEstimateDirichletPoissonTauSigma(Estimate[] lambdaEstimateVec, double[] vlow, double[] vup, double xr, double xp, double wr, double wp, double[] vbeta, double tauSD, double sigmaSD, int numIterations) {
        int K = lambdaEstimateVec.length;
        double[][] tau = new double[K - 1][numIterations];
        double[] sig = new double[numIterations];
        double[] tauAcceptRate = new double[K - 1];
        double sigAcceptRate = 0.0;
        String parameterization = lambdaEstimateVec[0].getParameterization();
        Estimate[] tauSigmaEstimate = Estimators.ReparametrizeLambdas2TauSig(lambdaEstimateVec);
        for (int i = 0; i < K - 1; ++i) {
            tau[i][0] = (Double)tauSigmaEstimate[i].getPms().get("tau");
        }
        sig[0] = (Double)tauSigmaEstimate[0].getPms().get("sigma");
        for (int it = 1; it < numIterations; ++it) {
            double p;
            double u;
            double candidate;
            for (int i = 0; i < K - 1; ++i) {
                candidate = Math.max(1.0E-7, ProbabilityFactory.rnorm(1, tau[i][it - 1], tauSD)[0]);
                u = ProbabilityFactory.runif(1, 0.0, 1.0)[0];
                if (u <= (p = ProbabilityFactory.AlphaTau(tau[i][it - 1], sig[it - 1], vlow, vup, xr, xp, wr, wp, vbeta, tau[i][it - 1], tauSD, candidate))) {
                    tau[i][it] = candidate;
                    int n = i;
                    tauAcceptRate[n] = tauAcceptRate[n] + 1.0 / (double)numIterations;
                    continue;
                }
                tau[i][it] = tau[i][it - 1];
            }
            candidate = Math.max(1.0E-7, ProbabilityFactory.rnorm(1, sig[it - 1], sigmaSD)[0]);
            u = ProbabilityFactory.runif(1, 0.0, 1.0)[0];
            if (u <= (p = ProbabilityFactory.AlphaSigma(sig[it - 1], tau[0][it], vlow, vup, xr, xp, wr, wp, vbeta, sig[it - 1], sigmaSD, candidate))) {
                sig[it] = candidate;
                sigAcceptRate += 1.0 / (double)numIterations;
                continue;
            }
            sig[it] = sig[it - 1];
        }
        double[] tauPost = new double[K - 1];
        double sigmaPost = 0.0;
        for (int i = 0; i < K - 1; ++i) {
            tauPost[i] = Estimators.estimateMean(tau[i]);
        }
        sigmaPost = Estimators.estimateMean(sig);
        Estimate[] tauSigma = new Estimate[K - 1];
        for (int i = 0; i < K - 1; ++i) {
            TreeMap<String, Double> tm = new TreeMap<String, Double>();
            tm.put("tau", new Double(tauPost[i]));
            tm.put("sigma", new Double(sigmaPost));
            tauSigma[i] = new Estimate("Dirichlet-Poisson MCMC", "tau/sigma", tm);
        }
        return Estimators.ReparametrizeTauSig2Lambdas(tauSigma, parameterization);
    }

    private static Estimate[] ReparametrizeLambdas2TauSig(Estimate[] lambdaEstimateVec) {
        int i;
        int K = lambdaEstimateVec.length;
        double[] lambda = new double[K];
        double[] tau = new double[K];
        double sigma = 0.0;
        double lambdaSum = 0.0;
        for (i = 0; i < K; ++i) {
            lambda[i] = (Double)lambdaEstimateVec[i].getPms().get("lambda");
            lambdaSum += lambda[i];
        }
        for (i = 0; i < K; ++i) {
            tau[i] = lambda[i] / lambdaSum;
            sigma += lambda[i];
        }
        Estimate[] tauSigma = new Estimate[K];
        for (int i2 = 0; i2 < K; ++i2) {
            TreeMap<String, Double> tm = new TreeMap<String, Double>();
            tm.put("tau", new Double(tau[i2]));
            tm.put("sigma", new Double(sigma));
            tauSigma[i2] = new Estimate("Dirichlet-Poisson MCMC", "tau/sigma", tm);
        }
        return tauSigma;
    }

    private static Estimate[] ReparametrizeTauSig2Lambdas(Estimate[] tauSigEstimateVec, String parameterization) {
        int i;
        int K = tauSigEstimateVec.length;
        double[] lambda = new double[K + 1];
        double[] tau = new double[K];
        double sigma = 0.0;
        double tauSum = 0.0;
        for (i = 0; i < K; ++i) {
            tau[i] = (Double)tauSigEstimateVec[i].getPms().get("tau");
            tauSum = tau[i];
        }
        sigma = (Double)tauSigEstimateVec[0].getPms().get("sigma");
        for (i = 0; i < K; ++i) {
            lambda[i] = tau[i] * sigma;
        }
        lambda[K] = (1.0 - tauSum) * sigma;
        Estimate[] lambdaEstimateVec = new Estimate[K + 1];
        for (int i2 = 0; i2 < K + 1; ++i2) {
            TreeMap<String, Double> tm = new TreeMap<String, Double>();
            tm.put("lambda", new Double(lambda[i2]));
            lambdaEstimateVec[i2] = new Estimate("Dirichlet-Poisson MCMC", parameterization, tm);
        }
        return lambdaEstimateVec;
    }

    public static double estimateMean(double[] wgt) {
        double m = 0.0;
        double N = wgt.length;
        for (int i = 0; i < wgt.length; ++i) {
            m += wgt[i];
        }
        return m /= N;
    }

    public static double estimateVar(double[] wgt) {
        double m = 0.0;
        double m2 = 0.0;
        double N = wgt.length;
        for (int i = 0; i < wgt.length; ++i) {
            m += wgt[i];
            m2 += Math.pow(wgt[i], 2.0);
        }
        double v = ((m2 /= N) - Math.pow(m /= N, 2.0)) * N / (N - 1.0);
        if (new Double(v).isNaN()) {
            v = 0.0;
        }
        return v;
    }

    public static double Sum(double[] wgt) {
        double s = 0.0;
        for (int i = 0; i < wgt.length; ++i) {
            s += wgt[i];
        }
        return s;
    }

    public static double Max(double[] v) {
        double maxCnt = 0.0;
        for (int i = 0; i < v.length; ++i) {
            maxCnt = Math.max(v[i], maxCnt);
        }
        return maxCnt;
    }
}

