/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.algorithms.random;

import edu.cmu.minorthird.classify.algorithms.random.RandomElement;

public class Normal {
    protected double mean;
    protected double variance;
    protected double standardDeviation;
    protected double cache;
    protected boolean cacheFilled;
    protected double SQRT_INV;
    protected RandomElement gen = new RandomElement();

    public double nextDouble() {
        return this.nextDouble(this.mean, this.standardDeviation);
    }

    public double nextDouble(double mean, double standardDeviation) {
        double y;
        double x;
        double r;
        if (this.cacheFilled) {
            this.cacheFilled = false;
            return this.cache;
        }
        while ((r = (x = 2.0 * this.gen.raw() - 1.0) * x + (y = 2.0 * this.gen.raw() - 1.0) * y) >= 1.0) {
        }
        double z = Math.sqrt(-2.0 * Math.log(r) / r);
        this.cache = mean + standardDeviation * x * z;
        this.cacheFilled = true;
        return mean + standardDeviation * y * z;
    }

    public void setState(double mean, double standardDeviation) {
        if (mean != this.mean || standardDeviation != this.standardDeviation) {
            this.mean = mean;
            this.standardDeviation = standardDeviation;
            this.variance = standardDeviation * standardDeviation;
            this.cacheFilled = false;
            this.SQRT_INV = 1.0 / Math.sqrt(Math.PI * 2 * this.variance);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.mean + "," + this.standardDeviation + ")";
    }
}

