/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.algorithms.trees;

import edu.cmu.minorthird.classify.BinaryClassifier;
import edu.cmu.minorthird.classify.Explanation;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.Instance;
import java.io.Serializable;

public class CompactDecisionTree
extends BinaryClassifier
implements Serializable {
    static final long serialVersionUID = 20080609L;
    private final int initialVectorSize = 10;
    private int currentElt = 0;
    private int rootNode = -1;
    private boolean[] isLeaf = new boolean[10];
    private Feature[] feature = new Feature[10];
    private double[] threshold = new double[10];
    private int[] trueBranch = new int[10];
    private int[] falseBranch = new int[10];
    private double[] score = new double[10];

    public void setRoot(int root) {
        this.rootNode = root;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("");
        this.toString(buf, 0);
        return buf.toString();
    }

    public void toString(StringBuffer buf, int tab) {
    }

    public void compactStorage() {
        boolean[] isLeafTmp = new boolean[this.currentElt];
        Feature[] featureTmp = new Feature[this.currentElt];
        double[] thresholdTmp = new double[this.currentElt];
        int[] trueBranchTmp = new int[this.currentElt];
        int[] falseBranchTmp = new int[this.currentElt];
        double[] scoreTmp = new double[this.currentElt];
        System.arraycopy(this.isLeaf, 0, isLeafTmp, 0, this.currentElt);
        System.arraycopy(this.feature, 0, featureTmp, 0, this.currentElt);
        System.arraycopy(this.threshold, 0, thresholdTmp, 0, this.currentElt);
        System.arraycopy(this.trueBranch, 0, trueBranchTmp, 0, this.currentElt);
        System.arraycopy(this.falseBranch, 0, falseBranchTmp, 0, this.currentElt);
        System.arraycopy(this.score, 0, scoreTmp, 0, this.currentElt);
        this.isLeaf = isLeafTmp;
        this.score = scoreTmp;
        this.feature = featureTmp;
        this.threshold = thresholdTmp;
        this.trueBranch = trueBranchTmp;
        this.falseBranch = falseBranchTmp;
    }

    private void expandStorage() {
        int currentSize = this.isLeaf.length;
        boolean[] isLeafTmp = new boolean[currentSize * 2];
        Feature[] featureTmp = new Feature[currentSize * 2];
        double[] thresholdTmp = new double[currentSize * 2];
        int[] trueBranchTmp = new int[currentSize * 2];
        int[] falseBranchTmp = new int[currentSize * 2];
        double[] scoreTmp = new double[currentSize * 2];
        System.arraycopy(this.isLeaf, 0, isLeafTmp, 0, this.currentElt);
        System.arraycopy(this.feature, 0, featureTmp, 0, this.currentElt);
        System.arraycopy(this.threshold, 0, thresholdTmp, 0, this.currentElt);
        System.arraycopy(this.trueBranch, 0, trueBranchTmp, 0, this.currentElt);
        System.arraycopy(this.falseBranch, 0, falseBranchTmp, 0, this.currentElt);
        System.arraycopy(this.score, 0, scoreTmp, 0, this.currentElt);
        this.isLeaf = isLeafTmp;
        this.score = scoreTmp;
        this.feature = featureTmp;
        this.threshold = thresholdTmp;
        this.trueBranch = trueBranchTmp;
        this.falseBranch = falseBranchTmp;
    }

    public int addInternalNode(Feature test, int ifTrue, int ifFalse) {
        return this.addInternalNode(test, 0.5, ifTrue, ifFalse);
    }

    public int addInternalNode(Feature test, double thresh, int ifTrue, int ifFalse) {
        if (this.currentElt == this.isLeaf.length) {
            this.expandStorage();
        }
        this.isLeaf[this.currentElt] = false;
        this.score[this.currentElt] = 0.0;
        this.feature[this.currentElt] = test;
        this.threshold[this.currentElt] = thresh;
        this.trueBranch[this.currentElt] = ifTrue;
        this.falseBranch[this.currentElt] = ifFalse;
        ++this.currentElt;
        return this.currentElt - 1;
    }

    public int addLeafNode(double myScore) {
        if (this.currentElt == this.isLeaf.length) {
            this.expandStorage();
        }
        this.isLeaf[this.currentElt] = true;
        this.score[this.currentElt] = myScore;
        this.feature[this.currentElt] = null;
        this.threshold[this.currentElt] = 0.0;
        this.trueBranch[this.currentElt] = 0;
        this.falseBranch[this.currentElt] = 0;
        ++this.currentElt;
        return this.currentElt - 1;
    }

    public double score(Instance instance) {
        return this.score(instance, this.rootNode);
    }

    public double score(Instance instance, int index) {
        if (this.isLeaf[index]) {
            return this.score[index];
        }
        if (instance.getWeight(this.feature[index]) >= this.threshold[index]) {
            return this.score(instance, this.trueBranch[index]);
        }
        return this.score(instance, this.falseBranch[index]);
    }

    public String explain(Instance instance) {
        return "";
    }

    public Explanation getExplanation(Instance instance) {
        Explanation.Node top = new Explanation.Node("DecisionTree Explanation");
        Explanation ex = new Explanation(top);
        return ex;
    }
}

