/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.experiments;

import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.MutableInstance;
import edu.cmu.minorthird.classify.SGMExample;
import edu.cmu.minorthird.classify.relational.RealRelationalDataset;
import edu.cmu.minorthird.classify.relational.StackedGraphicalLearner;
import edu.cmu.minorthird.classify.semisupervised.SemiSupervisedClassifier;
import edu.cmu.minorthird.classify.semisupervised.SemiSupervisedDataset;
import edu.cmu.minorthird.classify.sequential.SequenceClassifier;
import edu.cmu.minorthird.classify.sequential.SequenceDataset;
import edu.cmu.minorthird.util.MathUtil;
import edu.cmu.minorthird.util.ProgressCounter;
import edu.cmu.minorthird.util.Saveable;
import edu.cmu.minorthird.util.StringUtil;
import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.LineCharter;
import edu.cmu.minorthird.util.gui.ParallelViewer;
import edu.cmu.minorthird.util.gui.VanillaViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import edu.cmu.minorthird.util.gui.Visible;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.log4j.Logger;

public class Evaluation
implements Visible,
Serializable,
Saveable {
    private static Logger log = Logger.getLogger(Evaluation.class);
    static final long serialVersionUID = 20080130L;
    public static final int DEFAULT_PARTITION_ID = 0;
    private List<Entry> entryList = new ArrayList<Entry>();
    private transient Matrix cachedPRCMatrix = null;
    private transient Matrix cachedTPFPMatrix = null;
    private transient Matrix cachedConfusionMatrix = null;
    private ExampleSchema schema;
    private Properties properties = new Properties();
    private List<String> propertyKeyList = new ArrayList<String>();
    private boolean isBinary = true;
    public static final String EVAL_FORMAT_NAME = "Minorthird Evaluation";
    public static final String EVAL_EXT = ".eval";

    public Evaluation(ExampleSchema schema) {
        this.schema = schema;
        this.isBinary = schema.equals(ExampleSchema.BINARY_EXAMPLE_SCHEMA);
    }

    public void extend4SGM(StackedGraphicalLearner.StackedGraphicalClassifier c, RealRelationalDataset d, int cvID) {
        Map<String, ClassLabel> rlt = c.classification(d);
        for (String ID : rlt.keySet()) {
            ClassLabel predicted = rlt.get(ID);
            SGMExample example = d.getExampleWithID(ID);
            if (predicted.bestClassName() == null) {
                throw new IllegalArgumentException("predicted can't be null! for example: " + example);
            }
            if (example.getLabel() == null) {
                throw new IllegalArgumentException("predicted can't be null!");
            }
            if (log.isDebugEnabled()) {
                String ok = predicted.isCorrect(example.getLabel()) ? "Y" : "N";
                log.debug("ok: " + ok + "\tpredict: " + predicted + "\ton: " + example);
            }
            this.entryList.add(new Entry(example.asInstance(), predicted, example.getLabel(), this.entryList.size(), cvID));
            this.extendSchema(example.getLabel());
            this.extendSchema(predicted);
            this.cachedPRCMatrix = null;
        }
    }

    public void extend(Classifier c, Dataset d, int cvID) {
        ProgressCounter pc = new ProgressCounter("classifying", "example", d.size());
        Iterator<Example> i = d.iterator();
        while (i.hasNext()) {
            Example ex = i.next();
            ClassLabel p = c.classification(ex);
            this.extend(p, ex, cvID);
            pc.progress();
        }
        pc.finished();
    }

    public void extend(SequenceClassifier c, SequenceDataset d) {
        Iterator<Example[]> i = d.sequenceIterator();
        while (i.hasNext()) {
            Instance[] seq = i.next();
            ClassLabel[] pred = c.classification(seq);
            for (int j = 0; j < seq.length; ++j) {
                this.extend(pred[j], (Example)seq[j], 0);
            }
        }
    }

    public void extend(SemiSupervisedClassifier c, SemiSupervisedDataset d, int cvID) {
        ProgressCounter pc = new ProgressCounter("classifying", "example", d.size());
        Iterator<Example> i = d.iterator();
        while (i.hasNext()) {
            Example ex = i.next();
            ClassLabel p = c.classification(ex);
            this.extend(p, ex, cvID);
            pc.progress();
        }
        pc.finished();
    }

    public void extend(ClassLabel predicted, Example example, int cvID) {
        if (predicted.bestClassName() == null) {
            throw new IllegalArgumentException("predicted can't be null! for example: " + example);
        }
        if (example.getLabel() == null) {
            throw new IllegalArgumentException("predicted can't be null!");
        }
        if (log.isDebugEnabled()) {
            String ok = predicted.isCorrect(example.getLabel()) ? "Y" : "N";
            log.debug("ok: " + ok + "\tpredict: " + predicted + "\ton: " + example);
        }
        this.entryList.add(new Entry(example.asInstance(), predicted, example.getLabel(), this.entryList.size(), cvID));
        this.extendSchema(example.getLabel());
        this.extendSchema(predicted);
        this.cachedPRCMatrix = null;
    }

    public void setProperty(String prop, String value) {
        if (this.properties.getProperty(prop) == null) {
            this.propertyKeyList.add(prop);
        }
        this.properties.setProperty(prop, value);
    }

    public String getProperty(String prop) {
        return this.properties.getProperty(prop, "=unassigned=");
    }

    public ClassLabel getPrediction(int i) {
        return this.entryList.get((int)i).predicted;
    }

    public ClassLabel getActual(int i) {
        return this.entryList.get((int)i).actual;
    }

    public boolean isCorrect(int i) {
        return this.getPrediction(i).isCorrect(this.getActual(i));
    }

    public double errors() {
        double errs = 0.0;
        for (int i = 0; i < this.entryList.size(); ++i) {
            Entry e = this.getEntry(i);
            if (e.actual.bestClassName() == null) {
                throw new IllegalArgumentException("actual label is null?");
            }
            errs += e.predicted.isCorrect(e.actual) ? 0.0 : e.w;
        }
        return errs;
    }

    public double errors(int ID) {
        double errs = 0.0;
        for (int i = 0; i < this.entryList.size(); ++i) {
            Entry e = this.getEntry(i);
            if (e.partitionID != ID) continue;
            errs += e.predicted.isCorrect(e.actual) ? 0.0 : e.w;
        }
        return errs;
    }

    public double[] errorsByClass() {
        int K = this.schema.getNumberOfClasses();
        double[] err = new double[K];
        for (int i = 0; i < this.entryList.size(); ++i) {
            int index;
            Entry e = this.getEntry(i);
            String actualLabel = e.actual.bestClassName();
            int n = index = this.schema.getClassIndex(actualLabel);
            err[n] = err[n] + (e.predicted.isCorrect(e.actual) ? 0.0 : e.w);
        }
        return err;
    }

    public double[] errorsByClass(int ID) {
        int K = this.schema.getNumberOfClasses();
        double[] err = new double[K];
        for (int i = 0; i < this.entryList.size(); ++i) {
            int index;
            Entry e = this.getEntry(i);
            if (e.partitionID != ID) continue;
            String actualLabel = e.actual.bestClassName();
            int n = index = this.schema.getClassIndex(actualLabel);
            err[n] = err[n] + (e.predicted.isCorrect(e.actual) ? 0.0 : e.w);
        }
        return err;
    }

    public double errorsPos() {
        if (!this.isBinary) {
            return -1.0;
        }
        double errsPos = 0.0;
        for (int i = 0; i < this.entryList.size(); ++i) {
            Entry e = this.getEntry(i);
            if (!"POS".equals(e.actual.bestClassName())) continue;
            errsPos += e.predicted.isCorrect(e.actual) ? 0.0 : e.w;
        }
        return errsPos;
    }

    public double errorsPos(int ID) {
        if (!this.isBinary) {
            return -1.0;
        }
        double errsPos = 0.0;
        for (int i = 0; i < this.entryList.size(); ++i) {
            Entry e = this.getEntry(i);
            if (!("POS".equals(e.actual.bestClassName()) & e.partitionID == ID)) continue;
            errsPos += e.predicted.isCorrect(e.actual) ? 0.0 : e.w;
        }
        return errsPos;
    }

    public double errorsNeg() {
        double errsNeg = 0.0;
        for (int i = 0; i < this.entryList.size(); ++i) {
            Entry e = this.getEntry(i);
            if (!"NEG".equals(e.actual.bestClassName())) continue;
            errsNeg += e.predicted.isCorrect(e.actual) ? 0.0 : e.w;
        }
        return errsNeg;
    }

    public double errorsNeg(int ID) {
        double errsNeg = 0.0;
        for (int i = 0; i < this.entryList.size(); ++i) {
            Entry e = this.getEntry(i);
            if (!("NEG".equals(e.actual.bestClassName()) & e.partitionID == ID)) continue;
            errsNeg += e.predicted.isCorrect(e.actual) ? 0.0 : e.w;
        }
        return errsNeg;
    }

    public double stDevErrors() {
        int cvFolds = 0;
        for (int i = 0; i < this.entryList.size(); ++i) {
            Entry e = this.getEntry(i);
            if (e.partitionID <= cvFolds) continue;
            cvFolds = e.partitionID + 1;
        }
        double mean = this.errorRate();
        double stDev = 0.0;
        for (int k = 0; k < cvFolds; ++k) {
            stDev += Math.pow(this.errors(k) / this.numberOfInstances(k) - mean, 2.0) / (double)cvFolds;
        }
        return Math.sqrt(stDev);
    }

    public double[] stDevErrorsByClass() {
        int K = this.schema.getNumberOfClasses();
        int cvFolds = 0;
        for (int i = 0; i < this.entryList.size(); ++i) {
            Entry e = this.getEntry(i);
            if (e.partitionID <= cvFolds) continue;
            cvFolds = e.partitionID + 1;
        }
        double[] mean = this.errorRateByClass();
        double[] stdev = new double[K];
        for (int k = 0; k < cvFolds; ++k) {
            double[] errorsByClass = this.errorsByClass(k);
            double[] numerOfExamplesByClass = this.numberOfExamplesByClass(k);
            for (int i = 0; i < K; ++i) {
                int n = i;
                stdev[n] = stdev[n] + Math.pow(errorsByClass[i] / numerOfExamplesByClass[i] - mean[i], 2.0) / (double)cvFolds;
            }
        }
        for (int i = 0; i < K; ++i) {
            stdev[i] = Math.sqrt(stdev[i]);
        }
        return stdev;
    }

    public double stDevErrorsPos() {
        if (!this.isBinary) {
            return -1.0;
        }
        int cvFolds = 0;
        for (int i = 0; i < this.entryList.size(); ++i) {
            Entry e = this.getEntry(i);
            if (e.partitionID <= cvFolds) continue;
            cvFolds = e.partitionID + 1;
        }
        double mean = this.errorsPos() / this.numberOfPositiveExamples();
        double variance = 0.0;
        for (int k = 0; k < cvFolds; ++k) {
            variance += Math.pow(this.errorsPos(k) / this.numberOfPositiveExamples(k) - mean, 2.0) / (double)cvFolds;
        }
        return Math.sqrt(variance);
    }

    public double stDevErrorsNeg() {
        if (!this.isBinary) {
            return -1.0;
        }
        int cvFolds = 0;
        for (int i = 0; i < this.entryList.size(); ++i) {
            Entry e = this.getEntry(i);
            if (e.partitionID <= cvFolds) continue;
            cvFolds = e.partitionID + 1;
        }
        double mean = this.errorsNeg() / this.numberOfNegativeExamples();
        double variance = 0.0;
        for (int k = 0; k < cvFolds; ++k) {
            variance += Math.pow(this.errorsNeg(k) / this.numberOfNegativeExamples(k) - mean, 2.0) / (double)cvFolds;
        }
        return Math.sqrt(variance);
    }

    public double numberOfInstances() {
        double n = 0.0;
        for (int i = 0; i < this.entryList.size(); ++i) {
            n += this.getEntry((int)i).w;
        }
        return n;
    }

    public double numberOfInstances(int ID) {
        double n = 0.0;
        for (int i = 0; i < this.entryList.size(); ++i) {
            Entry e = this.getEntry(i);
            if (e.partitionID != ID) continue;
            n += e.w;
        }
        return n;
    }

    public double[] numberOfExamplesByClass() {
        int K = this.schema.getNumberOfClasses();
        double[] wgt = new double[K];
        for (int i = 0; i < this.entryList.size(); ++i) {
            int index;
            Entry e = this.getEntry(i);
            String actualLabel = e.actual.bestClassName();
            int n = index = this.schema.getClassIndex(actualLabel);
            wgt[n] = wgt[n] + e.w;
        }
        return wgt;
    }

    public double[] numberOfExamplesByClass(int ID) {
        int K = this.schema.getNumberOfClasses();
        double[] wgt = new double[K];
        for (int i = 0; i < this.entryList.size(); ++i) {
            Entry e = this.getEntry(i);
            String actualLabel = e.actual.bestClassName();
            int index = this.schema.getClassIndex(actualLabel);
            if (e.partitionID != ID) continue;
            int n = index;
            wgt[n] = wgt[n] + e.w;
        }
        return wgt;
    }

    public double numberOfPositiveExamples() {
        if (!this.isBinary) {
            return -1.0;
        }
        double n = 0.0;
        for (int i = 0; i < this.entryList.size(); ++i) {
            Entry e = this.getEntry(i);
            if (!"POS".equals(e.actual.bestClassName())) continue;
            n += e.w;
        }
        return n;
    }

    public double numberOfPositiveExamples(int ID) {
        if (!this.isBinary) {
            return -1.0;
        }
        double n = 0.0;
        for (int i = 0; i < this.entryList.size(); ++i) {
            Entry e = this.getEntry(i);
            if (!("POS".equals(e.actual.bestClassName()) & e.partitionID == ID)) continue;
            n += e.w;
        }
        return n;
    }

    public double numberOfNegativeExamples() {
        double n = 0.0;
        for (int i = 0; i < this.entryList.size(); ++i) {
            Entry e = this.getEntry(i);
            if (!"NEG".equals(e.actual.bestClassName())) continue;
            n += e.w;
        }
        return n;
    }

    public double numberOfNegativeExamples(int ID) {
        double n = 0.0;
        for (int i = 0; i < this.entryList.size(); ++i) {
            Entry e = this.getEntry(i);
            if (!("NEG".equals(e.actual.bestClassName()) & e.partitionID == ID)) continue;
            n += e.w;
        }
        return n;
    }

    public double errorRate() {
        return this.errors() / this.numberOfInstances();
    }

    public double[] errorRateByClass() {
        int K = this.schema.getNumberOfClasses();
        double[] errRate = new double[K];
        double[] err = this.errorsByClass();
        double[] wgt = this.numberOfExamplesByClass();
        for (int i = 0; i < K; ++i) {
            errRate[i] = err[i] / wgt[i];
        }
        return errRate;
    }

    public double errorRatePos() {
        return this.errorsPos() / this.numberOfPositiveExamples();
    }

    public double errorRateNeg() {
        return this.errorsNeg() / this.numberOfNegativeExamples();
    }

    public double errorRateBalanced() {
        double errorBalanced = 0.0;
        int K = this.schema.getNumberOfClasses();
        double[] errorsByClass = this.errorsByClass();
        double[] numerOfExamplesByClass = this.numberOfExamplesByClass();
        for (int i = 0; i < K; ++i) {
            errorBalanced += 1.0 / (double)K * errorsByClass[i] / numerOfExamplesByClass[i];
        }
        return errorBalanced;
    }

    public double recallTopK(int k, double minScore) {
        if (!this.isBinary) {
            return -1.0;
        }
        if (this.numberOfPositiveExamples() == 0.0) {
            return 1.0;
        }
        double lastRecall = 0.0;
        double numPositiveExamplesInTopK = 0.0;
        Matrix m = this.precisionRecallScore();
        for (int i = 0; i < Math.min(m.values.length, k); ++i) {
            if (m.values[i][1] > lastRecall && m.values[i][2] > minScore) {
                numPositiveExamplesInTopK += 1.0;
            }
            lastRecall = m.values[i][1];
        }
        return numPositiveExamplesInTopK / this.numberOfPositiveExamples();
    }

    public double averagePrecision() {
        if (!this.isBinary) {
            return -1.0;
        }
        if (this.numberOfInstances() == 0.0) {
            return Double.NaN;
        }
        double total = 0.0;
        double n = 0.0;
        Matrix m = this.precisionRecallScore();
        double lastRecall = 0.0;
        for (int i = 0; i < m.values.length; ++i) {
            if (m.values[i][1] > lastRecall) {
                n += 1.0;
                total += m.values[i][0];
            }
            lastRecall = m.values[i][1];
        }
        return total / n;
    }

    public double maxF1() {
        return this.maxF1(Double.MIN_VALUE);
    }

    public double maxF1(double minThreshold) {
        if (!this.isBinary) {
            return -1.0;
        }
        if (this.numberOfPositiveExamples() == 0.0) {
            return 1.0;
        }
        double maxF1 = 0.0;
        Matrix m = this.precisionRecallScore();
        for (int i = 0; i < m.values.length; ++i) {
            double p = m.values[i][0];
            double r = m.values[i][1];
            if (!(p > 0.0) && !(r > 0.0) || !(m.values[i][2] >= minThreshold)) continue;
            double f1 = 2.0 * p * r / (p + r);
            maxF1 = Math.max(maxF1, f1);
        }
        return maxF1;
    }

    public double kappa() {
        Matrix cm = this.confusionMatrix();
        double n = this.entryList.size();
        int k = this.schema.getNumberOfClasses();
        double[] numActual = new double[k];
        double[] numPredicted = new double[k];
        double numAgree = 0.0;
        for (int i = 0; i < k; ++i) {
            numAgree += cm.values[i][i];
            for (int j = 0; j < k; ++j) {
                int n2 = i;
                numActual[n2] = numActual[n2] + cm.values[i][j];
                int n3 = i;
                numPredicted[n3] = numPredicted[n3] + cm.values[j][i];
            }
        }
        double randomAgreement = 0.0;
        for (int i = 0; i < k; ++i) {
            randomAgreement += numActual[i] / n * (numPredicted[i] / n);
        }
        return (numAgree / n - randomAgreement) / (1.0 - randomAgreement);
    }

    public int numExamples() {
        return this.entryList.size();
    }

    public double averageLogLoss() {
        double tot = 0.0;
        for (int i = 0; i < this.entryList.size(); ++i) {
            Entry e = this.getEntry(i);
            double confidence = e.predicted.getWeight(e.actual.bestClassName());
            double error = e.predicted.isCorrect(e.actual) ? 1.0 : -1.0;
            tot += Math.log(1.0 + Math.exp(confidence * error));
        }
        return tot / (double)this.entryList.size();
    }

    public double precision() {
        if (!this.isBinary) {
            return -1.0;
        }
        Matrix cm = this.confusionMatrix();
        int p = this.classIndexOf("POS");
        int n = this.classIndexOf("NEG");
        return cm.values[p][p] / (cm.values[p][p] + cm.values[n][p]);
    }

    public double recall() {
        if (!this.isBinary) {
            return -1.0;
        }
        Matrix cm = this.confusionMatrix();
        int p = this.classIndexOf("POS");
        int n = this.classIndexOf("NEG");
        return cm.values[p][p] / (cm.values[p][p] + cm.values[p][n]);
    }

    public double f1() {
        if (!this.isBinary) {
            return -1.0;
        }
        double p = this.precision();
        double r = this.recall();
        return 2.0 * p * r / (p + r);
    }

    public double[] summaryStatistics() {
        int K = this.schema.getNumberOfClasses();
        if (this.isBinary) {
            double[] stats = new double[10 + 2 * K];
            stats[0] = this.errorRate();
            stats[1] = this.stDevErrors();
            stats[2] = this.errorRateBalanced();
            double[] err = this.errorRateByClass();
            double[] sd = this.stDevErrorsByClass();
            for (int i = 0; i < K; ++i) {
                stats[2 + 2 * i + 1] = err[i];
                stats[2 + 2 * i + 2] = sd[i];
            }
            stats[3 + 2 * K] = this.averagePrecision();
            stats[4 + 2 * K] = this.maxF1();
            stats[5 + 2 * K] = this.averageLogLoss();
            stats[6 + 2 * K] = this.recall();
            stats[7 + 2 * K] = this.precision();
            stats[8 + 2 * K] = this.f1();
            stats[9 + 2 * K] = this.kappa();
            return stats;
        }
        double[] stats = new double[4 + 2 * K];
        stats[0] = this.errorRate();
        stats[1] = this.stDevErrors();
        stats[2] = this.errorRateBalanced();
        double[] err = this.errorRateByClass();
        double[] sd = this.stDevErrorsByClass();
        for (int i = 0; i < K; ++i) {
            stats[2 + 2 * i + 1] = err[i];
            stats[2 + 2 * i + 2] = sd[i];
        }
        stats[3 + 2 * K] = this.kappa();
        return stats;
    }

    public String[] summaryStatisticNames() {
        int K = this.schema.getNumberOfClasses();
        if (this.isBinary) {
            String[] names = new String[10 + 2 * K];
            names[0] = "Error Rate";
            names[1] = ". std. deviation error rate";
            names[2] = "Balanced Error Rate";
            for (int i = 0; i < K; ++i) {
                String classname = this.schema.getClassName(i);
                names[2 + 2 * i + 1] = new String(". error Rate on " + classname);
                names[2 + 2 * i + 2] = new String(". std. deviation on " + classname);
            }
            names[3 + 2 * K] = "Average Precision";
            names[4 + 2 * K] = "Maximium F1";
            names[5 + 2 * K] = "Average Log Loss";
            names[6 + 2 * K] = "Recall";
            names[7 + 2 * K] = "Precision";
            names[8 + 2 * K] = "F1";
            names[9 + 2 * K] = "Kappa";
            return names;
        }
        String[] names = new String[4 + 2 * K];
        names[0] = "Error Rate";
        names[1] = ". std. deviation error rate";
        names[2] = "Balanced Error Rate";
        for (int i = 0; i < K; ++i) {
            String classname = this.schema.getClassName(i);
            names[2 + 2 * i + 1] = new String(". error Rate on " + classname);
            names[2 + 2 * i + 2] = new String(". std. deviation on " + classname);
        }
        names[3 + 2 * K] = "Kappa";
        return names;
    }

    public Matrix confusionMatrix() {
        if (this.cachedConfusionMatrix != null) {
            return this.cachedConfusionMatrix;
        }
        String[] classes = this.getClasses();
        double[][] confused = new double[classes.length][classes.length];
        for (int i = 0; i < this.entryList.size(); ++i) {
            Entry e = this.getEntry(i);
            double[] dArray = confused[this.classIndexOf(e.actual)];
            int n = this.classIndexOf(e.predicted);
            dArray[n] = dArray[n] + 1.0;
        }
        this.cachedConfusionMatrix = new Matrix(confused);
        return this.cachedConfusionMatrix;
    }

    public double numErrors() {
        Matrix m = this.confusionMatrix();
        double errors = m.getValue(0, 1) + m.getValue(1, 0);
        return errors;
    }

    public String[] getClasses() {
        return this.schema.validClassNames();
    }

    public Matrix TPfractionFPfractionScore() {
        if (this.cachedTPFPMatrix != null) {
            return this.cachedTPFPMatrix;
        }
        if (!this.isBinary) {
            throw new IllegalArgumentException("can't compute precisionRecallScore for non-binary data");
        }
        this.byBinaryScore();
        int allActualPos = 0;
        int allActualNeg = 0;
        int lastIndexOfActualPos = 0;
        int firstIndexOfActualNeg = 0;
        boolean notFoundYet = true;
        ProgressCounter pc = new ProgressCounter("counting positive examples", "examples", this.entryList.size());
        for (int i = 0; i < this.entryList.size(); ++i) {
            if (this.getEntry((int)i).actual.isPositive()) {
                ++allActualPos;
                lastIndexOfActualPos = i;
            } else {
                ++allActualNeg;
                if (notFoundYet) {
                    firstIndexOfActualNeg = i;
                    notFoundYet = false;
                }
            }
            pc.progress();
        }
        pc.finished();
        int length = Math.abs(lastIndexOfActualPos - firstIndexOfActualNeg) + 4;
        int min = Math.min(lastIndexOfActualPos, firstIndexOfActualNeg);
        int max = Math.max(lastIndexOfActualPos, firstIndexOfActualNeg);
        double truePosSoFar = 0.0;
        double falsePosSoFar = 0.0;
        double tpf = 1.0;
        double fpf = 1.0;
        double score = 0.0;
        ProgressCounter pc2 = new ProgressCounter("computing statistics", "examples", this.entryList.size());
        double[][] result = new double[length][3];
        for (int i = 0; i < this.entryList.size(); ++i) {
            Entry e = this.getEntry(i);
            score = e.predicted.posWeight();
            if (e.actual.isPositive()) {
                truePosSoFar += 1.0;
            } else {
                falsePosSoFar += 1.0;
            }
            if (allActualPos > 0) {
                tpf = truePosSoFar / (double)allActualPos;
            }
            if (allActualNeg > 0) {
                fpf = falsePosSoFar / (double)allActualNeg;
            }
            if (i == 0) {
                result[0][0] = 0.0;
                result[0][1] = 0.0;
                result[0][2] = score;
            }
            if (i >= min - 1 & i <= max) {
                result[i - min + 2][0] = tpf;
                result[i - min + 2][1] = fpf;
                result[i - min + 2][2] = score;
            }
            result[length - 1][0] = 1.0;
            result[length - 1][1] = 1.0;
            result[length - 1][2] = score;
            pc2.progress();
        }
        pc2.finished();
        this.cachedTPFPMatrix = new Matrix(result);
        return this.cachedTPFPMatrix;
    }

    public Matrix thousandPointROC() {
        Matrix m = this.TPfractionFPfractionScore();
        int N = m.values.length - 2;
        if (N > 1000) {
            double[][] v = new double[1002][3];
            int mod = N / 1000;
            v[0][0] = m.values[0][0];
            v[0][1] = m.values[0][1];
            v[0][2] = m.values[0][2];
            for (int i = 1; i <= 1000; ++i) {
                int k = (i - 1) * mod;
                v[i][0] = m.values[k + 1][0];
                v[i][1] = m.values[k + 1][1];
                v[i][2] = m.values[k + 1][2];
            }
            v[1001][0] = m.values[N + 1][0];
            v[1001][1] = m.values[N + 1][1];
            v[1001][2] = m.values[N + 1][2];
            return new Matrix(v);
        }
        return m;
    }

    public Matrix precisionRecallScore() {
        if (this.cachedPRCMatrix != null) {
            return this.cachedPRCMatrix;
        }
        if (!this.isBinary) {
            throw new IllegalArgumentException("can't compute precisionRecallScore for non-binary data");
        }
        this.byBinaryScore();
        int allActualPos = 0;
        int lastIndexOfActualPos = 0;
        ProgressCounter pc = new ProgressCounter("counting positive examples", "examples", this.entryList.size());
        for (int i = 0; i < this.entryList.size(); ++i) {
            if (this.getEntry((int)i).actual.isPositive()) {
                ++allActualPos;
                lastIndexOfActualPos = i;
            }
            pc.progress();
        }
        pc.finished();
        double truePosSoFar = 0.0;
        double falsePosSoFar = 0.0;
        double precision = 1.0;
        double recall = 1.0;
        double score = 0.0;
        ProgressCounter pc2 = new ProgressCounter("computing statistics", "examples", lastIndexOfActualPos);
        double[][] result = new double[lastIndexOfActualPos + 1][3];
        for (int i = 0; i <= lastIndexOfActualPos; ++i) {
            Entry e = this.getEntry(i);
            score = e.predicted.posWeight();
            if (e.actual.isPositive()) {
                truePosSoFar += 1.0;
            } else {
                falsePosSoFar += 1.0;
            }
            if (truePosSoFar + falsePosSoFar > 0.0) {
                precision = truePosSoFar / (truePosSoFar + falsePosSoFar);
            }
            if (allActualPos > 0) {
                recall = truePosSoFar / (double)allActualPos;
            }
            result[i][0] = precision;
            result[i][1] = recall;
            result[i][2] = score;
            pc2.progress();
        }
        pc2.finished();
        this.cachedPRCMatrix = new Matrix(result);
        return this.cachedPRCMatrix;
    }

    public double[] elevenPointPrecision() {
        Matrix m = this.precisionRecallScore();
        double[] p = new double[11];
        p[0] = 1.0;
        for (int i = 0; i < m.values.length; ++i) {
            double r = m.values[i][1];
            for (int j = 1; j <= 10; ++j) {
                if (!(r >= (double)j / 10.0)) continue;
                p[j] = Math.max(p[j], m.values[i][0]);
            }
        }
        return p;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("");
        for (int i = 0; i < this.entryList.size(); ++i) {
            buf.append(this.getEntry(i) + "\n");
        }
        return buf.toString();
    }

    public void summarize() {
        int i;
        double[] stats = this.summaryStatistics();
        String[] statNames = this.summaryStatisticNames();
        int maxLen = 0;
        for (i = 0; i < statNames.length; ++i) {
            maxLen = Math.max(statNames[i].length(), maxLen);
        }
        for (i = 0; i < statNames.length; ++i) {
            System.out.print(statNames[i] + ": ");
            for (int j = 0; j < maxLen - statNames[i].length(); ++j) {
                System.out.print(" ");
            }
            System.out.println(stats[i]);
        }
    }

    public Viewer toGUI() {
        ParallelViewer main = new ParallelViewer();
        main.addSubView("Summary", new SummaryViewer());
        main.addSubView("Properties", new PropertyViewer());
        if (this.isBinary) {
            main.addSubView("11Pt Precision/Recall", new ElevenPointPrecisionViewer());
        }
        if (this.isBinary) {
            main.addSubView(" ROC & AUC ", new ROCViewer());
        }
        main.addSubView("Confusion Matrix", new ConfusionMatrixViewer());
        main.addSubView("Debug", new VanillaViewer());
        main.setContent(this);
        return main;
    }

    public String[] getFormatNames() {
        return new String[]{EVAL_FORMAT_NAME};
    }

    public String getExtensionFor(String format) {
        return EVAL_EXT;
    }

    public void saveAs(File file, String formatName) throws IOException {
        this.save(file);
    }

    public Object restore(File file) throws IOException {
        return Evaluation.load(file);
    }

    public void save(File file) throws IOException {
        PrintStream out = new PrintStream(new GZIPOutputStream(new FileOutputStream(file)));
        this.save(out);
    }

    public void save(PrintStream out) throws IOException {
        out.println(StringUtil.toString(this.schema.validClassNames()));
        for (String prop : this.propertyKeyList) {
            String value = this.properties.getProperty(prop);
            out.println(prop + "=" + value);
        }
        this.byOriginalPosition();
        for (Entry e : this.entryList) {
            out.println(e.predicted.bestClassName() + " " + e.predicted.bestWeight() + " " + e.actual.bestClassName());
        }
        out.close();
    }

    public static Evaluation load(File file) throws IOException {
        LineNumberReader in = new LineNumberReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(file))));
        String line = in.readLine();
        if (line == null) {
            throw new IllegalArgumentException("no class list on line 1 of file " + file.getName());
        }
        String[] classes = line.substring(1, line.length() - 1).split(",");
        ExampleSchema schema = new ExampleSchema(classes);
        Evaluation result = new Evaluation(schema);
        while ((line = in.readLine()) != null) {
            if (line.indexOf(61) >= 0) {
                String[] propValue = line.split("=");
                if (propValue.length == 2) {
                    result.setProperty(propValue[0], propValue[1]);
                    continue;
                }
                if (propValue.length == 1) {
                    result.setProperty(propValue[0], "");
                    continue;
                }
                throw new IllegalArgumentException(file.getName() + " line " + in.getLineNumber() + ": illegal format");
            }
            String[] words = line.split(" ");
            if (words.length < 3) {
                throw new IllegalArgumentException(file.getName() + " line " + in.getLineNumber() + ": illegal format");
            }
            ClassLabel predicted = new ClassLabel(words[0], StringUtil.atof(words[1]));
            ClassLabel actual = new ClassLabel(words[2]);
            MutableInstance instance = new MutableInstance("dummy");
            Example example = new Example(instance, actual);
            result.extend(predicted, example, 0);
        }
        in.close();
        return result;
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    public ExampleSchema getSchema() {
        return this.schema;
    }

    private Entry getEntry(int i) {
        return this.entryList.get(i);
    }

    private int classIndexOf(ClassLabel classLabel) {
        return this.classIndexOf(classLabel.bestClassName());
    }

    private int classIndexOf(String classLabelName) {
        return this.schema.getClassIndex(classLabelName);
    }

    private void extendSchema(ClassLabel classLabel) {
        int r;
        if (!classLabel.isBinary()) {
            this.isBinary = false;
        }
        if ((r = this.classIndexOf(classLabel.bestClassName())) < 0) {
            this.schema.extend(classLabel.bestClassName());
        }
    }

    private void byBinaryScore() {
        Collections.sort(this.entryList, new Comparator<Entry>(){

            @Override
            public int compare(Entry a, Entry b) {
                return MathUtil.sign(b.predicted.posWeight() - a.predicted.posWeight());
            }
        });
    }

    private void byOriginalPosition() {
        Collections.sort(this.entryList, new Comparator<Entry>(){

            @Override
            public int compare(Entry a, Entry b) {
                return a.index - b.index;
            }
        });
    }

    public static void main(String[] args) {
        try {
            Evaluation v = Evaluation.load(new File(args[0]));
            if (args.length > 1) {
                v.save(new File(args[1]));
            }
            new ViewerFrame("From file " + args[0], v.toGUI());
        }
        catch (Exception e) {
            System.out.println("usage: Evaluation [serializedFile|evaluationFile] [evaluationFile]");
            e.printStackTrace();
        }
    }

    public class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        static final long serialVersionUID = 20080130L;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (row % 2 != 0) {
                label.setBackground(Color.lightGray);
                label.setOpaque(true);
            } else {
                label.setBackground(Color.white);
                label.setOpaque(true);
            }
            return label;
        }
    }

    private static class Entry
    implements Serializable {
        private static final long serialVersionUID = -4069980043842319179L;
        public transient Instance instance = null;
        public int partitionID;
        public int index;
        public ClassLabel predicted;
        public ClassLabel actual;
        public int h;
        public double w = 1.0;

        public Entry(Instance i, ClassLabel p, ClassLabel a, int k, int id) {
            this.instance = i;
            this.predicted = p;
            this.actual = a;
            this.index = k;
            this.partitionID = id;
            this.h = this.instance.hashCode();
        }

        public String toString() {
            return this.predicted + "\t" + this.actual + "\t" + this.instance;
        }
    }

    public static class ConfusionMatrixViewer
    extends ComponentViewer {
        static final long serialVersionUID = 20080130L;

        public JComponent componentFor(Object o) {
            int i;
            Evaluation e = (Evaluation)o;
            JPanel panel = new JPanel();
            Matrix m = e.confusionMatrix();
            String[] classes = e.getClasses();
            panel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = this.cmGBC(0, 1);
            gbc.gridwidth = classes.length;
            panel.add((Component)new JLabel("Predicted Class"), gbc);
            for (i = 0; i < classes.length; ++i) {
                panel.add((Component)new JLabel(classes[i]), this.cmGBC(1, i + 1));
            }
            for (i = 0; i < classes.length; ++i) {
                panel.add((Component)new JLabel(classes[i]), this.cmGBC(i + 2, 0));
                for (int j = 0; j < classes.length; ++j) {
                    panel.add((Component)new JLabel(Double.toString(m.values[i][j])), this.cmGBC(i + 2, j + 1));
                }
            }
            return panel;
        }

        private GridBagConstraints cmGBC(int i, int j) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.weighty = 0.0;
            gbc.weightx = 0.0;
            gbc.gridy = i;
            gbc.gridx = j;
            gbc.ipady = 20;
            gbc.ipadx = 20;
            return gbc;
        }
    }

    public static class ROCViewer
    extends ComponentViewer {
        static final long serialVersionUID = 20080130L;

        public JComponent componentFor(Object o) {
            Evaluation e = (Evaluation)o;
            Matrix p = e.thousandPointROC();
            LineCharter lc = new LineCharter();
            lc.startCurve("Actual ROC");
            for (int i = 0; i < p.values.length; ++i) {
                lc.addPoint(p.values[i][1], p.values[i][0]);
            }
            double area = 0.0;
            for (int i = 0; i < p.values.length - 1; ++i) {
                area += (p.values[i][0] + p.values[i + 1][0]) * (p.values[i + 1][1] - p.values[i][1]) / 2.0;
            }
            return lc.getPanel("Actual ROC Curve", "False Positive / All Negative   (AUC = " + area + ")", "True Positive / All Positive");
        }
    }

    public static class ElevenPointPrecisionViewer
    extends ComponentViewer {
        static final long serialVersionUID = 20080130L;

        public JComponent componentFor(Object o) {
            Evaluation e = (Evaluation)o;
            double[] p = e.elevenPointPrecision();
            LineCharter lc = new LineCharter();
            lc.startCurve("Interpolated Precision");
            for (int i = 0; i < p.length; ++i) {
                lc.addPoint((double)i / 10.0, p[i]);
            }
            return lc.getPanel("11-Pt Interpolated Precision vs. Recall", "Recall", "Precision");
        }
    }

    public class SummaryViewer
    extends ComponentViewer {
        static final long serialVersionUID = 20080130L;

        public JComponent componentFor(Object o) {
            Evaluation e = (Evaluation)o;
            double[] ss = e.summaryStatistics();
            String[] ssn = e.summaryStatisticNames();
            Object[][] oss = new Object[ss.length][2];
            for (int i = 0; i < ss.length; ++i) {
                oss[i][0] = ssn[i];
                oss[i][1] = new Double(ss[i]);
            }
            JTable jtable = new JTable(oss, new String[]{"Statistic", "Value"});
            jtable.setDefaultRenderer(Object.class, new MyTableCellRenderer());
            jtable.setVisible(true);
            return new JScrollPane(jtable);
        }
    }

    public static class PropertyViewer
    extends ComponentViewer {
        static final long serialVersionUID = 20080130L;

        public JComponent componentFor(Object o) {
            final Evaluation e = (Evaluation)o;
            final JPanel panel = new JPanel();
            final JTextField propField = new JTextField(10);
            final JTextField valField = new JTextField(10);
            JTable table = this.makePropertyTable(e);
            final JScrollPane tableScroller = new JScrollPane(table);
            JButton addButton = new JButton(new AbstractAction("Insert Property"){
                static final long serialVersionUID = 20080130L;

                public void actionPerformed(ActionEvent event) {
                    e.setProperty(propField.getText(), valField.getText());
                    tableScroller.getViewport().setView(PropertyViewer.this.makePropertyTable(e));
                    tableScroller.revalidate();
                    panel.revalidate();
                }
            });
            panel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = PropertyViewer.fillerGBC();
            gbc.gridwidth = 3;
            panel.add((Component)tableScroller, gbc);
            panel.add((Component)addButton, this.myGBC(0));
            panel.add((Component)propField, this.myGBC(1));
            panel.add((Component)valField, this.myGBC(2));
            return panel;
        }

        private GridBagConstraints myGBC(int col) {
            GridBagConstraints gbc = PropertyViewer.fillerGBC();
            gbc.fill = 2;
            gbc.gridx = col;
            gbc.gridy = 1;
            return gbc;
        }

        private JTable makePropertyTable(Evaluation e) {
            Object[][] table = new Object[e.propertyKeyList.size()][2];
            for (int i = 0; i < e.propertyKeyList.size(); ++i) {
                table[i][0] = e.propertyKeyList.get(i);
                table[i][1] = e.properties.get(e.propertyKeyList.get(i));
            }
            Object[] colNames = new String[]{"Property", "Property's Value"};
            return new JTable(table, colNames);
        }
    }

    public static class Matrix {
        public double[][] values;

        public Matrix(double[][] values) {
            this.values = values;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("");
            for (int i = 0; i < this.values.length; ++i) {
                buf.append(StringUtil.toString(this.values[i]) + "\n");
            }
            return buf.toString();
        }

        public double getValue(int row, int col) {
            return this.values[row][col];
        }
    }
}

