/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.experiments;

import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Splitter;
import edu.cmu.minorthird.classify.experiments.StrataSorter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StratifiedCrossValSplitter
implements Splitter<Example> {
    private Random random;
    private int folds;
    private List<List<Example>> strata;

    public StratifiedCrossValSplitter(Random random2, int folds) {
        this.random = random2;
        this.folds = folds;
    }

    public StratifiedCrossValSplitter(int folds) {
        this(new Random(), folds);
    }

    public StratifiedCrossValSplitter() {
        this(5);
    }

    @Override
    public void split(Iterator<Example> i) {
        this.strata = new ArrayList<List<Example>>();
        Iterator<List<Example>> j = new StrataSorter(this.random, i).strataIterator();
        while (j.hasNext()) {
            this.strata.add(j.next());
        }
    }

    @Override
    public int getNumPartitions() {
        return this.folds;
    }

    @Override
    public Iterator<Example> getTrain(int k) {
        ArrayList<Example> trainList = new ArrayList<Example>();
        for (int i = 0; i < this.strata.size(); ++i) {
            for (int j = 0; j < this.strata.get(i).size(); ++j) {
                if (j % this.folds == k) continue;
                trainList.add(this.strata.get(i).get(j));
            }
        }
        return trainList.iterator();
    }

    @Override
    public Iterator<Example> getTest(int k) {
        ArrayList<Example> testList = new ArrayList<Example>();
        for (int i = 0; i < this.strata.size(); ++i) {
            for (int j = 0; j < this.strata.get(i).size(); ++j) {
                if (j % this.folds != k) continue;
                testList.add(this.strata.get(i).get(j));
            }
        }
        return testList.iterator();
    }

    public String toString() {
        return "[" + this.folds + "-Stratified CV splitter]";
    }
}

