/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.ranking;

import edu.cmu.minorthird.classify.BinaryClassifier;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.DatasetClassifierTeacher;
import edu.cmu.minorthird.classify.DatasetLoader;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Splitter;
import edu.cmu.minorthird.classify.experiments.CrossValSplitter;
import edu.cmu.minorthird.classify.experiments.Expt;
import edu.cmu.minorthird.classify.ranking.BatchRankingLearner;
import edu.cmu.minorthird.classify.ranking.RankingEvaluation;
import edu.cmu.minorthird.classify.ranking.RankingPerceptron;
import edu.cmu.minorthird.util.BasicCommandLineProcessor;
import edu.cmu.minorthird.util.CommandLineProcessor;
import edu.cmu.minorthird.util.IOUtil;
import edu.cmu.minorthird.util.ProgressCounter;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class RankingExpt {
    private String dataFileName = null;
    private BatchRankingLearner classifierLearner = new RankingPerceptron();
    private Splitter<Example> splitter = new CrossValSplitter<Example>();
    private String saveFile = null;
    private boolean guiFlag = false;

    public CommandLineProcessor getCLP() {
        return new MyCLP();
    }

    private RankingEvaluation doExpt() throws IOException, NumberFormatException {
        Dataset data = DatasetLoader.loadFile(new File(this.dataFileName));
        System.out.println("loaded " + data.size() + " examples");
        RankingEvaluation eval = new RankingEvaluation();
        Dataset.Split split = data.split(this.splitter);
        ProgressCounter pc = new ProgressCounter("train/test", "fold", split.getNumPartitions());
        for (int k = 0; k < split.getNumPartitions(); ++k) {
            Dataset test = split.getTest(k);
            DatasetClassifierTeacher teacher = new DatasetClassifierTeacher(data);
            BinaryClassifier classifier = (BinaryClassifier)teacher.train(this.classifierLearner);
            this.doTest(classifier, test, eval);
            pc.progress();
        }
        pc.finished();
        return eval;
    }

    private void doTest(BinaryClassifier classifier, Dataset test, RankingEvaluation eval) {
        Map<String, List<Example>> bySubpopMap = BatchRankingLearner.splitIntoRankings(test);
        for (String subpop : bySubpopMap.keySet()) {
            List<Example> subdata = bySubpopMap.get(subpop);
            eval.extend(subpop, subdata, classifier);
        }
    }

    public static void main(String[] args) throws IOException, NumberFormatException {
        RankingExpt x = new RankingExpt();
        x.getCLP().processArguments(args);
        RankingEvaluation eval = x.doExpt();
        System.out.println(eval.toTable());
        if (x.guiFlag) {
            new ViewerFrame("result", eval.toGUI());
        }
        if (x.saveFile != null) {
            IOUtil.saveSomehow(eval, new File(x.saveFile), true);
        }
    }

    public class MyCLP
    extends BasicCommandLineProcessor {
        public void data(String s) {
            RankingExpt.this.dataFileName = s;
        }

        public void splitter(String s) {
            RankingExpt.this.splitter = Expt.toSplitter(s);
        }

        public void saveAs(String s) {
            RankingExpt.this.saveFile = s;
        }

        public void learner(String s) {
            RankingExpt.this.classifierLearner = (BatchRankingLearner)Expt.toLearner(s);
        }

        public void gui() {
            RankingExpt.this.guiFlag = true;
        }
    }
}

