/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.sequential;

import edu.cmu.minorthird.classify.sequential.HMM;
import edu.cmu.minorthird.classify.sequential.HMMAlgo;

public class Forward
extends HMMAlgo {
    double[][] f;
    private int L;

    public Forward(HMM hmm, String[] x) {
        super(hmm, x);
        int i;
        this.L = x.length;
        this.f = new double[this.L + 1][hmm.nstate];
        this.f[0][0] = 0.0;
        for (int k = 1; k < hmm.nstate; ++k) {
            this.f[0][k] = Double.NEGATIVE_INFINITY;
        }
        for (i = 1; i <= this.L; ++i) {
            this.f[i][0] = Double.NEGATIVE_INFINITY;
        }
        for (i = 1; i <= this.L; ++i) {
            for (int ell = 1; ell < hmm.nstate; ++ell) {
                double sum = Double.NEGATIVE_INFINITY;
                for (int k = 0; k < hmm.nstate; ++k) {
                    sum = Forward.logplus(sum, this.f[i - 1][k] + hmm.loga[k][ell]);
                }
                this.f[i][ell] = hmm.loge[ell][Integer.parseInt(x[i - 1])] + sum;
            }
        }
    }

    double logprob() {
        double sum = Double.NEGATIVE_INFINITY;
        for (int k = 0; k < this.hmm.nstate; ++k) {
            sum = Forward.logplus(sum, this.f[this.L][k]);
        }
        return sum;
    }
}

