/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.transform;

import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.GUI;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.MutableInstance;
import edu.cmu.minorthird.util.StringUtil;
import edu.cmu.minorthird.util.UnionIterator;
import edu.cmu.minorthird.util.gui.Viewer;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AugmentedInstance
implements Instance {
    private Instance instance;
    private Feature[] newFeatures;
    private double[] newValues;

    public AugmentedInstance(Instance instance, String[] newFeatureNames, double[] newVals) {
        if (instance == null) {
            throw new IllegalArgumentException("can't use null instance!");
        }
        this.instance = instance;
        this.newFeatures = new Feature[newFeatureNames.length];
        this.newValues = new double[newVals.length];
        for (int i = 0; i < newFeatureNames.length; ++i) {
            this.newFeatures[i] = new Feature(newFeatureNames[i]);
            this.newValues[i] = newVals[i];
        }
    }

    @Override
    public final Object getSource() {
        return this.instance.getSource();
    }

    @Override
    public final String getSubpopulationId() {
        return this.instance.getSubpopulationId();
    }

    @Override
    public final Iterator<Feature> binaryFeatureIterator() {
        return this.instance.binaryFeatureIterator();
    }

    @Override
    public final Iterator<Feature> numericFeatureIterator() {
        return new UnionIterator<Feature>(new MyIterator(), this.instance.numericFeatureIterator());
    }

    @Override
    public final Iterator<Feature> featureIterator() {
        return new UnionIterator<Feature>(new MyIterator(), this.instance.featureIterator());
    }

    @Override
    public final int numFeatures() {
        return this.newFeatures.length + this.instance.numFeatures();
    }

    @Override
    public final double getWeight(Feature f) {
        for (int i = 0; i < this.newFeatures.length; ++i) {
            if (!this.newFeatures[i].equals(f)) continue;
            return this.newValues[i];
        }
        return this.instance.getWeight(f);
    }

    public String toString() {
        return "[AugmentedInstance: " + this.instance + StringUtil.toString(this.newFeatures) + StringUtil.toString(this.newValues) + "]";
    }

    @Override
    public final Viewer toGUI() {
        return new GUI.InstanceViewer(this);
    }

    public static void main(String[] argv) {
        Feature f;
        MutableInstance inst = new MutableInstance();
        inst.addBinary(new Feature("william"));
        double[] vals = new double[argv.length];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = i + 1;
        }
        AugmentedInstance aug = new AugmentedInstance(inst, argv, vals);
        System.out.println(aug.toString());
        for (int i = 0; i < argv.length; ++i) {
            f = new Feature(argv[i]);
            System.out.println("weight of " + f + "=" + aug.getWeight(f));
        }
        Iterator<Feature> i = aug.featureIterator();
        while (i.hasNext()) {
            f = i.next();
            System.out.println("in aug: weight of " + f + "=" + aug.getWeight(f));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MyIterator
    implements Iterator<Feature> {
        private int i = 0;

        @Override
        public void remove() {
            throw new UnsupportedOperationException("can't remove");
        }

        @Override
        public boolean hasNext() {
            return this.i < AugmentedInstance.this.newFeatures.length;
        }

        @Override
        public Feature next() {
            return AugmentedInstance.this.newFeatures[this.i++];
        }
    }
}

