/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.transform;

public class ContingencyTable {
    private long a;
    private long b;
    private long c;
    private long d;

    public ContingencyTable(long a, long b, long c, long d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    public double getChiSquared() {
        double n = Math.log(this.total());
        double num = 2.0 * Math.log(Math.abs(this.a * this.d - this.b * this.c));
        double den = Math.log(this.a + this.b) + Math.log(this.a + this.c) + Math.log(this.c + this.d) + Math.log(this.b + this.d);
        double tmp = n + num - den;
        return Math.exp(tmp);
    }

    public double getPMutualInfo() {
        if (this.a == 0L) {
            return 0.0;
        }
        double n = Math.log(this.total());
        double denon = Math.log(this.a + this.b) + Math.log(this.a + this.c);
        double tmp2 = Math.log(this.a) + n - denon;
        double tmp = tmp2 / Math.log(2.0);
        return tmp;
    }

    public double getCompensatedPMutualInfo(int count) {
        double tmp2 = this.getPMutualInfo();
        return tmp2 * (double)count;
    }

    public String toString() {
        return "CTable: [ " + this.a + " , " + this.b + " , " + this.c + " , " + this.d + " ]";
    }

    public long total() {
        return this.a + this.b + this.c + this.d;
    }

    public static void main(String[] args) {
        System.out.println("Usage: java ContingencyTable a_value b_value c_value d_value");
        ContingencyTable ct = new ContingencyTable(Long.parseLong(args[0]), Long.parseLong(args[1]), Long.parseLong(args[2]), Long.parseLong(args[3]));
        System.out.println("Score chi = " + ct.getChiSquared());
        System.out.println("Score PMI = " + ct.getPMutualInfo());
        System.out.println("Score PMI comp = " + ct.getCompensatedPMutualInfo(3));
        System.out.println(ct.toString());
    }
}

