/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.transform;

import edu.cmu.minorthird.classify.AbstractInstance;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.GUI;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.WeightedSet;
import edu.cmu.minorthird.util.UnionIterator;
import edu.cmu.minorthird.util.gui.Viewer;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaskedInstance
extends AbstractInstance {
    private Instance instance;
    private Set<Feature> available;

    public MaskedInstance(Instance instance, Set<Feature> availableFeatures) {
        this.instance = instance;
        this.available = availableFeatures;
    }

    public MaskedInstance(Instance instance, SortedMap<Feature, ?> availableFeatures) {
        this(instance, availableFeatures.keySet());
    }

    @Override
    public final Object getSource() {
        return this.instance.getSource();
    }

    @Override
    public final String getSubpopulationId() {
        return this.instance.getSubpopulationId();
    }

    @Override
    public Viewer toGUI() {
        return new GUI.InstanceViewer(this);
    }

    @Override
    public double getWeight(Feature f) {
        if (this.available.contains(f)) {
            return this.instance.getWeight(f);
        }
        return 0.0;
    }

    @Override
    public Iterator<Feature> featureIterator() {
        Feature f;
        TreeSet<Feature> set = new TreeSet<Feature>();
        WeightedSet<Feature> wset = new WeightedSet<Feature>();
        Iterator<Feature> i = this.instance.binaryFeatureIterator();
        while (i.hasNext()) {
            f = i.next();
            if (!this.available.contains(f)) continue;
            set.add(f);
        }
        i = this.instance.numericFeatureIterator();
        while (i.hasNext()) {
            f = i.next();
            if (!this.available.contains(f)) continue;
            wset.add(f, this.instance.getWeight(f));
        }
        return new UnionIterator<Feature>(set.iterator(), wset.asSet().iterator());
    }

    @Override
    public final Iterator<Feature> numericFeatureIterator() {
        WeightedSet<Feature> wset = new WeightedSet<Feature>();
        Iterator<Feature> i = this.instance.numericFeatureIterator();
        while (i.hasNext()) {
            Feature f = i.next();
            if (!this.available.contains(f)) continue;
            wset.add(f, this.instance.getWeight(f));
        }
        return wset.asSet().iterator();
    }

    @Override
    public final Iterator<Feature> binaryFeatureIterator() {
        TreeSet<Feature> set = new TreeSet<Feature>();
        Iterator<Feature> i = this.instance.binaryFeatureIterator();
        while (i.hasNext()) {
            Feature f = i.next();
            if (!this.available.contains(f)) continue;
            set.add(f);
        }
        return set.iterator();
    }

    @Override
    public final int numFeatures() {
        System.err.println("Not implemented: numFeatures()");
        return -1;
    }

    @Override
    public String toString() {
        return "[masked " + this.instance + " av:" + this.available + "]";
    }
}

