/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.transform;

import edu.cmu.minorthird.classify.BasicDataset;
import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.DatasetClassifierTeacher;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Explanation;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.MutableInstance;
import edu.cmu.minorthird.classify.Splitter;
import edu.cmu.minorthird.classify.algorithms.linear.Hyperplane;
import edu.cmu.minorthird.classify.algorithms.linear.VotedPerceptron;
import edu.cmu.minorthird.classify.experiments.Evaluation;
import edu.cmu.minorthird.classify.experiments.Expt;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextBase;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.learn.SampleFE;
import edu.cmu.minorthird.util.LineProcessingUtil;
import java.io.File;
import java.io.Serializable;
import java.util.Iterator;

public class PositiveScoresTransformClassifier
implements Classifier,
Serializable {
    private static final long serialVersionUID = 20080201L;
    private double threshold;
    private Hyperplane hyp;
    private final double minFeatScore = 0.0;

    public PositiveScoresTransformClassifier(Classifier c, Dataset data) {
        this.hyp = (Hyperplane)c;
        this.threshold = this.calculatePositiveThreshold(data);
        System.out.println("Threshold = " + this.threshold);
    }

    public ClassLabel classification(Instance instance) {
        double s = this.score(instance, 0.0);
        double th = s - this.threshold;
        return s >= this.threshold ? ClassLabel.positiveLabel(th) : ClassLabel.negativeLabel(th);
    }

    public double calculatePositiveThreshold(Dataset data) {
        double posScore = 0.0;
        double negScore = 0.0;
        int numPos = 0;
        int numNeg = 0;
        Iterator<Example> i = data.iterator();
        while (i.hasNext()) {
            Example ex = i.next();
            Instance inst = ex.asInstance();
            if (ex.getLabel().isPositive()) {
                ++numPos;
                posScore += this.score(inst, 0.0);
                continue;
            }
            ++numNeg;
            negScore += this.score(inst, 0.0);
        }
        double negTh = negScore / (double)numNeg;
        double posTh = posScore / (double)numPos;
        double myTh = (negTh * (double)numPos + posTh * (double)numNeg) / (double)((numPos + numNeg) * 2);
        return myTh;
    }

    public double score(Instance instance) {
        return this.score(instance, 0.0);
    }

    public double score(Instance instance, double minFeatScore) {
        double score = 0.0;
        Iterator<Feature> j = instance.featureIterator();
        while (j.hasNext()) {
            Feature f = j.next();
            if (!(this.hyp.featureScore(f) > minFeatScore)) continue;
            score += instance.getWeight(f) * this.hyp.featureScore(f);
        }
        return score += this.hyp.featureScore(Hyperplane.BIAS_TERM);
    }

    public String explain(Instance instance) {
        return "classify using only features with positive hyperplane weights";
    }

    public Explanation getExplanation(Instance instance) {
        Explanation ex = new Explanation(this.explain(instance));
        return ex;
    }

    public static void main(String[] args) {
        if (args.length < 1 || args.length > 1) {
            System.out.println("Usage: PositiveScoresTransformClassifier classname");
            return;
        }
        String mytag = args[0];
        BasicDataset dataset = new BasicDataset();
        SampleFE.AnnotatedSpanFE fe = SampleFE.BAG_OF_LC_WORDS;
        try {
            TextLabels labels = LineProcessingUtil.readBsh(new File("C:/m3test/total/data/"), new File("C:/m3test/total/env/all" + mytag + ".env"));
            TextBase tb = labels.getTextBase();
            Iterator<Span> it = tb.documentSpanIterator();
            while (it.hasNext()) {
                Span docspan = it.next();
                MutableInstance ins = (MutableInstance)fe.extractInstance(labels, docspan);
                ClassLabel mylabel = new ClassLabel();
                mylabel = labels.hasType(docspan, mytag) ? ClassLabel.binaryLabel(1.0) : ClassLabel.binaryLabel(-1.0);
                dataset.add(new Example(ins, mylabel));
            }
            VotedPerceptron learner = new VotedPerceptron();
            Splitter<Example> split = Expt.toSplitter("k2");
            Evaluation v = new Evaluation(dataset.getSchema());
            Dataset.Split s = dataset.split(split);
            for (int k = 0; k < s.getNumPartitions(); ++k) {
                Dataset trainData = s.getTrain(k);
                Dataset testData = s.getTest(k);
                System.out.println("splitting with " + split + ", preparing to train on " + trainData.size() + " and test on " + testData.size());
                Classifier cc = new DatasetClassifierTeacher(trainData).train(learner);
                PositiveScoresTransformClassifier cc_transformed = new PositiveScoresTransformClassifier(cc, trainData);
                v.extend(cc_transformed, testData, k);
            }
            v.summarize();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Usage: PositiveScoresTransformClassifier classname");
            System.out.println("for instance, nameclass = Req, Dlv, Cmt, POS, etc");
        }
    }
}

