/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text;

import edu.cmu.minorthird.text.AnnotatorLoader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncapsulatingAnnotatorLoader
extends AnnotatorLoader
implements Serializable {
    private static final long serialVersionUID = 20080303L;
    private static Logger log = Logger.getLogger(EncapsulatingAnnotatorLoader.class);
    private Map<String, byte[]> fileNameToContentsMap = new HashMap<String, byte[]>();
    private ClassLoader myClassLoader;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        System.out.println("reading EncapsulatingAnnotatorLoader");
        in.defaultReadObject();
        for (String fileName : this.fileNameToContentsMap.keySet()) {
            if (!fileName.endsWith(".class")) continue;
            String className = fileName.substring(0, fileName.length() - ".class".length());
            try {
                System.out.println("loading class " + className);
                this.myClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
                log.warn("error recovering class: " + ex);
            }
        }
    }

    public EncapsulatingAnnotatorLoader(String path) {
        this(true, path);
    }

    public EncapsulatingAnnotatorLoader(boolean asFiles, String path) {
        String[] fileName = path.split(File.pathSeparator);
        for (int i = 0; i < fileName.length; ++i) {
            try {
                File file = new File(fileName[i]);
                FileInputStream s = asFiles ? new FileInputStream(file) : EncapsulatingAnnotatorLoader.class.getClassLoader().getResourceAsStream(fileName[i]);
                byte[] contents = new byte[((InputStream)s).available()];
                ((InputStream)s).read(contents);
                this.fileNameToContentsMap.put(file.getName(), contents);
                continue;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("can't open file '" + fileName[i] + "': " + e);
            }
        }
        this.myClassLoader = new EncapsulatingClassLoader();
    }

    @Override
    public InputStream findFileResource(String fileName) {
        log.info("looking for file resource " + fileName + " with encapsulated loader");
        byte[] contents = this.fileNameToContentsMap.get(fileName);
        if (contents != null) {
            log.info("encapsulated resource found containing " + contents.length + " bytes");
            return new ByteArrayInputStream(contents);
        }
        log.info("calling default class loader to find resource");
        return EncapsulatingAnnotatorLoader.class.getClassLoader().getResourceAsStream(fileName);
    }

    @Override
    public Class<?> findClassResource(String className) {
        try {
            Class<?> clazz = this.myClassLoader.loadClass(className);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EncapsulatingClassLoader
    extends ClassLoader
    implements Serializable {
        private static final long serialVersionUID = 20080303L;

        @Override
        public Class<?> findClass(String className) throws ClassNotFoundException {
            log.info("looking for class " + className + " with encapsulated loader");
            byte[] contents = (byte[])EncapsulatingAnnotatorLoader.this.fileNameToContentsMap.get(className + ".class");
            if (contents != null) {
                log.info("encapsulated class definition found containing " + contents.length + " bytes");
                try {
                    return this.defineClass(className, contents, 0, contents.length);
                }
                catch (NoClassDefFoundError e) {
                    Pattern msgPat = Pattern.compile("\\(wrong name\\: (.+?)\\)");
                    String message = e.getMessage();
                    Matcher m = msgPat.matcher(message);
                    if (m.find()) {
                        String realClassName = m.group(1).replaceAll("[\\/]+", ".");
                        Class<?> clazz = Class.forName(realClassName);
                        return clazz;
                    }
                    return null;
                }
            }
            log.info("calling default class loader to find class");
            return Class.forName(className);
        }
    }
}

