/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text;

import edu.cmu.minorthird.text.Document;
import edu.cmu.minorthird.text.Token;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextToken
implements Comparable<TextToken>,
Serializable,
Token {
    private static final long serialVersionUID = 20080305L;
    private final Document document;
    private final int lo;
    private final int len;
    private String value = null;

    public TextToken(Document document, int lo, int len) {
        this.document = document;
        this.lo = lo;
        this.len = len;
    }

    public String getDocumentId() {
        return this.document.getId();
    }

    public String getDocument() {
        return this.document.getText();
    }

    public int getLo() {
        return this.lo;
    }

    public int getLength() {
        return this.len;
    }

    public int getHi() {
        return this.lo + this.len;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            this.value = this.document.getText().substring(this.lo, this.lo + this.len);
        }
        return this.value;
    }

    @Override
    public int compareTo(TextToken other) {
        int cmp1 = this.getDocumentId().compareTo(other.getDocumentId());
        if (cmp1 != 0) {
            return cmp1;
        }
        int cmp2 = this.lo - other.lo;
        if (cmp2 != 0) {
            return cmp2;
        }
        return this.len - other.len;
    }

    public int hashCode() {
        return this.getDocumentId().hashCode() ^ this.lo ^ this.len;
    }

    public boolean equals(Object o) {
        if (o instanceof TextToken) {
            return this.compareTo((TextToken)o) == 0;
        }
        return false;
    }

    public String asString() {
        return this.getDocumentId() + "$Substr/" + this.lo + "," + this.len + ":'" + this.getValue() + "'";
    }

    public String toString() {
        return "[token '" + this.getValue() + "']";
    }
}

