/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.gui;

import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.gui.HiliteColors;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;

public class SpanDocument
extends DefaultStyledDocument {
    static final long serialVersionUID = 200803014L;
    private Span contextSpan;
    private int beginContextSpanInDocument;
    private int leftContextChars;
    private int rightContextChars;
    private Span leftBoundary;
    private Span rightBoundary;

    public SpanDocument() {
    }

    public SpanDocument(Span span) {
        this(span, 5);
    }

    public SpanDocument(Span span, int contextWidth) {
        int conLo = Math.max(span.documentSpanStartIndex() - contextWidth, 0);
        int conHi = Math.min(span.documentSpanStartIndex() + span.size() + contextWidth, span.documentSpan().size());
        this.contextSpan = span.documentSpan().subSpan(conLo, conHi - conLo);
        this.beginContextSpanInDocument = this.contextSpan.getTextToken(0).getLo();
        this.leftContextChars = span.getTextToken(0).getLo() - this.beginContextSpanInDocument;
        this.rightContextChars = this.contextSpan.getTextToken(this.contextSpan.size() - 1).getHi() - span.getTextToken(span.size() - 1).getHi();
        this.leftBoundary = this.contextSpan.getLeftBoundary();
        this.rightBoundary = this.contextSpan.getRightBoundary();
        try {
            super.insertString(0, this.contextSpan.asString(), SimpleAttributeSet.EMPTY);
            this.resetHighlights();
        }
        catch (BadLocationException e) {
            throw new IllegalStateException("inserting: " + e);
        }
    }

    public void insertString(int off, String s, AttributeSet attribs) throws BadLocationException {
    }

    public void remove(int off, int len) throws BadLocationException {
    }

    public void resetHighlights() {
        this.setCharacterAttributes(0, this.getLength(), SimpleAttributeSet.EMPTY, true);
        this.setCharacterAttributes(0, this.leftContextChars, HiliteColors.gray, true);
        this.setCharacterAttributes(this.getLength() - this.rightContextChars, this.rightContextChars, HiliteColors.gray, true);
    }

    public int toLogicalCharIndex(int charIndex) {
        return charIndex + this.beginContextSpanInDocument;
    }

    public void highlight(Span subspan, AttributeSet attributeSet) {
        if (!subspan.getDocumentId().equals(this.contextSpan.getDocumentId())) {
            return;
        }
        if (subspan.size() == 0) {
            return;
        }
        if (subspan.getLeftBoundary().compareTo(this.leftBoundary) < 0) {
            return;
        }
        if (subspan.getRightBoundary().compareTo(this.rightBoundary) > 0) {
            return;
        }
        int beginSubspanInDocument = subspan.getTextToken(0).getLo();
        int subspanLength = subspan.getTextToken(subspan.size() - 1).getHi() - beginSubspanInDocument;
        this.setCharacterAttributes(beginSubspanInDocument - this.beginContextSpanInDocument, subspanLength, attributeSet, true);
    }
}

