/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.gui;

import edu.cmu.minorthird.text.FancyLoader;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.SpanDifference;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.TextLabelsLoader;
import edu.cmu.minorthird.text.gui.HiliteColors;
import edu.cmu.minorthird.text.gui.MarkupControls;
import edu.cmu.minorthird.text.gui.SpanViewer;
import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.Controllable;
import edu.cmu.minorthird.util.gui.ControlledViewer;
import edu.cmu.minorthird.util.gui.ViewerControls;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.text.SimpleAttributeSet;

public class TextLabelsViewer
extends ComponentViewer
implements Controllable {
    static final long serialVersionUID = 200803014L;
    static SimpleAttributeSet[] colorByStatus = new SimpleAttributeSet[5];
    private TextLabels labels;
    private Span[] spans;
    private SpanViewer.TextViewer[] viewers = null;
    private Map<String, SpanViewer.TextViewer> viewerForId = new HashMap<String, SpanViewer.TextViewer>();
    private JList jlist;

    public TextLabelsViewer(TextLabels labels) {
        this.labels = labels;
        this.setContent(labels);
    }

    public TextLabels getLabels() {
        return this.labels;
    }

    public void applyControls(ViewerControls viewerControls) {
        MarkupControls controls = (MarkupControls)viewerControls;
        if (this.viewers != null) {
            for (int i = 0; i < this.viewers.length; ++i) {
                this.viewers[i].applyControls(controls);
            }
            SpanDifference sd = controls.getSpanDifference();
            if (sd != null) {
                SpanDifference.Looper i = sd.differenceIterator();
                while (i.hasNext()) {
                    Span s = i.next();
                    SpanViewer.TextViewer sv = this.viewerForId.get(s.getDocumentId());
                    if (sv == null) {
                        throw new IllegalStateException("can't highlight span " + s);
                    }
                    sv.highlight(s, colorByStatus[i.getStatus()]);
                }
            }
            this.jlist.repaint(10L);
        }
    }

    public JComponent componentFor(Object o) {
        final TextLabels labels = (TextLabels)o;
        int n = labels.getTextBase().size();
        this.spans = new Span[n];
        this.viewers = new SpanViewer.TextViewer[n];
        int j = 0;
        Iterator<Span> i = labels.getTextBase().documentSpanIterator();
        while (i.hasNext()) {
            this.spans[j] = i.next();
            this.viewers[j] = new SpanViewer.TextViewer(labels, this.spans[j]);
            this.viewers[j].setContent(this.spans[j]);
            this.viewers[j].setSuperView(this);
            this.viewerForId.put(this.spans[j].getDocumentId(), this.viewers[j]);
            ++j;
        }
        this.jlist = new JList<Span>(this.spans);
        this.jlist.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList el, Object v, int index, boolean sel, boolean focus) {
                Color borderColor = sel ? Color.blue : Color.black;
                TextLabelsViewer.this.viewers[index].setBorder(BorderFactory.createLineBorder(borderColor, 2));
                return TextLabelsViewer.this.viewers[index];
            }
        });
        this.monitorSelections(this.jlist);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JPanel subpanel = new JPanel();
        final JTextField fileField = new JTextField(20);
        subpanel.add(new JLabel("[ " + n + " documents " + labels.getTypes().size() + " types ]"));
        subpanel.add(new JButton(new AbstractAction("Save as... "){
            static final long serialVersionUID = 20080314L;

            public void actionPerformed(ActionEvent ev) {
                try {
                    new TextLabelsLoader().saveTypesAsOps(labels, new File(fileField.getText()));
                }
                catch (Exception ex) {
                    System.out.println("Error saving " + ex);
                }
            }
        }));
        subpanel.add(fileField);
        panel.add((Component)this.jlist, TextLabelsViewer.fillerGBC());
        GridBagConstraints gbc = TextLabelsViewer.fillerGBC();
        gbc.gridy = 1;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        panel.add((Component)subpanel, gbc);
        return new JScrollPane(panel);
    }

    public static void main(String[] argv) {
        try {
            TextLabels labels = FancyLoader.loadTextLabels(argv[0]);
            TextLabelsViewer sv = new TextLabelsViewer(labels);
            MarkupControls mc = new MarkupControls(labels);
            ControlledViewer v = new ControlledViewer(sv, mc);
            new ViewerFrame("TextLabelsViewer", v);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("usage: labelKey");
        }
    }

    static {
        TextLabelsViewer.colorByStatus[1] = HiliteColors.red;
        TextLabelsViewer.colorByStatus[2] = HiliteColors.blue;
        TextLabelsViewer.colorByStatus[3] = HiliteColors.green;
        TextLabelsViewer.colorByStatus[4] = HiliteColors.yellow;
    }
}

