/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.learn;

import edu.cmu.minorthird.text.MonotonicTextLabels;
import edu.cmu.minorthird.text.NestedTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextLabels;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationExample {
    public static String OUTSIDE = "outside";
    public static String INSIDE = "inside";
    public static String START = "start";
    public static String END = "end";
    public static String NOT_START_OR_END = "notStartOrEnd";
    private String inputSpanType;
    private String inputSpanProp;
    private Span document;
    private TextLabels labels;

    public AnnotationExample(Span document, TextLabels labels, String inputSpanType, String inputSpanProp) {
        this.document = document;
        this.labels = labels;
        this.inputSpanType = inputSpanType;
        this.inputSpanProp = inputSpanProp;
    }

    public Span getDocumentSpan() {
        return this.document;
    }

    public TextLabels getLabels() {
        return this.labels;
    }

    public String getInputType() {
        return this.inputSpanType;
    }

    public String getInputProp() {
        return this.inputSpanProp;
    }

    public String toString() {
        return "[AnnEx: document=" + this.document + "]";
    }

    public String getClassName(Span span) {
        String className = "NEG";
        if (this.getInputType() != null) {
            if (this.getLabels().hasType(span, this.getInputType())) {
                className = "POS";
            }
        } else if (this.getInputProp() != null) {
            String propValue = this.getLabels().getProperty(span, this.getInputProp());
            if (propValue != null) {
                className = propValue;
            }
        } else {
            throw new IllegalStateException("inputType && inputProp undefined for answeredQuery: " + this);
        }
        return className;
    }

    public TextLabels labelTokensInsideOutside(String prop) {
        NestedTextLabels result = new NestedTextLabels(this.labels);
        String documentId = this.document.getDocumentId();
        this.labelTokens(result, result.closureIterator(this.inputSpanType, documentId), prop, OUTSIDE);
        this.labelTokens(result, result.instanceIterator(this.inputSpanType, documentId), prop, INSIDE);
        return result;
    }

    public TextLabels labelTokensStartEnd(String prop) {
        NestedTextLabels result = new NestedTextLabels(this.labels);
        String documentId = this.document.getDocumentId();
        this.labelTokens(result, result.closureIterator(this.inputSpanType, documentId), prop, NOT_START_OR_END);
        Iterator<Span> i = result.instanceIterator(this.inputSpanType, documentId);
        while (i.hasNext()) {
            Span s = i.next();
            if (s.size() <= 0) continue;
            result.setProperty(s.getToken(0), prop, START);
            result.setProperty(s.getToken(s.size() - 1), prop, END);
        }
        return result;
    }

    private void labelTokens(MonotonicTextLabels labels, Iterator<Span> i, String prop, String value) {
        while (i.hasNext()) {
            Span s = i.next();
            for (int j = 0; j < s.size(); ++j) {
                labels.setProperty(s.getToken(j), prop, value);
            }
        }
    }
}

