/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.learn.experiments;

import edu.cmu.minorthird.text.AbstractTextBase;
import edu.cmu.minorthird.text.Document;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextBase;
import edu.cmu.minorthird.text.Tokenizer;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubTextBase
extends AbstractTextBase {
    private Set<Span> validDocumentSpans;
    private TextBase base;

    public SubTextBase(TextBase base, Iterator<Span> documentSpanIterator) throws UnknownDocumentException {
        super(base.getTokenizer());
        this.base = base;
        this.validDocumentSpans = new TreeSet<Span>();
        while (documentSpanIterator.hasNext()) {
            Span span = documentSpanIterator.next();
            if (base.documentSpan(span.getDocumentId()) == null) {
                throw new UnknownDocumentException("documentId not in textBase: " + span.getDocumentId());
            }
            this.validDocumentSpans.add(span);
        }
    }

    public boolean contains(Span span) {
        return this.validDocumentSpans.contains(span.documentSpan());
    }

    @Override
    public Tokenizer getTokenizer() {
        return this.base.getTokenizer();
    }

    @Override
    public Document getDocument(String documentId) {
        return this.base.getDocument(documentId);
    }

    @Override
    public int size() {
        return this.validDocumentSpans.size();
    }

    @Override
    public Iterator<Span> documentSpanIterator() {
        return this.validDocumentSpans.iterator();
    }

    @Override
    public Span documentSpan(String documentId) {
        Span span = this.base.documentSpan(documentId);
        return this.validDocumentSpans.contains(span) ? span : null;
    }

    public static class UnknownDocumentException
    extends Exception {
        static final long serialVersionUID = 20080314L;

        public UnknownDocumentException(String s) {
            super(s);
        }
    }
}

