/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.mixup;

import edu.cmu.minorthird.text.EncapsulatingAnnotatorLoader;
import edu.cmu.minorthird.text.FancyLoader;
import edu.cmu.minorthird.text.MonotonicTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextLabelsLoader;
import edu.cmu.minorthird.text.mixup.Mixup;
import edu.cmu.minorthird.text.mixup.MixupInterpreter;
import edu.cmu.minorthird.text.mixup.Statement;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MixupProgram
implements Serializable {
    private static final long serialVersionUID = 20080303L;
    private List<Statement> statementList = new ArrayList<Statement>();
    public static Set<String> legalKeywords = new HashSet<String>();

    public MixupProgram() {
    }

    public MixupProgram(String[] statements) throws Mixup.ParseException {
        String program = "";
        for (int i = 0; i < statements.length; ++i) {
            program = program + statements[i] + ";\n";
        }
        this.startProgram(program);
    }

    public MixupProgram(String program) throws Mixup.ParseException {
        String[] lines = program.split("\n");
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < lines.length; ++i) {
            int startComment = lines[i].indexOf("//");
            String line = startComment >= 0 ? lines[i].substring(0, startComment) : lines[i];
            buf.append(line);
            buf.append("\n");
        }
        program = buf.toString();
        this.startProgram(program);
    }

    public MixupProgram(File file) throws Mixup.ParseException, FileNotFoundException, IOException {
        String line;
        LineNumberReader in = file.exists() ? MixupProgram.mixupReader(file) : MixupProgram.mixupReader(file.getName());
        StringBuffer buf = new StringBuffer();
        while ((line = in.readLine()) != null) {
            int startComment = line.indexOf("//");
            if (startComment >= 0) {
                line = line.substring(0, startComment);
            }
            buf.append(line);
            buf.append("\n");
        }
        in.close();
        String program = buf.toString();
        this.startProgram(program);
    }

    private void startProgram(String program) throws Mixup.ParseException {
        program.trim();
        Mixup.MixupTokenizer tok = new Mixup.MixupTokenizer(program);
        String keyword = tok.advance(legalKeywords);
        while (keyword != null) {
            if (!keyword.startsWith("\n")) {
                this.addStatement(tok, keyword);
            }
            keyword = tok.advance(legalKeywords);
        }
    }

    public void addStatement(Mixup.MixupTokenizer tok, String keyword) throws Mixup.ParseException {
        this.statementList.add(new Statement(tok, keyword));
    }

    public void addStatement(String statement) throws Mixup.ParseException {
        Mixup.MixupTokenizer tok = new Mixup.MixupTokenizer(statement);
        String keyword = tok.advance(legalKeywords);
        this.addStatement(tok, keyword);
    }

    public Statement[] getStatements() {
        return this.statementList.toArray(new Statement[0]);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("");
        for (int i = 0; i < this.statementList.size(); ++i) {
            buf.append(this.statementList.get(i).toString() + ";\n");
        }
        return buf.toString();
    }

    private static LineNumberReader mixupReader(String fileName) throws IOException, FileNotFoundException {
        File file = new File(fileName);
        if (file.exists()) {
            return MixupProgram.mixupReader(file);
        }
        InputStream s = EncapsulatingAnnotatorLoader.EncapsulatingClassLoader.getSystemResourceAsStream(fileName);
        if (s == null) {
            s = ClassLoader.getSystemResourceAsStream(fileName);
        }
        if (s == null) {
            throw new IllegalArgumentException("No file named '" + fileName + "' found on classpath");
        }
        return new LineNumberReader(new BufferedReader(new InputStreamReader(s)));
    }

    private static LineNumberReader mixupReader(File file) throws IOException, FileNotFoundException {
        return new LineNumberReader(new BufferedReader(new FileReader(file)));
    }

    public static void main(String[] args) {
        try {
            MixupProgram program = new MixupProgram(new File(args[0]));
            System.out.println("program:\n" + program.toString());
            if (args.length > 1) {
                MonotonicTextLabels labels = (MonotonicTextLabels)FancyLoader.loadTextLabels(args[1]);
                MixupInterpreter interpreter = new MixupInterpreter(program);
                interpreter.eval(labels);
                if (args.length > 2) {
                    File outFile = new File(args[2]);
                    new TextLabelsLoader().saveTypesAsOps(labels, outFile);
                } else {
                    for (String type : labels.getTypes()) {
                        System.out.println("Type " + type + ":");
                        Iterator<Span> j = labels.instanceIterator(type);
                        while (j.hasNext()) {
                            Span span = j.next();
                            System.out.println("\t'" + span.asString() + "'");
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("usage: programFile textFile/directory [outfile]");
            e.printStackTrace();
        }
    }

    static {
        legalKeywords.add("defTokenProp");
        legalKeywords.add("defSpanProp");
        legalKeywords.add("defSpanType");
        legalKeywords.add("defDict");
        legalKeywords.add("declareSpanType");
        legalKeywords.add("provide");
        legalKeywords.add("require");
        legalKeywords.add("annotateWith");
        legalKeywords.add("defLevel");
        legalKeywords.add("onLevel");
        legalKeywords.add("offLevel");
        legalKeywords.add("importFromLevel");
        legalKeywords.add("//");
        legalKeywords.add("\n");
    }
}

