/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.ui;

import edu.cmu.minorthird.text.NestedTextLabels;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.TextLabelsLoader;
import edu.cmu.minorthird.text.mixup.Mixup;
import edu.cmu.minorthird.text.mixup.MixupInterpreter;
import edu.cmu.minorthird.text.mixup.MixupProgram;
import edu.cmu.minorthird.ui.CommandLineUtil;
import edu.cmu.minorthird.ui.UIMain;
import edu.cmu.minorthird.util.CommandLineProcessor;
import edu.cmu.minorthird.util.JointCommandLineProcessor;
import edu.cmu.minorthird.util.StringUtil;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class RunMixup
extends UIMain {
    private static Logger log = Logger.getLogger(RunMixup.class);
    private CommandLineUtil.SaveParams save = new CommandLineUtil.SaveParams();
    private CommandLineUtil.MixupParams mixup = new CommandLineUtil.MixupParams();
    private CommandLineUtil.AnnotatorOutputParams output = new CommandLineUtil.AnnotatorOutputParams();
    public TextLabels annotatedLabels = null;

    public CommandLineUtil.MixupParams getMixupParameters() {
        return this.mixup;
    }

    public void setMixupParameters(CommandLineUtil.MixupParams p) {
        this.mixup = p;
    }

    public CommandLineUtil.SaveParams getSaveParameters() {
        return this.save;
    }

    public void setSaveParameters(CommandLineUtil.SaveParams p) {
        this.save = p;
    }

    public CommandLineUtil.AnnotatorOutputParams getAnnotatorOutputParams() {
        return this.output;
    }

    public void setAnnotatorOutputParams(CommandLineUtil.AnnotatorOutputParams p) {
        this.output = p;
    }

    public String getRunMixupHelp() {
        return "<A HREF=\"http://minorthird.sourceforge.net/tutorials/Mixup%20Tutorial.htm\">Mixup Tutorial</A></html>";
    }

    public CommandLineProcessor getCLP() {
        return new JointCommandLineProcessor(new CommandLineProcessor[]{this.gui, this.base, this.save, this.mixup, this.output});
    }

    public void doMain() {
        if (this.mixup.fileName == null) {
            throw new IllegalArgumentException("need to specify -mixup");
        }
        MixupProgram program = null;
        try {
            program = new MixupProgram(new File(this.mixup.fileName));
        }
        catch (Mixup.ParseException ex) {
            System.out.println("can't parse file " + this.mixup.fileName + ": " + ex);
        }
        catch (IOException ex) {
            System.out.println("can't load file " + this.mixup.fileName + ": " + ex);
        }
        if (program == null) {
            log.error("Cannot runMixup unless a valid mixup program is specified.");
            return;
        }
        System.out.println("Will execute this program:\n" + program);
        MixupInterpreter interpreter = new MixupInterpreter(program);
        this.annotatedLabels = new NestedTextLabels(this.base.labels);
        interpreter.eval((NestedTextLabels)this.annotatedLabels);
        if (this.base.showResult) {
            new ViewerFrame("Result of " + this.mixup.fileName, new SmartVanillaViewer(this.annotatedLabels));
        }
        if (this.save.saveAs != null) {
            try {
                if ("minorthird".equals(this.output.format)) {
                    new TextLabelsLoader().saveTypesAsOps(this.annotatedLabels, this.save.saveAs);
                } else if ("strings".equals(this.output.format)) {
                    new TextLabelsLoader().saveTypesAsStrings(this.annotatedLabels, this.save.saveAs, true);
                } else if ("xml".equals(this.output.format)) {
                    new TextLabelsLoader().saveDocsWithEmbeddedTypes(this.annotatedLabels, this.save.saveAs);
                } else {
                    throw new IllegalArgumentException("illegal output format " + this.output.format + " allowed values are " + StringUtil.toString(this.output.getAllowedOutputFormatValues()));
                }
                System.out.println("saved to " + this.save.saveAs);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("can't save to " + this.save.saveAs + ": " + e);
            }
        }
    }

    public Object getMainResult() {
        return this.annotatedLabels;
    }

    public static void main(String[] args) {
        new RunMixup().callMain(args);
    }
}

