/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.ui;

import edu.cmu.minorthird.classify.experiments.CrossValSplitter;
import edu.cmu.minorthird.text.MonotonicTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.SpanDifference;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.TextLabelsLoader;
import edu.cmu.minorthird.text.learn.ExtractorAnnotator;
import edu.cmu.minorthird.text.learn.experiments.ExtractionEvaluation;
import edu.cmu.minorthird.text.learn.experiments.MonotonicSubTextLabels;
import edu.cmu.minorthird.text.learn.experiments.SubTextBase;
import edu.cmu.minorthird.ui.CommandLineUtil;
import edu.cmu.minorthird.ui.UIMain;
import edu.cmu.minorthird.util.CommandLineProcessor;
import edu.cmu.minorthird.util.IOUtil;
import edu.cmu.minorthird.util.JointCommandLineProcessor;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestExtractor
extends UIMain {
    private static Logger log = Logger.getLogger(TestExtractor.class);
    private ExtractorAnnotator ann = null;
    private ExtractionEvaluation extractionEval = null;
    boolean doSplit = true;
    private static int num_partitions = 5;
    private MonotonicTextLabels[] subLabels;
    private CommandLineUtil.SaveParams save = new CommandLineUtil.SaveParams();
    private CommandLineUtil.ExtractionSignalParams signal = new CommandLineUtil.ExtractionSignalParams(this.base);
    private CommandLineUtil.TestExtractorParams test = new CommandLineUtil.TestExtractorParams();

    public CommandLineUtil.SaveParams getSaveParameters() {
        return this.save;
    }

    public void setSaveParameters(CommandLineUtil.SaveParams p) {
        this.save = p;
    }

    public CommandLineUtil.ExtractionSignalParams getSignalParameters() {
        return this.signal;
    }

    public void setSignalParameters(CommandLineUtil.ExtractionSignalParams p) {
        this.signal = p;
    }

    public CommandLineUtil.TestExtractorParams getAdditionalParameters() {
        return this.test;
    }

    public void setAdditionalParameters(CommandLineUtil.TestExtractorParams p) {
        this.test = p;
    }

    public String getTestExtractorHelp() {
        return "<A HREF=\"http://minorthird.sourceforge.net/tutorials/TestExtractor%20Tutorial.htm\">TestExtractor Tutorial</A></html>";
    }

    @Override
    public CommandLineProcessor getCLP() {
        return new JointCommandLineProcessor(new CommandLineProcessor[]{this.gui, this.base, this.save, this.signal, this.test});
    }

    @Override
    public void doMain() {
        if (this.test.loadFrom == null) {
            throw new IllegalArgumentException("-loadFrom must be specified");
        }
        try {
            this.ann = (ExtractorAnnotator)((Object)IOUtil.loadSerialized(this.test.loadFrom));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("can't load annotator from " + this.test.loadFrom + ": " + ex);
        }
        if (this.test.showExtractor) {
            SmartVanillaViewer vx = new SmartVanillaViewer();
            vx.setContent(this.ann);
            new ViewerFrame("Annotator", vx);
        }
        TextLabels annFullLabels = this.ann.annotatedCopy(this.base.labels);
        this.extractionEval = new ExtractionEvaluation();
        log.info("Evaluating test partitions...");
        if (num_partitions < 2) {
            this.doSplit = false;
        }
        if (this.doSplit) {
            log.info("Creating test partition...");
            CrossValSplitter<Span> splitter = new CrossValSplitter<Span>(num_partitions);
            splitter.split(annFullLabels.getTextBase().documentSpanIterator());
            this.subLabels = new MonotonicTextLabels[splitter.getNumPartitions()];
            for (int i = 0; i < splitter.getNumPartitions(); ++i) {
                try {
                    SubTextBase testBase = new SubTextBase(annFullLabels.getTextBase(), splitter.getTest(i));
                    this.subLabels[i] = new MonotonicSubTextLabels(testBase, (MonotonicTextLabels)annFullLabels);
                }
                catch (SubTextBase.UnknownDocumentException ex) {
                    // empty catch block
                }
                this.measurePrecisionRecall("TestPartition" + (i + 1), this.subLabels[i], false);
            }
        }
        this.measurePrecisionRecall("OverallTest", annFullLabels, true);
        if (this.doSplit) {
            this.extractionEval.printAccStats();
        }
        if (this.base.showResult) {
            SmartVanillaViewer va = new SmartVanillaViewer();
            va.setContent(annFullLabels);
            new ViewerFrame("Annotated Textbase", va);
            new ViewerFrame("Performance Results", this.extractionEval.toGUI());
        }
        if (this.save.saveAs != null) {
            try {
                new TextLabelsLoader().saveTypesAsOps(annFullLabels, this.save.saveAs);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("can't save to " + this.save.saveAs + ": " + e);
            }
        }
    }

    private void measurePrecisionRecall(String tag, TextLabels labels, boolean isOverallMeasure) {
        if (this.signal.spanType != null) {
            SpanDifference sd = new SpanDifference(labels.instanceIterator(this.ann.getSpanType()), labels.instanceIterator(this.signal.spanType), labels.closureIterator(this.signal.spanType));
            System.out.println("\n" + tag + ":");
            System.out.println(sd.toSummary());
            this.extractionEval.extend(tag, sd, isOverallMeasure);
        } else {
            HashSet<String> propValues = new HashSet<String>();
            Iterator<Span> i = labels.getSpansWithProperty(this.signal.spanProp);
            while (i.hasNext()) {
                Span s = i.next();
                propValues.add(labels.getProperty(s, this.signal.spanProp));
            }
            SpanDifference[] sd = new SpanDifference[propValues.size()];
            int k = 0;
            for (String val : propValues) {
                sd[k] = new SpanDifference(this.propertyIterator(labels, this.ann.getSpanType(), val), this.propertyIterator(labels, this.signal.spanProp, val), labels.getTextBase().documentSpanIterator());
                String tag1 = tag + " for " + this.signal.spanProp + ":" + val;
                System.out.println(tag1 + ":");
                System.out.println(sd[k].toSummary());
                this.extractionEval.extend(tag1, sd[k], false);
                ++k;
            }
        }
    }

    private Iterator<Span> propertyIterator(TextLabels labels, String prop, String value) {
        ArrayList<Span> accum = new ArrayList<Span>();
        Iterator<Span> i = labels.getSpansWithProperty(prop);
        while (i.hasNext()) {
            Span s = i.next();
            if (value != null && !value.equals(labels.getProperty(s, prop))) continue;
            accum.add(s);
        }
        return accum.iterator();
    }

    @Override
    public Object getMainResult() {
        return this.extractionEval;
    }

    public static void main(String[] args) {
        new TestExtractor().callMain(args);
    }
}

