/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.util.gui;

import edu.cmu.minorthird.util.gui.SplitViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZoomedViewer
extends SplitViewer {
    static final long serialVersionUID = 20080517L;
    private static Logger log = Logger.getLogger(ZoomedViewer.class);
    static final boolean DEBUG = log.isDebugEnabled();
    private Viewer zoomedOut;
    private Viewer zoomedIn;

    public ZoomedViewer() {
    }

    public ZoomedViewer(Viewer zoomedOut, Viewer zoomedIn) {
        super(zoomedOut, zoomedIn);
        this.zoomedOut = this.viewer1;
        this.zoomedIn = this.viewer2;
    }

    @Override
    public void setSubViews(Viewer zoomedOut, Viewer zoomedIn) {
        super.setSubViews(zoomedOut, zoomedIn);
        this.zoomedOut = this.viewer1;
        this.zoomedIn = this.viewer2;
    }

    @Override
    public void receiveContent(Object content) {
        log.info("recieving content: " + content);
        this.zoomedOut.setContent(content);
        this.zoomedIn.clearContent();
    }

    @Override
    public Object getVisibleContent() {
        return this.zoomedOut.getVisibleContent();
    }

    @Override
    public boolean canReceive(Object content) {
        return this.zoomedOut != null && this.zoomedOut.canReceive(content);
    }

    @Override
    protected void handle(int signal, Object argument, List<Viewer> senders) {
        this.zoomedIn.setContent(argument);
        this.revalidate();
    }

    @Override
    protected boolean canHandle(int signal, Object argument, List<Viewer> senders) {
        if (DEBUG && signal == 3) {
            log.debug("selection in zoomed viewer, content=" + argument);
            log.debug("zoomedIn=" + this.zoomedIn);
            log.debug("zoomedIn.canReceive is " + (this.zoomedIn != null && this.zoomedIn.canReceive(argument)));
        }
        return signal == 3 && senders.contains(this.zoomedOut) && this.zoomedIn.canReceive(argument);
    }
}

