/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref;

import hep.aida.IAxis;
import hep.aida.IHistogram1D;
import hep.aida.ref.AbstractHistogram1D;
import hep.aida.ref.FixedAxis;
import hep.aida.ref.VariableAxis;

public class Histogram1D
extends AbstractHistogram1D
implements IHistogram1D {
    private double[] errors;
    private double[] heights;
    private int[] entries;
    private int nEntry;
    private double sumWeight;
    private double sumWeightSquared;
    private double mean;
    private double rms;

    public Histogram1D(String string2, double[] dArray) {
        this(string2, new VariableAxis(dArray));
    }

    public Histogram1D(String string2, int n, double d, double d2) {
        this(string2, new FixedAxis(n, d, d2));
    }

    public Histogram1D(String string2, IAxis iAxis) {
        super(string2);
        this.xAxis = iAxis;
        int n = iAxis.bins();
        this.entries = new int[n + 2];
        this.heights = new double[n + 2];
        this.errors = new double[n + 2];
    }

    public int allEntries() {
        return this.nEntry;
    }

    public int binEntries(int n) {
        return this.entries[this.map(n)];
    }

    public double binError(int n) {
        return Math.sqrt(this.errors[this.map(n)]);
    }

    public double binHeight(int n) {
        return this.heights[this.map(n)];
    }

    public double equivalentBinEntries() {
        return this.sumWeight * this.sumWeight / this.sumWeightSquared;
    }

    public void fill(double d) {
        int n;
        int n2 = n = this.map(this.xAxis.coordToIndex(d));
        this.entries[n2] = this.entries[n2] + 1;
        int n3 = n;
        this.heights[n3] = this.heights[n3] + 1.0;
        int n4 = n;
        this.errors[n4] = this.errors[n4] + 1.0;
        ++this.nEntry;
        this.sumWeight += 1.0;
        this.sumWeightSquared += 1.0;
        this.mean += d;
        this.rms += d * d;
    }

    public void fill(double d, double d2) {
        int n;
        int n2 = n = this.map(this.xAxis.coordToIndex(d));
        this.entries[n2] = this.entries[n2] + 1;
        int n3 = n;
        this.heights[n3] = this.heights[n3] + d2;
        int n4 = n;
        this.errors[n4] = this.errors[n4] + d2 * d2;
        ++this.nEntry;
        this.sumWeight += d2;
        this.sumWeightSquared += d2 * d2;
        this.mean += d * d2;
        this.rms += d * d2 * d2;
    }

    public double mean() {
        return this.mean / this.sumWeight;
    }

    public void reset() {
        int n = 0;
        while (n < this.entries.length) {
            this.entries[n] = 0;
            this.heights[n] = 0.0;
            this.errors[n] = 0.0;
            ++n;
        }
        this.nEntry = 0;
        this.sumWeight = 0.0;
        this.sumWeightSquared = 0.0;
        this.mean = 0.0;
        this.rms = 0.0;
    }

    public double rms() {
        return Math.sqrt(this.rms / this.sumWeight - this.mean * this.mean / this.sumWeight / this.sumWeight);
    }

    void setContents(int[] nArray, double[] dArray, double[] dArray2) {
        this.entries = nArray;
        this.heights = dArray;
        this.errors = dArray2;
        int n = 0;
        while (n < nArray.length) {
            this.nEntry += nArray[n];
            this.sumWeight += dArray[n];
            ++n;
        }
        this.sumWeightSquared = Double.NaN;
        this.mean = Double.NaN;
        this.rms = Double.NaN;
    }
}

