/*
 * Decompiled with CFR 0.152.
 */
package iitb.CRF;

import iitb.CRF.CollinsTrainer;
import iitb.CRF.CrfParams;
import iitb.CRF.DataIter;
import iitb.CRF.DataSequence;
import iitb.CRF.EdgeGenerator;
import iitb.CRF.Evaluator;
import iitb.CRF.FeatureGenerator;
import iitb.CRF.HistoryManager;
import iitb.CRF.Trainer;
import iitb.CRF.Util;
import iitb.CRF.Viterbi;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Properties;

public class CRF
implements Serializable {
    private static final long serialVersionUID = 14L;
    double[] lambda;
    protected int numY;
    transient Trainer trainer;
    FeatureGenerator featureGenerator;
    EdgeGenerator edgeGen;
    HistoryManager histMgr;
    public CrfParams params;
    transient Viterbi viterbi;

    public CRF(int numLabels, FeatureGenerator fgen, String arg) {
        this(numLabels, fgen, CrfParams.stringToOptions(arg));
    }

    public CRF(int numLabels, FeatureGenerator fgen, Properties configOptions) {
        this(numLabels, 1, fgen, configOptions);
    }

    public CRF(int numLabels, int histsize, FeatureGenerator fgen, Properties configOptions) {
        this.histMgr = new HistoryManager(histsize, numLabels);
        this.featureGenerator = this.histMgr.getFeatureGen(fgen);
        this.numY = this.histMgr.numY;
        this.params = new CrfParams(configOptions);
        this.edgeGen = this.histMgr.getEdgeGenerator();
        this.viterbi = this.getViterbi(1);
    }

    public void reinitOptions(Properties configOptions) {
        this.params = new CrfParams(configOptions);
        this.viterbi = null;
    }

    public void write(String fileName) throws IOException {
        PrintWriter out = new PrintWriter(new FileOutputStream(fileName));
        out.println(this.lambda.length);
        for (int i = 0; i < this.lambda.length; ++i) {
            out.println(this.lambda[i]);
        }
        out.close();
    }

    public void read(String fileName) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        int numF = Integer.parseInt(in.readLine());
        this.lambda = new double[numF];
        int pos = 0;
        while ((line = in.readLine()) != null) {
            this.lambda[pos++] = Double.parseDouble(line);
        }
    }

    protected Trainer getTrainer() {
        if (this.params.trainerType.startsWith("Collins")) {
            return new CollinsTrainer(this.params);
        }
        return new Trainer(this.params);
    }

    protected Viterbi getViterbi(int beamsize) {
        return new Viterbi(this, beamsize);
    }

    public double[] train(DataIter trainData) {
        return this.train(trainData, null);
    }

    public double[] train(DataIter trainData, Evaluator evaluator) {
        this.lambda = new double[this.featureGenerator.numFeatures()];
        this.trainer = this.getTrainer();
        this.trainer.train(this, this.histMgr.mapTrainData(trainData), this.lambda, evaluator);
        return this.lambda;
    }

    public double[] learntWeights() {
        return this.lambda;
    }

    public void apply(DataSequence dataSeq) {
        if (this.viterbi == null) {
            this.viterbi = this.getViterbi(1);
        }
        if (this.params.debugLvl > 1) {
            Util.printDbg("CRF: Applying on " + dataSeq);
        }
        this.viterbi.bestLabelSequence(dataSeq, this.lambda);
        if (this.histMgr != null) {
            for (int i = dataSeq.length() - 1; i >= 0; --i) {
                this.histMgr.set_y(dataSeq, i, dataSeq.y(i));
            }
        }
    }

    public double score(DataSequence dataSeq) {
        if (this.viterbi == null) {
            this.viterbi = this.getViterbi(1);
        }
        return this.viterbi.viterbiSearch(dataSeq, this.lambda, true);
    }
}

