/*
 * Decompiled with CFR 0.152.
 */
package iitb.CRF;

import gnu.trove.TIntFloatHashMap;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntProcedure;
import iitb.CRF.CandSegDataSequence;
import iitb.CRF.CandidateSegments;
import iitb.CRF.Constraint;
import iitb.CRF.ConstraintDisallowedPairs;
import iitb.CRF.DataSequence;
import iitb.CRF.Feature;
import iitb.CRF.RobustMath;
import iitb.CRF.SegmentCRF;
import iitb.CRF.SegmentDataSequence;
import iitb.CRF.SegmentTrainer;
import iitb.CRF.Segmentation;
import iitb.CRF.Soln;
import iitb.CRF.SparseViterbi;
import iitb.CRF.Viterbi;
import java.util.Iterator;
import java.util.TreeSet;

public class SegmentViterbi
extends SparseViterbi {
    protected SegmentCRF segmentModel;
    LabelConstraints labelConstraints = null;
    int prevSegEnd = -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected SegmentViterbi(SegmentCRF nestedModel, int bs) {
        super(nestedModel, bs);
        this.segmentModel = nestedModel;
    }

    protected void computeLogMi(DataSequence dataSeq, int i, int ell, double[] lambda) {
        SegmentTrainer.computeLogMi((CandSegDataSequence)dataSeq, i - ell, i, this.segmentModel.featureGenNested, lambda, this.Mi, this.Ri);
    }

    protected SparseViterbi.Iter getIter() {
        return new SegmentIter();
    }

    protected double getCorrectScore(DataSequence dataSeq, int i, int ell) {
        double val;
        SegmentDataSequence data = (SegmentDataSequence)dataSeq;
        if (data.getSegmentEnd(i - ell + 1) != i) {
            return 0.0;
        }
        if (i - ell >= 0 && this.prevSegEnd != i - ell) {
            return RobustMath.LOG0;
        }
        this.prevSegEnd = i;
        if (this.labelConstraints != null && this.labelConstraints.conflicting(data.y(i))) {
            int segStart = 0;
            while (segStart < i - ell + 1) {
                int segEnd = data.getSegmentEnd(segStart);
                if (this.labelConstraints.disallowedPairs.conflictingPair(data.y(i), data.y(segStart), segEnd == i - ell)) {
                    return RobustMath.LOG0;
                }
                segStart = data.getSegmentEnd(segStart) + 1;
            }
        }
        if (this.model.params.debugLvl > 0) {
            this.segmentModel.featureGenNested.startScanFeaturesAt(dataSeq, i - ell, i);
            while (this.segmentModel.featureGenNested.hasNext()) {
                Feature f = this.segmentModel.featureGenNested.next();
                if (!((CandSegDataSequence)data).holdsInTrainingData(f, i - ell, i)) continue;
                System.out.println("Feature " + (i - ell) + " " + i + " " + this.segmentModel.featureGenerator.featureName(f.index()) + " " + this.segmentModel.lambda[f.index()] + " " + f.value());
            }
        }
        if (Double.isInfinite(val = this.Ri.getQuick(dataSeq.y(i)) + (i - ell >= 0 ? this.Mi.get(dataSeq.y(i - ell), dataSeq.y(i)) : 0.0))) {
            System.out.println("Infinite score");
        }
        return val;
    }

    protected void setSegment(DataSequence dataSeq, int prevPos, int pos, int label) {
        ((CandSegDataSequence)dataSeq).setSegment(prevPos + 1, pos, label);
    }

    public void singleSegmentClassScores(CandSegDataSequence dataSeq, double[] lambda, TIntFloatHashMap scores) {
        this.viterbiSearch(dataSeq, lambda, false);
        scores.clear();
        int i = dataSeq.length() - 1;
        if (i >= 0) {
            Soln soln;
            int y;
            double norm = RobustMath.LOG0;
            for (y = 0; y < this.context[i].size(); ++y) {
                if (!this.context[i].entryNotNull(y)) continue;
                soln = ((Viterbi.Entry)this.context[i].getQuick(y)).get(0);
                if (!$assertionsDisabled && soln.prevSoln != null) {
                    throw new AssertionError();
                }
                norm = RobustMath.logSumExp(norm, soln.score);
            }
            for (y = 0; y < this.context[i].size(); ++y) {
                if (!this.context[i].entryNotNull(y)) continue;
                soln = ((Viterbi.Entry)this.context[i].getQuick(y)).get(0);
                scores.put(soln.label, (float)Math.exp((double)soln.score - norm));
            }
        }
    }

    protected SparseViterbi.Context newContext(int numY, int beamsize, int pos) {
        if (this.labelConstraints == null) {
            return new SparseViterbi.Context(this, numY, beamsize, pos);
        }
        return new ContextForLabelConstraints(numY, beamsize == 1 ? 20 : beamsize, pos);
    }

    public double viterbiSearch(DataSequence dataSeq, double[] lambda, boolean calcCorrectScore) {
        this.labelConstraints = LabelConstraints.checkConstraints((CandSegDataSequence)dataSeq, this.labelConstraints);
        return super.viterbiSearch(dataSeq, lambda, calcCorrectScore);
    }

    public Segmentation[] segmentSequences(CandSegDataSequence dataSeq, double[] lambda, int numLabelSeqs) {
        this.viterbiSearch(dataSeq, lambda, false);
        int numSols = Math.min(this.finalSoln.numSolns(), numLabelSeqs);
        Segmentation[] segments = new Segmentation[numSols];
        for (int k = numSols - 1; k >= 0; --k) {
            Soln ybest = this.finalSoln.get(k);
            ybest = ybest.prevSoln;
            segments[k] = new SegmentationImpl();
            while (ybest != null) {
                segments[k].setSegment(ybest.prevPos() + 1, ybest.pos, ybest.label);
                ybest = ybest.prevSoln;
            }
            ((SegmentationImpl)segments[k]).doneAdd();
        }
        return segments;
    }

    static {
        $assertionsDisabled = !SegmentViterbi.class.desiredAssertionStatus();
    }

    class SegmentationImpl
    implements Segmentation {
        TreeSet segments = new TreeSet();
        Segment[] segmentArr = null;
        Segment dummySegment = new Segment(0, 0, 0);

        SegmentationImpl() {
        }

        public int numSegments() {
            return this.segments.size();
        }

        public int segmentLabel(int segmentNum) {
            return this.segmentArr[segmentNum].label;
        }

        public int segmentStart(int segmentNum) {
            return this.segmentArr[segmentNum].start;
        }

        public int segmentEnd(int segmentNum) {
            return this.segmentArr[segmentNum].end;
        }

        public int getSegmentId(int offset) {
            this.dummySegment.end = offset;
            return this.segments.tailSet(this.dummySegment).first().id;
        }

        public void setSegment(int segmentStart, int segmentEnd, int label) {
            Segment segment = new Segment(segmentStart, segmentEnd, label);
            boolean b = this.segments.add(segment);
        }

        public void doneAdd() {
            this.segmentArr = new Segment[this.segments.size()];
            int p = 0;
            Iterator iter = this.segments.iterator();
            while (iter.hasNext()) {
                this.segmentArr[p++] = (Segment)iter.next();
            }
            for (int i = this.segmentArr.length - 1; i >= 0; --i) {
                this.segmentArr[i].id = i;
            }
        }

        class Segment
        implements Comparable {
            int start;
            int end;
            int label;
            int id;

            Segment(int start, int end, int label) {
                this.start = start;
                this.end = end;
                this.label = label;
            }

            public int compareTo(Object arg0) {
                return this.end - ((Segment)arg0).end;
            }
        }
    }

    class SegmentIter
    extends SparseViterbi.Iter {
        int nc;
        CandidateSegments candidateSegs;

        SegmentIter() {
            super(SegmentViterbi.this);
        }

        protected void start(int i, DataSequence dataSeq) {
            this.candidateSegs = (CandidateSegments)((Object)dataSeq);
            this.nc = this.candidateSegs.numCandSegmentsEndingAt(i);
        }

        protected int nextEll(int i) {
            --this.nc;
            if (this.nc >= 0) {
                return i - this.candidateSegs.candSegmentStart(i, this.nc) + 1;
            }
            return -1;
        }
    }

    class ContextForLabelConstraints
    extends SparseViterbi.Context {
        private static final long serialVersionUID = 1L;

        ContextForLabelConstraints(int numY, int beamsize, int pos) {
            super(SegmentViterbi.this, numY, beamsize, pos);
        }

        public void add(int y, Viterbi.Entry prevSoln, float thisScore) {
            if (SegmentViterbi.this.labelConstraints == null) {
                super.add(y, prevSoln, thisScore);
            } else {
                if (this.getQuick(y) == null) {
                    this.setQuick(y, new EntryForLabelConstraints(this.pos == 0 ? 1 : this.beamsize, y, this.pos));
                }
                super.add(y, prevSoln, thisScore);
            }
        }
    }

    class EntryForLabelConstraints
    extends Viterbi.Entry {
        EntryForLabelConstraints(int beamsize, int id, int pos) {
            super(SegmentViterbi.this);
            this.solns = new Soln[beamsize];
            for (int i = 0; i < this.solns.length; ++i) {
                this.solns[i] = new SolnWithLabelsOnPath(id, pos);
            }
        }

        protected int findInsert(int insertPos, float score, Soln prev) {
            while (insertPos < this.size()) {
                if (score >= this.get((int)insertPos).score) {
                    if (prev == null || SegmentViterbi.this.labelConstraints.valid(((SolnWithLabelsOnPath)prev).labelsOnPath, this.get((int)insertPos).label, prev.label)) {
                        this.insert(insertPos, score, prev);
                        ++insertPos;
                        break;
                    }
                    if (prev == null) break;
                    break;
                }
                ++insertPos;
            }
            return insertPos;
        }
    }

    class SolnWithLabelsOnPath
    extends Soln {
        private static final long serialVersionUID = 1L;
        TIntHashSet labelsOnPath;
        static final /* synthetic */ boolean $assertionsDisabled;

        void clear() {
            super.clear();
            this.labelsOnPath.clear();
        }

        protected void copy(Soln soln) {
            super.copy(soln);
            this.labelsOnPath.clear();
            this.labelsOnPath.addAll(((SolnWithLabelsOnPath)soln).labelsOnPath.toArray());
        }

        SolnWithLabelsOnPath(int id, int p) {
            super(id, p);
            this.labelsOnPath = new TIntHashSet();
        }

        protected void setPrevSoln(Soln prevSoln, float score) {
            super.setPrevSoln(prevSoln, score);
            if (prevSoln != null && SegmentViterbi.this.labelConstraints != null) {
                this.labelsOnPath.clear();
                this.labelsOnPath.addAll(((SolnWithLabelsOnPath)prevSoln).labelsOnPath.toArray());
                if (!$assertionsDisabled && !SegmentViterbi.this.labelConstraints.valid(this.labelsOnPath, this.label, prevSoln.label)) {
                    throw new AssertionError();
                }
                if (SegmentViterbi.this.labelConstraints.conflicting(prevSoln.label)) {
                    this.labelsOnPath.add(prevSoln.label);
                }
            }
        }

        static {
            $assertionsDisabled = !(class$iitb$CRF$SegmentViterbi == null ? (class$iitb$CRF$SegmentViterbi = SegmentViterbi.class$("iitb.CRF.SegmentViterbi")) : class$iitb$CRF$SegmentViterbi).desiredAssertionStatus();
        }
    }

    static class LabelConstraints {
        private static final long serialVersionUID = 1L;
        ConstraintDisallowedPairs disallowedPairs;
        Intersects intersectTest = new Intersects();

        public LabelConstraints(ConstraintDisallowedPairs pairs) {
            this.disallowedPairs = pairs;
        }

        private boolean valid(TIntHashSet set, int label, int prevLabel) {
            if (!this.conflicting(label)) {
                return true;
            }
            if (this.disallowedPairs.conflictingPair(label, prevLabel, true)) {
                return false;
            }
            this.intersectTest.label = label;
            this.intersectTest.prevLabel = prevLabel;
            return set.forEach(this.intersectTest);
        }

        public static LabelConstraints checkConstraints(CandSegDataSequence dataSeq, LabelConstraints labelCons) {
            Iterator constraints = dataSeq.constraints(-1, dataSeq.length());
            if (constraints != null) {
                while (constraints.hasNext()) {
                    Constraint constraint = (Constraint)constraints.next();
                    if (constraint.type() != 2) continue;
                    if (labelCons != null) {
                        labelCons.disallowedPairs = (ConstraintDisallowedPairs)constraint;
                        return labelCons;
                    }
                    return new LabelConstraints((ConstraintDisallowedPairs)constraint);
                }
            }
            return null;
        }

        public boolean conflicting(int label) {
            return this.disallowedPairs.conflicting(label);
        }

        class Intersects
        implements TIntProcedure {
            int label;
            int prevLabel;

            Intersects() {
            }

            public boolean execute(int arg0) {
                return !LabelConstraints.this.disallowedPairs.conflictingPair(this.label, arg0, arg0 == this.prevLabel);
            }
        }
    }
}

