/*
 * Decompiled with CFR 0.152.
 */
package libsvm;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import libsvm.Kernel;
import libsvm.ONE_CLASS_Q;
import libsvm.SVC_Q;
import libsvm.SVR_Q;
import libsvm.Solver;
import libsvm.Solver_NU;
import libsvm.svm_model;
import libsvm.svm_node;
import libsvm.svm_parameter;
import libsvm.svm_problem;

public class svm {
    static final String[] svm_type_table = new String[]{"c_svc", "nu_svc", "one_class", "epsilon_svr", "nu_svr"};
    static final String[] kernel_type_table = new String[]{"linear", "polynomial", "rbf", "sigmoid", "precomputed"};

    private static void solve_c_svc(svm_problem svm_problem2, svm_parameter svm_parameter2, double[] dArray, Solver.SolutionInfo solutionInfo, double d, double d2) {
        int n;
        int n2 = svm_problem2.l;
        double[] dArray2 = new double[n2];
        byte[] byArray = new byte[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = 0.0;
            dArray2[n] = -1.0;
            byArray[n] = svm_problem2.y[n] > 0.0 ? 1 : -1;
        }
        Solver solver = new Solver();
        solver.Solve(n2, new SVC_Q(svm_problem2, svm_parameter2, byArray), dArray2, byArray, dArray, d, d2, svm_parameter2.eps, solutionInfo, svm_parameter2.shrinking);
        double d3 = 0.0;
        for (n = 0; n < n2; ++n) {
            d3 += dArray[n];
        }
        if (d == d2) {
            System.out.print("nu = " + d3 / (d * (double)svm_problem2.l) + "\n");
        }
        for (n = 0; n < n2; ++n) {
            int n3 = n;
            dArray[n3] = dArray[n3] * (double)byArray[n];
        }
    }

    private static void solve_nu_svc(svm_problem svm_problem2, svm_parameter svm_parameter2, double[] dArray, Solver.SolutionInfo solutionInfo) {
        int n;
        int n2 = svm_problem2.l;
        double d = svm_parameter2.nu;
        byte[] byArray = new byte[n2];
        for (n = 0; n < n2; ++n) {
            byArray[n] = svm_problem2.y[n] > 0.0 ? 1 : -1;
        }
        double d2 = d * (double)n2 / 2.0;
        double d3 = d * (double)n2 / 2.0;
        for (n = 0; n < n2; ++n) {
            if (byArray[n] == 1) {
                dArray[n] = Math.min(1.0, d2);
                d2 -= dArray[n];
                continue;
            }
            dArray[n] = Math.min(1.0, d3);
            d3 -= dArray[n];
        }
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray2[n] = 0.0;
        }
        Solver_NU solver_NU = new Solver_NU();
        solver_NU.Solve(n2, new SVC_Q(svm_problem2, svm_parameter2, byArray), dArray2, byArray, dArray, 1.0, 1.0, svm_parameter2.eps, solutionInfo, svm_parameter2.shrinking);
        double d4 = solutionInfo.r;
        System.out.print("C = " + 1.0 / d4 + "\n");
        for (n = 0; n < n2; ++n) {
            int n3 = n;
            dArray[n3] = dArray[n3] * ((double)byArray[n] / d4);
        }
        solutionInfo.rho /= d4;
        solutionInfo.obj /= d4 * d4;
        solutionInfo.upper_bound_p = 1.0 / d4;
        solutionInfo.upper_bound_n = 1.0 / d4;
    }

    private static void solve_one_class(svm_problem svm_problem2, svm_parameter svm_parameter2, double[] dArray, Solver.SolutionInfo solutionInfo) {
        int n;
        int n2 = svm_problem2.l;
        double[] dArray2 = new double[n2];
        byte[] byArray = new byte[n2];
        int n3 = (int)(svm_parameter2.nu * (double)svm_problem2.l);
        for (n = 0; n < n3; ++n) {
            dArray[n] = 1.0;
        }
        if (n3 < svm_problem2.l) {
            dArray[n3] = svm_parameter2.nu * (double)svm_problem2.l - (double)n3;
        }
        for (n = n3 + 1; n < n2; ++n) {
            dArray[n] = 0.0;
        }
        for (n = 0; n < n2; ++n) {
            dArray2[n] = 0.0;
            byArray[n] = 1;
        }
        Solver solver = new Solver();
        solver.Solve(n2, new ONE_CLASS_Q(svm_problem2, svm_parameter2), dArray2, byArray, dArray, 1.0, 1.0, svm_parameter2.eps, solutionInfo, svm_parameter2.shrinking);
    }

    private static void solve_epsilon_svr(svm_problem svm_problem2, svm_parameter svm_parameter2, double[] dArray, Solver.SolutionInfo solutionInfo) {
        int n;
        int n2 = svm_problem2.l;
        double[] dArray2 = new double[2 * n2];
        double[] dArray3 = new double[2 * n2];
        byte[] byArray = new byte[2 * n2];
        for (n = 0; n < n2; ++n) {
            dArray2[n] = 0.0;
            dArray3[n] = svm_parameter2.p - svm_problem2.y[n];
            byArray[n] = 1;
            dArray2[n + n2] = 0.0;
            dArray3[n + n2] = svm_parameter2.p + svm_problem2.y[n];
            byArray[n + n2] = -1;
        }
        Solver solver = new Solver();
        solver.Solve(2 * n2, new SVR_Q(svm_problem2, svm_parameter2), dArray3, byArray, dArray2, svm_parameter2.C, svm_parameter2.C, svm_parameter2.eps, solutionInfo, svm_parameter2.shrinking);
        double d = 0.0;
        for (n = 0; n < n2; ++n) {
            dArray[n] = dArray2[n] - dArray2[n + n2];
            d += Math.abs(dArray[n]);
        }
        System.out.print("nu = " + d / (svm_parameter2.C * (double)n2) + "\n");
    }

    private static void solve_nu_svr(svm_problem svm_problem2, svm_parameter svm_parameter2, double[] dArray, Solver.SolutionInfo solutionInfo) {
        int n;
        int n2 = svm_problem2.l;
        double d = svm_parameter2.C;
        double[] dArray2 = new double[2 * n2];
        double[] dArray3 = new double[2 * n2];
        byte[] byArray = new byte[2 * n2];
        double d2 = d * svm_parameter2.nu * (double)n2 / 2.0;
        for (n = 0; n < n2; ++n) {
            double d3 = Math.min(d2, d);
            dArray2[n + n2] = d3;
            dArray2[n] = d3;
            d2 -= dArray2[n];
            dArray3[n] = -svm_problem2.y[n];
            byArray[n] = 1;
            dArray3[n + n2] = svm_problem2.y[n];
            byArray[n + n2] = -1;
        }
        Solver_NU solver_NU = new Solver_NU();
        solver_NU.Solve(2 * n2, new SVR_Q(svm_problem2, svm_parameter2), dArray3, byArray, dArray2, d, d, svm_parameter2.eps, solutionInfo, svm_parameter2.shrinking);
        System.out.print("epsilon = " + -solutionInfo.r + "\n");
        for (n = 0; n < n2; ++n) {
            dArray[n] = dArray2[n] - dArray2[n + n2];
        }
    }

    static decision_function svm_train_one(svm_problem svm_problem2, svm_parameter svm_parameter2, double d, double d2) {
        double[] dArray = new double[svm_problem2.l];
        Solver.SolutionInfo solutionInfo = new Solver.SolutionInfo();
        switch (svm_parameter2.svm_type) {
            case 0: {
                svm.solve_c_svc(svm_problem2, svm_parameter2, dArray, solutionInfo, d, d2);
                break;
            }
            case 1: {
                svm.solve_nu_svc(svm_problem2, svm_parameter2, dArray, solutionInfo);
                break;
            }
            case 2: {
                svm.solve_one_class(svm_problem2, svm_parameter2, dArray, solutionInfo);
                break;
            }
            case 3: {
                svm.solve_epsilon_svr(svm_problem2, svm_parameter2, dArray, solutionInfo);
                break;
            }
            case 4: {
                svm.solve_nu_svr(svm_problem2, svm_parameter2, dArray, solutionInfo);
            }
        }
        System.out.print("obj = " + solutionInfo.obj + ", rho = " + solutionInfo.rho + "\n");
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < svm_problem2.l; ++i) {
            if (!(Math.abs(dArray[i]) > 0.0)) continue;
            ++n;
            if (svm_problem2.y[i] > 0.0) {
                if (!(Math.abs(dArray[i]) >= solutionInfo.upper_bound_p)) continue;
                ++n2;
                continue;
            }
            if (!(Math.abs(dArray[i]) >= solutionInfo.upper_bound_n)) continue;
            ++n2;
        }
        System.out.print("nSV = " + n + ", nBSV = " + n2 + "\n");
        decision_function decision_function2 = new decision_function();
        decision_function2.alpha = dArray;
        decision_function2.rho = solutionInfo.rho;
        return decision_function2;
    }

    private static void sigmoid_train(int n, double[] dArray, double[] dArray2, double[] dArray3) {
        int n2;
        double d;
        int n3;
        double d2 = 0.0;
        double d3 = 0.0;
        for (n3 = 0; n3 < n; ++n3) {
            if (dArray2[n3] > 0.0) {
                d2 += 1.0;
                continue;
            }
            d3 += 1.0;
        }
        int n4 = 100;
        double d4 = 1.0E-10;
        double d5 = 0.001;
        double d6 = 1.0E-5;
        double d7 = (d2 + 1.0) / (d2 + 2.0);
        double d8 = 1.0 / (d3 + 2.0);
        double[] dArray4 = new double[n];
        double d9 = 0.0;
        double d10 = Math.log((d3 + 1.0) / (d2 + 1.0));
        double d11 = 0.0;
        for (n3 = 0; n3 < n; ++n3) {
            dArray4[n3] = dArray2[n3] > 0.0 ? d7 : d8;
            d = dArray[n3] * d9 + d10;
            if (d >= 0.0) {
                d11 += dArray4[n3] * d + Math.log(1.0 + Math.exp(-d));
                continue;
            }
            d11 += (dArray4[n3] - 1.0) * d + Math.log(1.0 + Math.exp(d));
        }
        for (n2 = 0; n2 < n4; ++n2) {
            double d12;
            double d13 = d5;
            double d14 = d5;
            double d15 = 0.0;
            double d16 = 0.0;
            double d17 = 0.0;
            for (n3 = 0; n3 < n; ++n3) {
                double d18;
                double d19;
                d = dArray[n3] * d9 + d10;
                if (d >= 0.0) {
                    d19 = Math.exp(-d) / (1.0 + Math.exp(-d));
                    d18 = 1.0 / (1.0 + Math.exp(-d));
                } else {
                    d19 = 1.0 / (1.0 + Math.exp(d));
                    d18 = Math.exp(d) / (1.0 + Math.exp(d));
                }
                double d20 = d19 * d18;
                d13 += dArray[n3] * dArray[n3] * d20;
                d14 += d20;
                d15 += dArray[n3] * d20;
                double d21 = dArray4[n3] - d19;
                d16 += dArray[n3] * d21;
                d17 += d21;
            }
            if (Math.abs(d16) < d6 && Math.abs(d17) < d6) break;
            double d22 = d13 * d14 - d15 * d15;
            double d23 = -(d14 * d16 - d15 * d17) / d22;
            double d24 = -(-d15 * d16 + d13 * d17) / d22;
            double d25 = d16 * d23 + d17 * d24;
            for (d12 = 1.0; d12 >= d4; d12 /= 2.0) {
                double d26 = d9 + d12 * d23;
                double d27 = d10 + d12 * d24;
                double d28 = 0.0;
                for (n3 = 0; n3 < n; ++n3) {
                    d = dArray[n3] * d26 + d27;
                    if (d >= 0.0) {
                        d28 += dArray4[n3] * d + Math.log(1.0 + Math.exp(-d));
                        continue;
                    }
                    d28 += (dArray4[n3] - 1.0) * d + Math.log(1.0 + Math.exp(d));
                }
                if (!(d28 < d11 + 1.0E-4 * d12 * d25)) continue;
                d9 = d26;
                d10 = d27;
                d11 = d28;
                break;
            }
            if (!(d12 < d4)) continue;
            System.err.print("Line search fails in two-class probability estimates\n");
            break;
        }
        if (n2 >= n4) {
            System.err.print("Reaching maximal iterations in two-class probability estimates\n");
        }
        dArray3[0] = d9;
        dArray3[1] = d10;
    }

    private static double sigmoid_predict(double d, double d2, double d3) {
        double d4 = d * d2 + d3;
        if (d4 >= 0.0) {
            return Math.exp(-d4) / (1.0 + Math.exp(-d4));
        }
        return 1.0 / (1.0 + Math.exp(d4));
    }

    private static void multiclass_probability(int n, double[][] dArray, double[] dArray2) {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = Math.max(100, n);
        double[][] dArray3 = new double[n][n];
        double[] dArray4 = new double[n];
        double d = 0.005 / (double)n;
        for (n3 = 0; n3 < n; ++n3) {
            dArray2[n3] = 1.0 / (double)n;
            dArray3[n3][n3] = 0.0;
            for (n2 = 0; n2 < n3; ++n2) {
                double[] dArray5 = dArray3[n3];
                int n6 = n3;
                dArray5[n6] = dArray5[n6] + dArray[n2][n3] * dArray[n2][n3];
                dArray3[n3][n2] = dArray3[n2][n3];
            }
            for (n2 = n3 + 1; n2 < n; ++n2) {
                double[] dArray6 = dArray3[n3];
                int n7 = n3;
                dArray6[n7] = dArray6[n7] + dArray[n2][n3] * dArray[n2][n3];
                dArray3[n3][n2] = -dArray[n2][n3] * dArray[n3][n2];
            }
        }
        for (n4 = 0; n4 < n5; ++n4) {
            double d2;
            double d3 = 0.0;
            for (n3 = 0; n3 < n; ++n3) {
                dArray4[n3] = 0.0;
                for (n2 = 0; n2 < n; ++n2) {
                    int n8 = n3;
                    dArray4[n8] = dArray4[n8] + dArray3[n3][n2] * dArray2[n2];
                }
                d3 += dArray2[n3] * dArray4[n3];
            }
            double d4 = 0.0;
            for (n3 = 0; n3 < n; ++n3) {
                d2 = Math.abs(dArray4[n3] - d3);
                if (!(d2 > d4)) continue;
                d4 = d2;
            }
            if (d4 < d) break;
            for (n3 = 0; n3 < n; ++n3) {
                d2 = (-dArray4[n3] + d3) / dArray3[n3][n3];
                int n9 = n3;
                dArray2[n9] = dArray2[n9] + d2;
                d3 = (d3 + d2 * (d2 * dArray3[n3][n3] + 2.0 * dArray4[n3])) / (1.0 + d2) / (1.0 + d2);
                n2 = 0;
                while (n2 < n) {
                    dArray4[n2] = (dArray4[n2] + d2 * dArray3[n3][n2]) / (1.0 + d2);
                    int n10 = n2++;
                    dArray2[n10] = dArray2[n10] / (1.0 + d2);
                }
            }
        }
        if (n4 >= n5) {
            System.err.print("Exceeds max_iter in multiclass_prob\n");
        }
    }

    private static void svm_binary_svc_probability(svm_problem svm_problem2, svm_parameter svm_parameter2, double d, double d2, double[] dArray) {
        int n;
        int n2;
        int n3;
        int n4 = 5;
        int[] nArray = new int[svm_problem2.l];
        double[] dArray2 = new double[svm_problem2.l];
        for (n3 = 0; n3 < svm_problem2.l; ++n3) {
            nArray[n3] = n3;
        }
        for (n3 = 0; n3 < svm_problem2.l; ++n3) {
            n2 = n3 + (int)(Math.random() * (double)(svm_problem2.l - n3));
            n = nArray[n3];
            nArray[n3] = nArray[n2];
            nArray[n2] = n;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            int n5;
            n2 = n3 * svm_problem2.l / n4;
            n = (n3 + 1) * svm_problem2.l / n4;
            svm_problem svm_problem3 = new svm_problem();
            svm_problem3.l = svm_problem2.l - (n - n2);
            svm_problem3.x = new svm_node[svm_problem3.l][];
            svm_problem3.y = new double[svm_problem3.l];
            int n6 = 0;
            for (n5 = 0; n5 < n2; ++n5) {
                svm_problem3.x[n6] = svm_problem2.x[nArray[n5]];
                svm_problem3.y[n6] = svm_problem2.y[nArray[n5]];
                ++n6;
            }
            for (n5 = n; n5 < svm_problem2.l; ++n5) {
                svm_problem3.x[n6] = svm_problem2.x[nArray[n5]];
                svm_problem3.y[n6] = svm_problem2.y[nArray[n5]];
                ++n6;
            }
            int n7 = 0;
            int n8 = 0;
            for (n5 = 0; n5 < n6; ++n5) {
                if (svm_problem3.y[n5] > 0.0) {
                    ++n7;
                    continue;
                }
                ++n8;
            }
            if (n7 == 0 && n8 == 0) {
                for (n5 = n2; n5 < n; ++n5) {
                    dArray2[nArray[n5]] = 0.0;
                }
                continue;
            }
            if (n7 > 0 && n8 == 0) {
                for (n5 = n2; n5 < n; ++n5) {
                    dArray2[nArray[n5]] = 1.0;
                }
                continue;
            }
            if (n7 == 0 && n8 > 0) {
                for (n5 = n2; n5 < n; ++n5) {
                    dArray2[nArray[n5]] = -1.0;
                }
                continue;
            }
            svm_parameter svm_parameter3 = (svm_parameter)svm_parameter2.clone();
            svm_parameter3.probability = 0;
            svm_parameter3.C = 1.0;
            svm_parameter3.nr_weight = 2;
            svm_parameter3.weight_label = new int[2];
            svm_parameter3.weight = new double[2];
            svm_parameter3.weight_label[0] = 1;
            svm_parameter3.weight_label[1] = -1;
            svm_parameter3.weight[0] = d;
            svm_parameter3.weight[1] = d2;
            svm_model svm_model2 = svm.svm_train(svm_problem3, svm_parameter3);
            for (n5 = n2; n5 < n; ++n5) {
                double[] dArray3 = new double[1];
                svm.svm_predict_values(svm_model2, svm_problem2.x[nArray[n5]], dArray3);
                dArray2[nArray[n5]] = dArray3[0];
                int n9 = nArray[n5];
                dArray2[n9] = dArray2[n9] * (double)svm_model2.label[0];
            }
        }
        svm.sigmoid_train(svm_problem2.l, dArray2, svm_problem2.y, dArray);
    }

    private static double svm_svr_probability(svm_problem svm_problem2, svm_parameter svm_parameter2) {
        int n;
        int n2 = 5;
        double[] dArray = new double[svm_problem2.l];
        double d = 0.0;
        svm_parameter svm_parameter3 = (svm_parameter)svm_parameter2.clone();
        svm_parameter3.probability = 0;
        svm.svm_cross_validation(svm_problem2, svm_parameter3, n2, dArray);
        for (n = 0; n < svm_problem2.l; ++n) {
            dArray[n] = svm_problem2.y[n] - dArray[n];
            d += Math.abs(dArray[n]);
        }
        double d2 = Math.sqrt(2.0 * (d /= (double)svm_problem2.l) * d);
        int n3 = 0;
        d = 0.0;
        for (n = 0; n < svm_problem2.l; ++n) {
            if (Math.abs(dArray[n]) > 5.0 * d2) {
                ++n3;
                continue;
            }
            d += Math.abs(dArray[n]);
        }
        System.err.print("Prob. model for test data: target value = predicted value + z,\nz: Laplace distribution e^(-|z|/sigma)/(2sigma),sigma=" + (d /= (double)(svm_problem2.l - n3)) + "\n");
        return d;
    }

    private static void svm_group_classes(svm_problem svm_problem2, int[] nArray, int[][] nArray2, int[][] nArray3, int[][] nArray4, int[] nArray5) {
        int n;
        int n2 = svm_problem2.l;
        int n3 = 16;
        int n4 = 0;
        int[] nArray6 = new int[n3];
        int[] nArray7 = new int[n3];
        int[] nArray8 = new int[n2];
        for (n = 0; n < n2; ++n) {
            int n5;
            int n6 = (int)svm_problem2.y[n];
            for (n5 = 0; n5 < n4; ++n5) {
                if (n6 != nArray6[n5]) continue;
                int n7 = n5;
                nArray7[n7] = nArray7[n7] + 1;
                break;
            }
            nArray8[n] = n5;
            if (n5 != n4) continue;
            if (n4 == n3) {
                int[] nArray9 = new int[n3 *= 2];
                System.arraycopy(nArray6, 0, nArray9, 0, nArray6.length);
                nArray6 = nArray9;
                nArray9 = new int[n3];
                System.arraycopy(nArray7, 0, nArray9, 0, nArray7.length);
                nArray7 = nArray9;
            }
            nArray6[n4] = n6;
            nArray7[n4] = 1;
            ++n4;
        }
        int[] nArray10 = new int[n4];
        nArray10[0] = 0;
        for (n = 1; n < n4; ++n) {
            nArray10[n] = nArray10[n - 1] + nArray7[n - 1];
        }
        for (n = 0; n < n2; ++n) {
            nArray5[nArray10[nArray8[n]]] = n;
            int n8 = nArray8[n];
            nArray10[n8] = nArray10[n8] + 1;
        }
        nArray10[0] = 0;
        for (n = 1; n < n4; ++n) {
            nArray10[n] = nArray10[n - 1] + nArray7[n - 1];
        }
        nArray[0] = n4;
        nArray2[0] = nArray6;
        nArray3[0] = nArray10;
        nArray4[0] = nArray7;
    }

    public static svm_model svm_train(svm_problem svm_problem2, svm_parameter svm_parameter2) {
        svm_model svm_model2 = new svm_model();
        svm_model2.param = svm_parameter2;
        if (svm_parameter2.svm_type == 2 || svm_parameter2.svm_type == 3 || svm_parameter2.svm_type == 4) {
            int n;
            svm_model2.nr_class = 2;
            svm_model2.label = null;
            svm_model2.nSV = null;
            svm_model2.probA = null;
            svm_model2.probB = null;
            svm_model2.sv_coef = new double[1][];
            if (svm_parameter2.probability == 1 && (svm_parameter2.svm_type == 3 || svm_parameter2.svm_type == 4)) {
                svm_model2.probA = new double[1];
                svm_model2.probA[0] = svm.svm_svr_probability(svm_problem2, svm_parameter2);
            }
            decision_function decision_function2 = svm.svm_train_one(svm_problem2, svm_parameter2, 0.0, 0.0);
            svm_model2.rho = new double[1];
            svm_model2.rho[0] = decision_function2.rho;
            int n2 = 0;
            for (n = 0; n < svm_problem2.l; ++n) {
                if (!(Math.abs(decision_function2.alpha[n]) > 0.0)) continue;
                ++n2;
            }
            svm_model2.l = n2;
            svm_model2.SV = new svm_node[n2][];
            svm_model2.sv_coef[0] = new double[n2];
            int n3 = 0;
            for (n = 0; n < svm_problem2.l; ++n) {
                if (!(Math.abs(decision_function2.alpha[n]) > 0.0)) continue;
                svm_model2.SV[n3] = svm_problem2.x[n];
                svm_model2.sv_coef[0][n3] = decision_function2.alpha[n];
                ++n3;
            }
        } else {
            int n;
            int n4;
            int n5;
            int n6;
            int n7;
            Object object;
            int n8;
            int n9;
            int n10 = svm_problem2.l;
            int[] nArray = new int[1];
            int[][] nArrayArray = new int[1][];
            int[][] nArrayArray2 = new int[1][];
            int[][] nArrayArray3 = new int[1][];
            int[] nArray2 = new int[n10];
            svm.svm_group_classes(svm_problem2, nArray, nArrayArray, nArrayArray2, nArrayArray3, nArray2);
            int n11 = nArray[0];
            int[] nArray3 = nArrayArray[0];
            int[] nArray4 = nArrayArray2[0];
            int[] nArray5 = nArrayArray3[0];
            svm_node[][] svm_nodeArrayArray = new svm_node[n10][];
            for (n9 = 0; n9 < n10; ++n9) {
                svm_nodeArrayArray[n9] = svm_problem2.x[nArray2[n9]];
            }
            double[] dArray = new double[n11];
            for (n9 = 0; n9 < n11; ++n9) {
                dArray[n9] = svm_parameter2.C;
            }
            for (n9 = 0; n9 < svm_parameter2.nr_weight; ++n9) {
                int n12;
                for (n12 = 0; n12 < n11 && svm_parameter2.weight_label[n9] != nArray3[n12]; ++n12) {
                }
                if (n12 == n11) {
                    System.err.print("warning: class label " + svm_parameter2.weight_label[n9] + " specified in weight is not found\n");
                    continue;
                }
                int n13 = n12;
                dArray[n13] = dArray[n13] * svm_parameter2.weight[n9];
            }
            boolean[] blArray = new boolean[n10];
            for (n9 = 0; n9 < n10; ++n9) {
                blArray[n9] = false;
            }
            decision_function[] decision_functionArray = new decision_function[n11 * (n11 - 1) / 2];
            double[] dArray2 = null;
            double[] dArray3 = null;
            if (svm_parameter2.probability == 1) {
                dArray2 = new double[n11 * (n11 - 1) / 2];
                dArray3 = new double[n11 * (n11 - 1) / 2];
            }
            int n14 = 0;
            for (n9 = 0; n9 < n11; ++n9) {
                for (n8 = n9 + 1; n8 < n11; ++n8) {
                    object = new svm_problem();
                    n7 = nArray4[n9];
                    n6 = nArray4[n8];
                    n5 = nArray5[n9];
                    n4 = nArray5[n8];
                    ((svm_problem)object).l = n5 + n4;
                    ((svm_problem)object).x = new svm_node[((svm_problem)object).l][];
                    ((svm_problem)object).y = new double[((svm_problem)object).l];
                    for (n = 0; n < n5; ++n) {
                        ((svm_problem)object).x[n] = svm_nodeArrayArray[n7 + n];
                        ((svm_problem)object).y[n] = 1.0;
                    }
                    for (n = 0; n < n4; ++n) {
                        ((svm_problem)object).x[n5 + n] = svm_nodeArrayArray[n6 + n];
                        ((svm_problem)object).y[n5 + n] = -1.0;
                    }
                    if (svm_parameter2.probability == 1) {
                        double[] dArray4 = new double[2];
                        svm.svm_binary_svc_probability((svm_problem)object, svm_parameter2, dArray[n9], dArray[n8], dArray4);
                        dArray2[n14] = dArray4[0];
                        dArray3[n14] = dArray4[1];
                    }
                    decision_functionArray[n14] = svm.svm_train_one((svm_problem)object, svm_parameter2, dArray[n9], dArray[n8]);
                    for (n = 0; n < n5; ++n) {
                        if (blArray[n7 + n] || !(Math.abs(decision_functionArray[n14].alpha[n]) > 0.0)) continue;
                        blArray[n7 + n] = true;
                    }
                    for (n = 0; n < n4; ++n) {
                        if (blArray[n6 + n] || !(Math.abs(decision_functionArray[n14].alpha[n5 + n]) > 0.0)) continue;
                        blArray[n6 + n] = true;
                    }
                    ++n14;
                }
            }
            svm_model2.nr_class = n11;
            svm_model2.label = new int[n11];
            for (n9 = 0; n9 < n11; ++n9) {
                svm_model2.label[n9] = nArray3[n9];
            }
            svm_model2.rho = new double[n11 * (n11 - 1) / 2];
            for (n9 = 0; n9 < n11 * (n11 - 1) / 2; ++n9) {
                svm_model2.rho[n9] = decision_functionArray[n9].rho;
            }
            if (svm_parameter2.probability == 1) {
                svm_model2.probA = new double[n11 * (n11 - 1) / 2];
                svm_model2.probB = new double[n11 * (n11 - 1) / 2];
                for (n9 = 0; n9 < n11 * (n11 - 1) / 2; ++n9) {
                    svm_model2.probA[n9] = dArray2[n9];
                    svm_model2.probB[n9] = dArray3[n9];
                }
            } else {
                svm_model2.probA = null;
                svm_model2.probB = null;
            }
            n8 = 0;
            object = new int[n11];
            svm_model2.nSV = new int[n11];
            for (n9 = 0; n9 < n11; ++n9) {
                n7 = 0;
                for (n6 = 0; n6 < nArray5[n9]; ++n6) {
                    if (!blArray[nArray4[n9] + n6]) continue;
                    ++n7;
                    ++n8;
                }
                svm_model2.nSV[n9] = n7;
                object[n9] = n7;
            }
            System.out.print("Total nSV = " + n8 + "\n");
            svm_model2.l = n8;
            svm_model2.SV = new svm_node[n8][];
            n14 = 0;
            for (n9 = 0; n9 < n10; ++n9) {
                if (!blArray[n9]) continue;
                svm_model2.SV[n14++] = svm_nodeArrayArray[n9];
            }
            int[] nArray6 = new int[n11];
            nArray6[0] = 0;
            for (n9 = 1; n9 < n11; ++n9) {
                nArray6[n9] = nArray6[n9 - 1] + object[n9 - 1];
            }
            svm_model2.sv_coef = new double[n11 - 1][];
            for (n9 = 0; n9 < n11 - 1; ++n9) {
                svm_model2.sv_coef[n9] = new double[n8];
            }
            n14 = 0;
            for (n9 = 0; n9 < n11; ++n9) {
                for (n6 = n9 + 1; n6 < n11; ++n6) {
                    int n15;
                    n5 = nArray4[n9];
                    n4 = nArray4[n6];
                    n = nArray5[n9];
                    int n16 = nArray5[n6];
                    int n17 = nArray6[n9];
                    for (n15 = 0; n15 < n; ++n15) {
                        if (!blArray[n5 + n15]) continue;
                        svm_model2.sv_coef[n6 - 1][n17++] = decision_functionArray[n14].alpha[n15];
                    }
                    n17 = nArray6[n6];
                    for (n15 = 0; n15 < n16; ++n15) {
                        if (!blArray[n4 + n15]) continue;
                        svm_model2.sv_coef[n9][n17++] = decision_functionArray[n14].alpha[n + n15];
                    }
                    ++n14;
                }
            }
        }
        return svm_model2;
    }

    public static void svm_cross_validation(svm_problem svm_problem2, svm_parameter svm_parameter2, int n, double[] dArray) {
        int n2;
        Object[] objectArray;
        Object object;
        int[] nArray = new int[n + 1];
        int n3 = svm_problem2.l;
        int[] nArray2 = new int[n3];
        if ((svm_parameter2.svm_type == 0 || svm_parameter2.svm_type == 1) && n < n3) {
            int n4;
            int n5;
            int n6;
            int[] nArray3 = new int[1];
            int[][] nArrayArray = new int[1][];
            int[][] nArrayArray2 = new int[1][];
            int[][] nArrayArray3 = new int[1][];
            svm.svm_group_classes(svm_problem2, nArray3, nArrayArray, nArrayArray2, nArrayArray3, nArray2);
            int n7 = nArray3[0];
            object = nArrayArray[0];
            objectArray = nArrayArray2[0];
            int[] nArray4 = nArrayArray3[0];
            int[] nArray5 = new int[n];
            int[] nArray6 = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray6[n2] = nArray2[n2];
            }
            for (n6 = 0; n6 < n7; ++n6) {
                for (n2 = 0; n2 < nArray4[n6]; ++n2) {
                    n5 = n2 + (int)(Math.random() * (double)(nArray4[n6] - n2));
                    n4 = nArray6[objectArray[n6] + n5];
                    nArray6[objectArray[n6] + n5] = nArray6[objectArray[n6] + n2];
                    nArray6[objectArray[n6] + n2] = n4;
                }
            }
            for (n2 = 0; n2 < n; ++n2) {
                nArray5[n2] = 0;
                for (n6 = 0; n6 < n7; ++n6) {
                    int n8 = n2;
                    nArray5[n8] = nArray5[n8] + ((n2 + 1) * nArray4[n6] / n - n2 * nArray4[n6] / n);
                }
            }
            nArray[0] = 0;
            for (n2 = 1; n2 <= n; ++n2) {
                nArray[n2] = nArray[n2 - 1] + nArray5[n2 - 1];
            }
            for (n6 = 0; n6 < n7; ++n6) {
                for (n2 = 0; n2 < n; ++n2) {
                    n5 = objectArray[n6] + n2 * nArray4[n6] / n;
                    n4 = objectArray[n6] + (n2 + 1) * nArray4[n6] / n;
                    for (int i = n5; i < n4; ++i) {
                        nArray2[nArray[n2]] = nArray6[i];
                        int n9 = n2;
                        nArray[n9] = nArray[n9] + 1;
                    }
                }
            }
            nArray[0] = 0;
            for (n2 = 1; n2 <= n; ++n2) {
                nArray[n2] = nArray[n2 - 1] + nArray5[n2 - 1];
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                nArray2[n2] = n2;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                int n10 = n2 + (int)(Math.random() * (double)(n3 - n2));
                int n11 = nArray2[n2];
                nArray2[n2] = nArray2[n10];
                nArray2[n10] = n11;
            }
            for (n2 = 0; n2 <= n; ++n2) {
                nArray[n2] = n2 * n3 / n;
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            int n12;
            int n13 = nArray[n2];
            int n14 = nArray[n2 + 1];
            svm_problem svm_problem3 = new svm_problem();
            svm_problem3.l = n3 - (n14 - n13);
            svm_problem3.x = new svm_node[svm_problem3.l][];
            svm_problem3.y = new double[svm_problem3.l];
            int n15 = 0;
            for (n12 = 0; n12 < n13; ++n12) {
                svm_problem3.x[n15] = svm_problem2.x[nArray2[n12]];
                svm_problem3.y[n15] = svm_problem2.y[nArray2[n12]];
                ++n15;
            }
            for (n12 = n14; n12 < n3; ++n12) {
                svm_problem3.x[n15] = svm_problem2.x[nArray2[n12]];
                svm_problem3.y[n15] = svm_problem2.y[nArray2[n12]];
                ++n15;
            }
            object = svm.svm_train(svm_problem3, svm_parameter2);
            if (svm_parameter2.probability == 1 && (svm_parameter2.svm_type == 0 || svm_parameter2.svm_type == 1)) {
                objectArray = new double[svm.svm_get_nr_class((svm_model)object)];
                for (n12 = n13; n12 < n14; ++n12) {
                    dArray[nArray2[n12]] = svm.svm_predict_probability((svm_model)object, svm_problem2.x[nArray2[n12]], objectArray);
                }
                continue;
            }
            for (n12 = n13; n12 < n14; ++n12) {
                dArray[nArray2[n12]] = svm.svm_predict((svm_model)object, svm_problem2.x[nArray2[n12]]);
            }
        }
    }

    public static int svm_get_svm_type(svm_model svm_model2) {
        return svm_model2.param.svm_type;
    }

    public static int svm_get_nr_class(svm_model svm_model2) {
        return svm_model2.nr_class;
    }

    public static void svm_get_labels(svm_model svm_model2, int[] nArray) {
        if (svm_model2.label != null) {
            for (int i = 0; i < svm_model2.nr_class; ++i) {
                nArray[i] = svm_model2.label[i];
            }
        }
    }

    public static double svm_get_svr_probability(svm_model svm_model2) {
        if ((svm_model2.param.svm_type == 3 || svm_model2.param.svm_type == 4) && svm_model2.probA != null) {
            return svm_model2.probA[0];
        }
        System.err.print("Model doesn't contain information for SVR probability inference\n");
        return 0.0;
    }

    public static void svm_predict_values(svm_model svm_model2, svm_node[] svm_nodeArray, double[] dArray) {
        if (svm_model2.param.svm_type == 2 || svm_model2.param.svm_type == 3 || svm_model2.param.svm_type == 4) {
            double[] dArray2 = svm_model2.sv_coef[0];
            double d = 0.0;
            for (int i = 0; i < svm_model2.l; ++i) {
                d += dArray2[i] * Kernel.k_function(svm_nodeArray, svm_model2.SV[i], svm_model2.param);
            }
            dArray[0] = d -= svm_model2.rho[0];
        } else {
            int n;
            int n2 = svm_model2.nr_class;
            int n3 = svm_model2.l;
            double[] dArray3 = new double[n3];
            for (n = 0; n < n3; ++n) {
                dArray3[n] = Kernel.k_function(svm_nodeArray, svm_model2.SV[n], svm_model2.param);
            }
            int[] nArray = new int[n2];
            nArray[0] = 0;
            for (n = 1; n < n2; ++n) {
                nArray[n] = nArray[n - 1] + svm_model2.nSV[n - 1];
            }
            int n4 = 0;
            for (n = 0; n < n2; ++n) {
                for (int i = n + 1; i < n2; ++i) {
                    int n5;
                    double d = 0.0;
                    int n6 = nArray[n];
                    int n7 = nArray[i];
                    int n8 = svm_model2.nSV[n];
                    int n9 = svm_model2.nSV[i];
                    double[] dArray4 = svm_model2.sv_coef[i - 1];
                    double[] dArray5 = svm_model2.sv_coef[n];
                    for (n5 = 0; n5 < n8; ++n5) {
                        d += dArray4[n6 + n5] * dArray3[n6 + n5];
                    }
                    for (n5 = 0; n5 < n9; ++n5) {
                        d += dArray5[n7 + n5] * dArray3[n7 + n5];
                    }
                    dArray[n4] = d -= svm_model2.rho[n4];
                    ++n4;
                }
            }
        }
    }

    public static double svm_predict(svm_model svm_model2, svm_node[] svm_nodeArray) {
        int n;
        int n2;
        if (svm_model2.param.svm_type == 2 || svm_model2.param.svm_type == 3 || svm_model2.param.svm_type == 4) {
            double[] dArray = new double[1];
            svm.svm_predict_values(svm_model2, svm_nodeArray, dArray);
            if (svm_model2.param.svm_type == 2) {
                return dArray[0] > 0.0 ? 1.0 : -1.0;
            }
            return dArray[0];
        }
        int n3 = svm_model2.nr_class;
        double[] dArray = new double[n3 * (n3 - 1) / 2];
        svm.svm_predict_values(svm_model2, svm_nodeArray, dArray);
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = 0;
        }
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = n2 + 1; n < n3; ++n) {
                int n5 = n4++;
                if (dArray[n5] > 0.0) {
                    int n6 = n2;
                    nArray[n6] = nArray[n6] + 1;
                    continue;
                }
                int n7 = n;
                nArray[n7] = nArray[n7] + 1;
            }
        }
        n = 0;
        for (n2 = 1; n2 < n3; ++n2) {
            if (nArray[n2] <= nArray[n]) continue;
            n = n2;
        }
        return svm_model2.label[n];
    }

    public static double svm_predict_probability(svm_model svm_model2, svm_node[] svm_nodeArray, double[] dArray) {
        if ((svm_model2.param.svm_type == 0 || svm_model2.param.svm_type == 1) && svm_model2.probA != null && svm_model2.probB != null) {
            int n;
            int n2;
            int n3 = svm_model2.nr_class;
            double[] dArray2 = new double[n3 * (n3 - 1) / 2];
            svm.svm_predict_values(svm_model2, svm_nodeArray, dArray2);
            double d = 1.0E-7;
            double[][] dArray3 = new double[n3][n3];
            int n4 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = n2 + 1; n < n3; ++n) {
                    dArray3[n2][n] = Math.min(Math.max(svm.sigmoid_predict(dArray2[n4], svm_model2.probA[n4], svm_model2.probB[n4]), d), 1.0 - d);
                    dArray3[n][n2] = 1.0 - dArray3[n2][n];
                    ++n4;
                }
            }
            svm.multiclass_probability(n3, dArray3, dArray);
            n = 0;
            for (n2 = 1; n2 < n3; ++n2) {
                if (!(dArray[n2] > dArray[n])) continue;
                n = n2;
            }
            return svm_model2.label[n];
        }
        return svm.svm_predict(svm_model2, svm_nodeArray);
    }

    public static void svm_save_model(String string2, svm_model svm_model2) throws IOException {
        int n;
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string2));
        svm_parameter svm_parameter2 = svm_model2.param;
        dataOutputStream.writeBytes("svm_type " + svm_type_table[svm_parameter2.svm_type] + "\n");
        dataOutputStream.writeBytes("kernel_type " + kernel_type_table[svm_parameter2.kernel_type] + "\n");
        if (svm_parameter2.kernel_type == 1) {
            dataOutputStream.writeBytes("degree " + svm_parameter2.degree + "\n");
        }
        if (svm_parameter2.kernel_type == 1 || svm_parameter2.kernel_type == 2 || svm_parameter2.kernel_type == 3) {
            dataOutputStream.writeBytes("gamma " + svm_parameter2.gamma + "\n");
        }
        if (svm_parameter2.kernel_type == 1 || svm_parameter2.kernel_type == 3) {
            dataOutputStream.writeBytes("coef0 " + svm_parameter2.coef0 + "\n");
        }
        int n2 = svm_model2.nr_class;
        int n3 = svm_model2.l;
        dataOutputStream.writeBytes("nr_class " + n2 + "\n");
        dataOutputStream.writeBytes("total_sv " + n3 + "\n");
        dataOutputStream.writeBytes("rho");
        for (n = 0; n < n2 * (n2 - 1) / 2; ++n) {
            dataOutputStream.writeBytes(" " + svm_model2.rho[n]);
        }
        dataOutputStream.writeBytes("\n");
        if (svm_model2.label != null) {
            dataOutputStream.writeBytes("label");
            for (n = 0; n < n2; ++n) {
                dataOutputStream.writeBytes(" " + svm_model2.label[n]);
            }
            dataOutputStream.writeBytes("\n");
        }
        if (svm_model2.probA != null) {
            dataOutputStream.writeBytes("probA");
            for (n = 0; n < n2 * (n2 - 1) / 2; ++n) {
                dataOutputStream.writeBytes(" " + svm_model2.probA[n]);
            }
            dataOutputStream.writeBytes("\n");
        }
        if (svm_model2.probB != null) {
            dataOutputStream.writeBytes("probB");
            for (n = 0; n < n2 * (n2 - 1) / 2; ++n) {
                dataOutputStream.writeBytes(" " + svm_model2.probB[n]);
            }
            dataOutputStream.writeBytes("\n");
        }
        if (svm_model2.nSV != null) {
            dataOutputStream.writeBytes("nr_sv");
            for (n = 0; n < n2; ++n) {
                dataOutputStream.writeBytes(" " + svm_model2.nSV[n]);
            }
            dataOutputStream.writeBytes("\n");
        }
        dataOutputStream.writeBytes("SV\n");
        double[][] dArray = svm_model2.sv_coef;
        svm_node[][] svm_nodeArray = svm_model2.SV;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2 - 1; ++j) {
                dataOutputStream.writeBytes(dArray[j][i] + " ");
            }
            svm_node[] svm_nodeArray2 = svm_nodeArray[i];
            if (svm_parameter2.kernel_type == 4) {
                dataOutputStream.writeBytes("0:" + (int)svm_nodeArray2[0].value);
            } else {
                for (int j = 0; j < svm_nodeArray2.length; ++j) {
                    dataOutputStream.writeBytes(svm_nodeArray2[j].index + ":" + svm_nodeArray2[j].value + " ");
                }
            }
            dataOutputStream.writeBytes("\n");
        }
        dataOutputStream.close();
    }

    private static double atof(String string2) {
        return Double.valueOf(string2);
    }

    private static int atoi(String string2) {
        return Integer.parseInt(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static svm_model svm_load_model(String string2) throws IOException {
        Object object;
        int n;
        svm_model svm_model2;
        BufferedReader bufferedReader;
        block25: {
            svm_parameter svm_parameter2;
            bufferedReader = new BufferedReader(new FileReader(string2));
            svm_model2 = new svm_model();
            svm_model2.param = svm_parameter2 = new svm_parameter();
            svm_model2.rho = null;
            svm_model2.probA = null;
            svm_model2.probB = null;
            svm_model2.label = null;
            svm_model2.nSV = null;
            block0: while (true) {
                String string3;
                block28: {
                    block27: {
                        String string4;
                        block26: {
                            string4 = bufferedReader.readLine();
                            string3 = string4.substring(string4.indexOf(32) + 1);
                            if (!string4.startsWith("svm_type")) break block26;
                            break block27;
                        }
                        if (string4.startsWith("kernel_type")) {
                            break block28;
                        } else {
                            int n2;
                            if (string4.startsWith("degree")) {
                                svm_parameter2.degree = svm.atoi(string3);
                                continue;
                            }
                            if (string4.startsWith("gamma")) {
                                svm_parameter2.gamma = svm.atof(string3);
                                continue;
                            }
                            if (string4.startsWith("coef0")) {
                                svm_parameter2.coef0 = svm.atof(string3);
                                continue;
                            }
                            if (string4.startsWith("nr_class")) {
                                svm_model2.nr_class = svm.atoi(string3);
                                continue;
                            }
                            if (string4.startsWith("total_sv")) {
                                svm_model2.l = svm.atoi(string3);
                                continue;
                            }
                            if (string4.startsWith("rho")) {
                                n = svm_model2.nr_class * (svm_model2.nr_class - 1) / 2;
                                svm_model2.rho = new double[n];
                                object = new StringTokenizer(string3);
                                n2 = 0;
                                while (true) {
                                    if (n2 >= n) continue block0;
                                    svm_model2.rho[n2] = svm.atof(((StringTokenizer)object).nextToken());
                                    ++n2;
                                }
                            }
                            if (string4.startsWith("label")) {
                                n = svm_model2.nr_class;
                                svm_model2.label = new int[n];
                                object = new StringTokenizer(string3);
                                n2 = 0;
                                while (true) {
                                    if (n2 >= n) continue block0;
                                    svm_model2.label[n2] = svm.atoi(((StringTokenizer)object).nextToken());
                                    ++n2;
                                }
                            }
                            if (string4.startsWith("probA")) {
                                n = svm_model2.nr_class * (svm_model2.nr_class - 1) / 2;
                                svm_model2.probA = new double[n];
                                object = new StringTokenizer(string3);
                                n2 = 0;
                                while (true) {
                                    if (n2 >= n) continue block0;
                                    svm_model2.probA[n2] = svm.atof(((StringTokenizer)object).nextToken());
                                    ++n2;
                                }
                            }
                            if (string4.startsWith("probB")) {
                                n = svm_model2.nr_class * (svm_model2.nr_class - 1) / 2;
                                svm_model2.probB = new double[n];
                                object = new StringTokenizer(string3);
                                n2 = 0;
                                while (true) {
                                    if (n2 >= n) continue block0;
                                    svm_model2.probB[n2] = svm.atof(((StringTokenizer)object).nextToken());
                                    ++n2;
                                }
                            }
                            if (string4.startsWith("nr_sv")) {
                                n = svm_model2.nr_class;
                                svm_model2.nSV = new int[n];
                                object = new StringTokenizer(string3);
                                n2 = 0;
                                while (true) {
                                    if (n2 >= n) continue block0;
                                    svm_model2.nSV[n2] = svm.atoi(((StringTokenizer)object).nextToken());
                                    ++n2;
                                }
                            }
                            if (!string4.startsWith("SV")) {
                                System.err.print("unknown text in model file: [" + string4 + "]\n");
                                return null;
                            }
                            break block25;
                        }
                    }
                    for (n = 0; n < svm_type_table.length; ++n) {
                        if (string3.indexOf(svm_type_table[n]) == -1) continue;
                        svm_parameter2.svm_type = n;
                        break;
                    }
                    if (n != svm_type_table.length) continue;
                    System.err.print("unknown svm type.\n");
                    return null;
                }
                for (n = 0; n < kernel_type_table.length; ++n) {
                    if (string3.indexOf(kernel_type_table[n]) == -1) continue;
                    svm_parameter2.kernel_type = n;
                    break;
                }
                if (n == kernel_type_table.length) break;
            }
            System.err.print("unknown kernel function.\n");
            return null;
        }
        int n3 = svm_model2.nr_class - 1;
        int n4 = svm_model2.l;
        svm_model2.sv_coef = new double[n3][n4];
        svm_model2.SV = new svm_node[n4][];
        n = 0;
        while (true) {
            int n5;
            if (n >= n4) {
                bufferedReader.close();
                return svm_model2;
            }
            object = bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, " \t\n\r\f:");
            for (n5 = 0; n5 < n3; ++n5) {
                svm_model2.sv_coef[n5][n] = svm.atof(stringTokenizer.nextToken());
            }
            n5 = stringTokenizer.countTokens() / 2;
            svm_model2.SV[n] = new svm_node[n5];
            for (int i = 0; i < n5; ++i) {
                svm_model2.SV[n][i] = new svm_node();
                svm_model2.SV[n][i].index = svm.atoi(stringTokenizer.nextToken());
                svm_model2.SV[n][i].value = svm.atof(stringTokenizer.nextToken());
            }
            ++n;
        }
    }

    public static String svm_check_parameter(svm_problem svm_problem2, svm_parameter svm_parameter2) {
        int n = svm_parameter2.svm_type;
        if (n != 0 && n != 1 && n != 2 && n != 3 && n != 4) {
            return "unknown svm type";
        }
        int n2 = svm_parameter2.kernel_type;
        if (n2 != 0 && n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4) {
            return "unknown kernel type";
        }
        if (svm_parameter2.degree < 0) {
            return "degree of polynomial kernel < 0";
        }
        if (svm_parameter2.cache_size <= 0.0) {
            return "cache_size <= 0";
        }
        if (svm_parameter2.eps <= 0.0) {
            return "eps <= 0";
        }
        if ((n == 0 || n == 3 || n == 4) && svm_parameter2.C <= 0.0) {
            return "C <= 0";
        }
        if ((n == 1 || n == 2 || n == 4) && (svm_parameter2.nu <= 0.0 || svm_parameter2.nu > 1.0)) {
            return "nu <= 0 or nu > 1";
        }
        if (n == 3 && svm_parameter2.p < 0.0) {
            return "p < 0";
        }
        if (svm_parameter2.shrinking != 0 && svm_parameter2.shrinking != 1) {
            return "shrinking != 0 and shrinking != 1";
        }
        if (svm_parameter2.probability != 0 && svm_parameter2.probability != 1) {
            return "probability != 0 and probability != 1";
        }
        if (svm_parameter2.probability == 1 && n == 2) {
            return "one-class SVM probability output not supported yet";
        }
        if (n == 1) {
            int n3;
            int n4;
            int n5;
            int n6 = svm_problem2.l;
            int n7 = 16;
            int n8 = 0;
            int[] nArray = new int[n7];
            int[] nArray2 = new int[n7];
            for (n5 = 0; n5 < n6; ++n5) {
                n4 = (int)svm_problem2.y[n5];
                for (n3 = 0; n3 < n8; ++n3) {
                    if (n4 != nArray[n3]) continue;
                    int n9 = n3;
                    nArray2[n9] = nArray2[n9] + 1;
                    break;
                }
                if (n3 != n8) continue;
                if (n8 == n7) {
                    int[] nArray3 = new int[n7 *= 2];
                    System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
                    nArray = nArray3;
                    nArray3 = new int[n7];
                    System.arraycopy(nArray2, 0, nArray3, 0, nArray2.length);
                    nArray2 = nArray3;
                }
                nArray[n8] = n4;
                nArray2[n8] = 1;
                ++n8;
            }
            for (n5 = 0; n5 < n8; ++n5) {
                n4 = nArray2[n5];
                for (n3 = n5 + 1; n3 < n8; ++n3) {
                    int n10 = nArray2[n3];
                    if (!(svm_parameter2.nu * (double)(n4 + n10) / 2.0 > (double)Math.min(n4, n10))) continue;
                    return "specified nu is infeasible";
                }
            }
        }
        return null;
    }

    public static int svm_check_probability_model(svm_model svm_model2) {
        if ((svm_model2.param.svm_type == 0 || svm_model2.param.svm_type == 1) && svm_model2.probA != null && svm_model2.probB != null || (svm_model2.param.svm_type == 3 || svm_model2.param.svm_type == 4) && svm_model2.probA != null) {
            return 1;
        }
        return 0;
    }

    static class decision_function {
        double[] alpha;
        double rho;

        decision_function() {
        }
    }
}

