/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.HighLowDataset;
import org.jfree.data.XYDataset;

public class HighLowToolTipGenerator
implements XYToolTipGenerator,
Cloneable,
Serializable {
    private DateFormat dateFormatter;

    public HighLowToolTipGenerator() {
        this(DateFormat.getInstance());
    }

    public HighLowToolTipGenerator(DateFormat dateFormat) {
        this.dateFormatter = dateFormat;
    }

    public String generateToolTip(XYDataset xYDataset, int n, int n2) {
        String string2 = null;
        if (xYDataset instanceof HighLowDataset) {
            HighLowDataset highLowDataset = (HighLowDataset)xYDataset;
            Number number = highLowDataset.getHighValue(n, n2);
            Number number2 = highLowDataset.getLowValue(n, n2);
            Number number3 = highLowDataset.getOpenValue(n, n2);
            Number number4 = highLowDataset.getCloseValue(n, n2);
            Number number5 = highLowDataset.getXValue(n, n2);
            string2 = highLowDataset.getSeriesName(n);
            if (number5 != null) {
                Date date = new Date(number5.longValue());
                string2 = string2 + "--> Date=" + this.dateFormatter.format(date);
                if (number != null) {
                    string2 = string2 + " High=" + number.toString();
                }
                if (number2 != null) {
                    string2 = string2 + " Low=" + number2.toString();
                }
                if (number3 != null) {
                    string2 = string2 + " Open=" + number3.toString();
                }
                if (number4 != null) {
                    string2 = string2 + " Close=" + number4.toString();
                }
            }
        }
        return string2;
    }

    public Object clone() throws CloneNotSupportedException {
        HighLowToolTipGenerator highLowToolTipGenerator = (HighLowToolTipGenerator)super.clone();
        if (this.dateFormatter != null) {
            highLowToolTipGenerator.dateFormatter = (DateFormat)this.dateFormatter.clone();
        }
        return highLowToolTipGenerator;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof HighLowToolTipGenerator) {
            HighLowToolTipGenerator highLowToolTipGenerator = (HighLowToolTipGenerator)object;
            return this.dateFormatter.equals(highLowToolTipGenerator.dateFormatter);
        }
        return false;
    }
}

