/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jfree.chart.labels.ContourToolTipGenerator;
import org.jfree.data.ContourDataset;

public class StandardContourToolTipGenerator
implements ContourToolTipGenerator,
Serializable {
    private DecimalFormat valueForm = new DecimalFormat("##.###");

    public String generateToolTip(ContourDataset contourDataset, int n) {
        Number number = contourDataset.getXValue(0, n);
        Number number2 = contourDataset.getYValue(0, n);
        Number number3 = contourDataset.getZValue(0, n);
        String string2 = null;
        if (contourDataset.isDateAxis(0)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer = simpleDateFormat.format(new Date(number.longValue()), stringBuffer, new FieldPosition(0));
            string2 = stringBuffer.toString();
        } else {
            string2 = this.valueForm.format(number.doubleValue());
        }
        if (number3 != null) {
            return "X: " + string2 + ", Y: " + this.valueForm.format(number2.doubleValue()) + ", Z: " + this.valueForm.format(number3.doubleValue());
        }
        return "X: " + string2 + ", Y: " + this.valueForm.format(number2.doubleValue()) + ", Z: no data";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof StandardContourToolTipGenerator) {
            StandardContourToolTipGenerator standardContourToolTipGenerator = (StandardContourToolTipGenerator)object;
            if (this.valueForm != null) {
                return this.valueForm.equals(standardContourToolTipGenerator.valueForm);
            }
        }
        return false;
    }
}

