/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.NumberFormat;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.XYDataset;

public class StandardXYToolTipGenerator
implements XYToolTipGenerator,
Cloneable,
Serializable {
    private NumberFormat xFormat;
    private NumberFormat yFormat;

    public StandardXYToolTipGenerator() {
        this(NumberFormat.getNumberInstance(), NumberFormat.getNumberInstance());
    }

    public StandardXYToolTipGenerator(NumberFormat numberFormat, NumberFormat numberFormat2) {
        this.xFormat = numberFormat;
        this.yFormat = numberFormat2;
    }

    public NumberFormat getXFormat() {
        return this.xFormat;
    }

    public NumberFormat getYFormat() {
        return this.yFormat;
    }

    public String generateToolTip(XYDataset xYDataset, int n, int n2) {
        String string2 = xYDataset.getSeriesName(n) + ": ";
        Number number = xYDataset.getXValue(n, n2);
        string2 = string2 + "x: " + this.xFormat.format(number);
        Number number2 = xYDataset.getYValue(n, n2);
        string2 = number2 != null ? string2 + ", y: " + this.yFormat.format(number2) : string2 + ", y: null";
        return string2;
    }

    public Object clone() throws CloneNotSupportedException {
        StandardXYToolTipGenerator standardXYToolTipGenerator = (StandardXYToolTipGenerator)super.clone();
        if (this.xFormat != null) {
            standardXYToolTipGenerator.xFormat = (NumberFormat)this.xFormat.clone();
        }
        if (this.yFormat != null) {
            standardXYToolTipGenerator.yFormat = (NumberFormat)this.yFormat.clone();
        }
        return standardXYToolTipGenerator;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof StandardXYToolTipGenerator) {
            StandardXYToolTipGenerator standardXYToolTipGenerator = (StandardXYToolTipGenerator)object;
            return this.xFormat.equals(standardXYToolTipGenerator.getXFormat()) && this.yFormat.equals(standardXYToolTipGenerator.getYFormat());
        }
        return false;
    }
}

